/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.EvaluateContext;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLiteral;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;
import prism.PrismUtils;

public class ConstantList
extends ASTElement {
    private ArrayList<String> names = new ArrayList();
    private ArrayList<Expression> constants = new ArrayList();
    private ArrayList<Type> types = new ArrayList();
    private ArrayList<ExpressionIdent> nameIdents = new ArrayList();

    public ConstantList() {
    }

    public ConstantList(Values values) throws PrismLangException {
        int n = values.getNumValues();
        for (int i = 0; i < n; ++i) {
            ExpressionIdent expressionIdent = new ExpressionIdent(values.getName(i));
            ExpressionLiteral expressionLiteral = new ExpressionLiteral(this.type, values.getValue(i));
            this.addConstant(expressionIdent, expressionLiteral, values.getType(i));
        }
    }

    public void addConstant(ExpressionIdent expressionIdent, Expression expression, Type type) {
        this.names.add(expressionIdent.getName());
        this.constants.add(expression);
        this.types.add(type);
        this.nameIdents.add(expressionIdent);
    }

    public void setConstant(int n, Expression expression) {
        this.constants.set(n, expression);
    }

    public int size() {
        return this.constants.size();
    }

    public String getConstantName(int n) {
        return this.names.get(n);
    }

    public Expression getConstant(int n) {
        return this.constants.get(n);
    }

    public Type getConstantType(int n) {
        return this.types.get(n);
    }

    public ExpressionIdent getConstantNameIdent(int n) {
        return this.nameIdents.get(n);
    }

    public int getConstantIndex(String string) {
        return this.names.indexOf(string);
    }

    public void removeConstant(String string, boolean bl) throws PrismLangException {
        int n = this.getConstantIndex(string);
        if (n == -1) {
            if (bl) {
                return;
            }
            throw new PrismLangException("Can not remove nonexistent constant: " + string);
        }
        this.removeConstant(n);
    }

    public void removeConstant(int n) {
        this.names.remove(n);
        this.constants.remove(n);
        this.types.remove(n);
        this.nameIdents.remove(n);
    }

    public void findCycles() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.constants.size();
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.getConstant(n);
            if (object == null) continue;
            List<String> list = ((ASTElement)object).getAllConstants();
            for (int i = 0; i < list.size(); ++i) {
                int n3 = this.getConstantIndex(list.get(i));
                if (n3 == -1) continue;
                blArray[n][n3] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency in definition of constant \"" + this.getConstantName(n) + "\"";
            throw new PrismLangException((String)object, this.getConstant(n));
        }
    }

    public int getNumUndefined() {
        int n = 0;
        int n2 = this.constants.size();
        for (int i = 0; i < n2; ++i) {
            Expression expression = this.getConstant(i);
            if (expression != null) continue;
            ++n;
        }
        return n;
    }

    public List<String> getUndefinedConstants() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.constants.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.getConstant(i);
            if (expression != null) continue;
            arrayList.add(this.getConstantName(i));
        }
        return arrayList;
    }

    public boolean isDefinedConstant(String string) {
        int n = this.getConstantIndex(string);
        if (n == -1) {
            return false;
        }
        return this.getConstant(n) != null;
    }

    public Values evaluateConstants(EvaluateContext evaluateContext) throws PrismLangException {
        return this.evaluateSomeOrAllConstants(evaluateContext, true);
    }

    public Values evaluateSomeConstants(EvaluateContext evaluateContext) throws PrismLangException {
        return this.evaluateSomeOrAllConstants(evaluateContext, false);
    }

    private Values evaluateSomeOrAllConstants(EvaluateContext evaluateContext, boolean bl) throws PrismLangException {
        ConstantList constantList = (ConstantList)this.deepCopy();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = constantList.getConstant(i);
            constantList.setConstant(i, expression == null ? null : (Expression)expression.expandConstants(constantList, false));
        }
        Values values = new Values();
        for (int i = 0; i < n; ++i) {
            Expression expression = constantList.getConstant(i);
            if (expression == null) {
                expression = new ExpressionConstant(constantList.getConstantName(i), constantList.getConstantType(i));
            }
            try {
                Object object = expression.evaluate(evaluateContext);
                object = constantList.getConstantType(i).castValueTo(object, evaluateContext.getEvaluationMode());
                values.addValue(constantList.getConstantName(i), object);
                continue;
            }
            catch (PrismLangException prismLangException) {
                if (!bl) continue;
                throw prismLangException;
            }
        }
        return values;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.constants.size();
        for (int i = 0; i < n; ++i) {
            object = (String)object + "const ";
            object = (String)object + this.getConstantType(i).getTypeString() + " ";
            object = (String)object + this.getConstantName(i);
            Expression expression = this.getConstant(i);
            if (expression != null) {
                object = (String)object + " = " + String.valueOf(expression);
            }
            object = (String)object + ";\n";
        }
        return object;
    }

    @Override
    public ConstantList deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.constants);
        deepCopy.copyAll(this.nameIdents);
        return this;
    }

    @Override
    public ConstantList clone() {
        ConstantList constantList = (ConstantList)super.clone();
        constantList.names = (ArrayList)this.names.clone();
        constantList.constants = (ArrayList)this.constants.clone();
        constantList.types = (ArrayList)this.types.clone();
        constantList.nameIdents = (ArrayList)this.nameIdents.clone();
        return constantList;
    }
}

