/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import param.BigRational;
import param.Point;
import param.Region;
import param.RegionIntersection;
import param.RegionValues;
import param.RegionValuesIntersections;
import param.StateValues;

final class Optimiser {
    RegionValues values;
    RegionValues filter;
    boolean min;

    public Optimiser(RegionValues regionValues, RegionValues regionValues2, boolean bl) {
        this.values = regionValues;
        this.filter = regionValues2;
        this.min = bl;
    }

    public String optimise() {
        int n = this.values.getResult(0).getNumStates();
        BigRational[] bigRationalArray = new BigRational[n];
        for (int i = 0; i < n; ++i) {
            bigRationalArray[i] = this.min ? BigRational.INF : BigRational.MINF;
        }
        Point[] pointArray = new Point[n];
        RegionValuesIntersections regionValuesIntersections = new RegionValuesIntersections(this.values, this.filter);
        for (RegionIntersection regionIntersection : regionValuesIntersections) {
            Region region = regionIntersection.getRegion();
            StateValues stateValues = regionIntersection.getStateValues1();
            StateValues stateValues2 = regionIntersection.getStateValues2();
            for (int i = 0; i < stateValues.getNumStates(); ++i) {
                ArrayList<Point> arrayList = region.specialPoints();
                for (Point point : arrayList) {
                    BigRational bigRational = stateValues.getStateValueAsFunction(i).evaluate(point);
                    if (!stateValues2.getStateValueAsBoolean(i) || bigRational.compareTo(bigRationalArray[i]) != (this.min ? -1 : 1)) continue;
                    bigRationalArray[i] = bigRational;
                    pointArray[i] = point;
                }
            }
        }
        BigRational bigRational = bigRationalArray[this.values.getInitState()];
        return (this.min ? "at most " : "at least ") + bigRational.doubleValue() + " at " + String.valueOf(pointArray[this.values.getInitState()]);
    }
}

