/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2dstar.AcceptanceForState;
import jltl2dstar.NBA2DAResult;
import jltl2dstar.NBA2DAState;
import jltl2dstar.RabinSignature;
import jltl2dstar.UnionAcceptanceCalculator;

public class UnionState
implements Comparable<UnionState>,
NBA2DAState {
    protected int da_state_1;
    protected int da_state_2;
    RabinSignature signature;
    String description;

    public UnionState(int n, int n2, UnionAcceptanceCalculator unionAcceptanceCalculator) {
        this.da_state_1 = n;
        this.da_state_2 = n2;
        this.signature = unionAcceptanceCalculator.calculateAcceptance(this.da_state_1, this.da_state_2);
        this.description = "";
    }

    @Override
    public int compareTo(UnionState unionState) {
        if (this.da_state_1 != unionState.da_state_1) {
            return this.da_state_1 - unionState.da_state_1;
        }
        return this.da_state_2 - unionState.da_state_2;
    }

    public boolean equals(UnionState unionState) {
        return this.da_state_1 == unionState.da_state_1 && this.da_state_2 == unionState.da_state_2;
    }

    public boolean equals(Object object) {
        return object instanceof UnionState && this.equals((UnionState)object);
    }

    @Override
    public void generateAcceptance(AcceptanceForState acceptanceForState) {
        acceptanceForState.setSignature(this.signature);
    }

    public RabinSignature generateAcceptance() {
        return this.signature;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String toString() {
        return "(" + this.da_state_1 + "," + this.da_state_1 + ")";
    }

    @Override
    public String toHTML() {
        return this.description;
    }

    public int hashCode() {
        return this.da_state_1 + this.da_state_2 * 31;
    }

    public static class Result
    implements NBA2DAResult<UnionState> {
        private UnionState state;

        public Result(UnionState unionState) {
            this.state = unionState;
        }

        @Override
        public UnionState getState() {
            return this.state;
        }
    }
}

