/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Vector;
import jltl2ba.MyBitSet;
import jltl2dstar.AcceptanceForState;
import jltl2dstar.NBA2DAState;
import jltl2dstar.RabinAcceptance;
import jltl2dstar.RabinSignature;
import jltl2dstar.SafraTreeNode;
import jltl2dstar.SafraTreeWalker;
import jltl2dstar.SafrasAlgorithm;

public class SafraTree
implements NBA2DAState {
    private int MAX_NODES;
    private Vector<SafraTreeNode> _nodes;

    public SafraTree(int n) {
        this.MAX_NODES = n == 0 ? 1 : n;
        this._nodes = new Vector(this.MAX_NODES);
        this._nodes.setSize(this.MAX_NODES);
        this.newNode(0);
    }

    public SafraTree(SafraTree safraTree) {
        this.MAX_NODES = safraTree.MAX_NODES;
        this._nodes = new Vector(this.MAX_NODES);
        this._nodes.setSize(this.MAX_NODES);
        for (int i = 0; i < this.MAX_NODES; ++i) {
            if (safraTree._nodes.get(i) == null) continue;
            this.newNode(i);
            this._nodes.get(i).setLabeling((MyBitSet)safraTree._nodes.get(i).getLabeling().clone());
            this._nodes.get(i).setFinalFlag(safraTree._nodes.get(i).hasFinalFlag());
        }
        this.copySubTree(this._nodes.get(0), safraTree._nodes.get(0));
    }

    public SafraTreeNode getRootNode() {
        return this._nodes.get(0);
    }

    public SafraTreeNode newNode() {
        if (this._nodes.indexOf(null) != -1) {
            return this.newNode(this._nodes.indexOf(null));
        }
        return null;
    }

    public SafraTreeNode newNode(int n) {
        assert (n < this.MAX_NODES);
        assert (this._nodes.get(n) == null);
        this._nodes.set(n, new SafraTreeNode(n));
        return this._nodes.get(n);
    }

    public void remove(SafraTreeNode safraTreeNode) {
        assert (this._nodes.get(safraTreeNode.getID()) == safraTreeNode);
        this.remove(safraTreeNode.getID());
    }

    public void remove(int n) {
        assert (n >= 0 && n < this.MAX_NODES);
        this._nodes.get(n).removeFromTree();
        this._nodes.set(n, null);
    }

    public void removeAllChildren(int n) {
        SafraTreeNode safraTreeNode;
        assert (n < this.MAX_NODES);
        SafraTreeNode safraTreeNode2 = this._nodes.get(n);
        while ((safraTreeNode = safraTreeNode2.getOldestChild()) != null) {
            this.removeAllChildren(safraTreeNode.getID());
            this.remove(safraTreeNode.getID());
        }
    }

    public <V extends SafrasAlgorithm.SafraTreeVisitor> void walkTreePostOrder(V v) {
        SafraTreeWalker<V> safraTreeWalker = new SafraTreeWalker<V>(v);
        safraTreeWalker.walkTreePostOrder(this);
    }

    public <V extends SafrasAlgorithm.SafraTreeVisitor> void walkSubTreePostOrder(V v, SafraTreeNode safraTreeNode) {
        SafraTreeWalker<V> safraTreeWalker = new SafraTreeWalker<V>(v);
        safraTreeWalker.walkSubTreePostOrder(this, safraTreeNode, true);
    }

    public <V extends SafrasAlgorithm.SafraTreeVisitor> void walkChildrenPostOrder(V v, SafraTreeNode safraTreeNode) {
        SafraTreeWalker<V> safraTreeWalker = new SafraTreeWalker<V>(v);
        safraTreeWalker.walkSubTreePostOrder(this, safraTreeNode, false);
    }

    public int treeHeight() {
        if (this.getRootNode() != null) {
            return this.getRootNode().treeHeight();
        }
        return 0;
    }

    public int treeWidth() {
        if (this.getRootNode() != null) {
            return this.getRootNode().treeWidth();
        }
        return 0;
    }

    public boolean equals(SafraTree safraTree) {
        if (safraTree.MAX_NODES != this.MAX_NODES) {
            return false;
        }
        return this._nodes.equals(safraTree._nodes);
    }

    public boolean equals(Object object) {
        if (object instanceof SafraTree) {
            return this.equals((SafraTree)object);
        }
        return false;
    }

    public boolean structural_equal_to(SafraTree safraTree) {
        if (safraTree.MAX_NODES != this.MAX_NODES) {
            return false;
        }
        SafraTreeNode safraTreeNode = this.getRootNode();
        SafraTreeNode safraTreeNode2 = safraTree.getRootNode();
        if (safraTreeNode == null || safraTreeNode2 == null) {
            return safraTreeNode == safraTreeNode2;
        }
        return safraTreeNode.structuralEquals(safraTreeNode2);
    }

    public boolean structural_less_than(SafraTree safraTree) {
        if (safraTree.MAX_NODES < this.MAX_NODES) {
            return true;
        }
        SafraTreeNode safraTreeNode = this.getRootNode();
        SafraTreeNode safraTreeNode2 = safraTree.getRootNode();
        if (safraTreeNode == null) {
            return safraTreeNode2 != null;
        }
        if (safraTreeNode2 == null) {
            return false;
        }
        return safraTreeNode.structuralLessThan(safraTreeNode2);
    }

    public boolean lessThan(SafraTree safraTree) {
        if (this.MAX_NODES < safraTree.MAX_NODES) {
            return true;
        }
        for (int i = 0; i < this.MAX_NODES; ++i) {
            if (this._nodes.get(i) == null && safraTree._nodes.get(i) == null) continue;
            if (this._nodes.get(i) == null) {
                return true;
            }
            if (safraTree._nodes.get(i) == null) {
                return false;
            }
            if (this._nodes.get(i).lessThan(safraTree._nodes.get(i))) {
                return true;
            }
            if (this._nodes.get(i).equals(safraTree._nodes.get(i))) continue;
            return false;
        }
        return false;
    }

    public int getNodeMax() {
        return this.MAX_NODES;
    }

    public SafraTreeNode get(int n) {
        return this._nodes.get(n);
    }

    public void set(int n, SafraTreeNode safraTreeNode) {
        this._nodes.set(n, safraTreeNode);
    }

    public void print(PrintStream printStream) {
        if (this.getRootNode() == null) {
            printStream.println("<empty>");
        } else {
            this.printSubTree(printStream, 0, this.getRootNode());
        }
    }

    @Override
    public String toHTML() {
        if (this.getRootNode() == null) {
            return "<TABLE><TR><TD>[empty]</TD></TR></TABLE>";
        }
        return this.getRootNode().toHTMLString();
    }

    public int hashCode() {
        if (this.getRootNode() != null) {
            return this.getRootNode().hashCode();
        }
        return 0;
    }

    @Override
    public void generateAcceptance(AcceptanceForState acceptanceForState) {
        for (int i = 0; i < this.getNodeMax(); ++i) {
            SafraTreeNode safraTreeNode = this.get(i);
            if (safraTreeNode == null) {
                acceptanceForState.addTo_U(i);
                continue;
            }
            if (!safraTreeNode.hasFinalFlag()) continue;
            acceptanceForState.addTo_L(i);
        }
    }

    public void generateAcceptance(RabinSignature rabinSignature) {
        rabinSignature.setSize(this.getNodeMax());
        for (int i = 0; i < this.getNodeMax(); ++i) {
            SafraTreeNode safraTreeNode = this.get(i);
            if (safraTreeNode == null) {
                rabinSignature.setColor(i, RabinAcceptance.RabinColor.RABIN_RED);
                continue;
            }
            if (safraTreeNode.hasFinalFlag()) {
                rabinSignature.setColor(i, RabinAcceptance.RabinColor.RABIN_GREEN);
                continue;
            }
            rabinSignature.setColor(i, RabinAcceptance.RabinColor.RABIN_WHITE);
        }
    }

    public RabinSignature generateAcceptance() {
        RabinSignature rabinSignature = new RabinSignature(this.getNodeMax());
        this.generateAcceptance(rabinSignature);
        return rabinSignature;
    }

    private void copySubTree(SafraTreeNode safraTreeNode, SafraTreeNode safraTreeNode2) {
        if (safraTreeNode2 == null) {
            return;
        }
        for (SafraTreeNode safraTreeNode3 : safraTreeNode2) {
            SafraTreeNode safraTreeNode4 = this._nodes.get(safraTreeNode3.getID());
            safraTreeNode.addAsYoungestChild(safraTreeNode4);
            this.copySubTree(safraTreeNode4, safraTreeNode3);
        }
    }

    private void printSubTree(PrintStream printStream, int n, SafraTreeNode safraTreeNode) {
        for (int i = 0; i < n; ++i) {
            printStream.print(" ");
        }
        safraTreeNode.print(printStream);
        printStream.println();
        for (SafraTreeNode safraTreeNode2 : safraTreeNode) {
            this.printSubTree(printStream, n + 1, safraTreeNode2);
        }
    }
}

