/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.Vector;
import jltl2ba.APElementIterator;
import jltl2ba.MyBitSet;
import jltl2dstar.GraphAlgorithms;
import jltl2dstar.NBA;
import jltl2dstar.NBA_State;
import jltl2dstar.SCCs;

public class NBAAnalysis {
    private NBA _nba;
    private SCCs _sccs = null;
    private MyBitSet _allSuccAccepting = null;
    private MyBitSet _accepting_true_loops = null;
    private Vector<MyBitSet> _reachability;

    public NBAAnalysis(NBA nBA) {
        this._nba = nBA;
    }

    public SCCs getSCCs() {
        if (this._sccs == null) {
            this._sccs = new SCCs();
            GraphAlgorithms.calculateSCCs(this._nba, this._sccs, true);
        }
        return this._sccs;
    }

    public MyBitSet getStatesWithAllSuccAccepting() {
        if (this._allSuccAccepting == null) {
            this.calculateStatesWithAllSuccAccepting();
        }
        return this._allSuccAccepting;
    }

    public MyBitSet getStatesWithAcceptingTrueLoops() {
        if (this._accepting_true_loops == null) {
            this.calculateAcceptingTrueLoops();
        }
        return this._accepting_true_loops;
    }

    public boolean areAllStatesFinal() {
        for (NBA_State nBA_State : this._nba) {
            if (nBA_State.isFinal()) continue;
            return false;
        }
        return true;
    }

    public MyBitSet getFinalStates() {
        return this._nba.getFinalStates();
    }

    public boolean isNBADisjoint() {
        return this.getSCCs().getGraphIsDisjoint();
    }

    public Vector<MyBitSet> getReachability() {
        if (this._reachability == null) {
            this._reachability = this.getSCCs().getReachabilityForAllStates();
        }
        return this._reachability;
    }

    public boolean emptinessCheck() {
        SCCs sCCs = this.getSCCs();
        for (int i = 0; i < sCCs.countSCCs(); ++i) {
            MyBitSet myBitSet = sCCs.get(i);
            int n = myBitSet.nextSetBit(0);
            while (n >= 0) {
                if (this._nba.get(n).isFinal() && (myBitSet.cardinality() != 1 || sCCs.stateIsReachable(n, n))) {
                    assert (this._nba.getStartState() != null);
                    if (sCCs.stateIsReachable(this._nba.getStartState().getName(), n)) {
                        return false;
                    }
                }
                n = myBitSet.nextSetBit(n + 1);
            }
        }
        return true;
    }

    private void calculateStatesWithAllSuccAccepting() {
        MyBitSet myBitSet = this._allSuccAccepting = new MyBitSet();
        SCCs sCCs = this.getSCCs();
        MyBitSet myBitSet2 = new MyBitSet(sCCs.countSCCs());
        for (int i = sCCs.countSCCs(); i > 0; --i) {
            int n;
            int n2 = sCCs.topologicalOrder().get(i - 1);
            MyBitSet myBitSet3 = sCCs.get(n2);
            myBitSet2.set(n2);
            int n3 = myBitSet3.nextSetBit(0);
            while (n3 >= 0) {
                if (!this._nba.get(n3).isFinal()) {
                    myBitSet2.clear(n2);
                    break;
                }
                n3 = myBitSet3.nextSetBit(n3 + 1);
            }
            n3 = 0;
            if (!myBitSet2.get(n2) && myBitSet3.cardinality() == 1 && !sCCs.stateIsReachable(n = myBitSet3.nextSetBit(0), n)) {
                n3 = 1;
            }
            if (!myBitSet2.get(n2) && n3 == 0) continue;
            n = 1;
            MyBitSet myBitSet4 = sCCs.successors(n2);
            int n4 = myBitSet4.nextSetBit(0);
            while (n4 >= 0) {
                if (!myBitSet2.get(n4)) {
                    n = 0;
                    break;
                }
                n4 = myBitSet4.nextSetBit(n4 + 1);
            }
            if (n == 0) continue;
            myBitSet.or(myBitSet3);
            if (n3 == 0) continue;
            myBitSet2.set(n2);
        }
    }

    private void calculateAcceptingTrueLoops() {
        this._accepting_true_loops = new MyBitSet();
        SCCs sCCs = this.getSCCs();
        for (int i = 0; i < sCCs.countSCCs(); ++i) {
            int n;
            NBA_State nBA_State;
            if (sCCs.get(i).cardinality() != 1 || !(nBA_State = this._nba.get(n = sCCs.get(i).nextSetBit(0))).isFinal() || !sCCs.successors(i).isEmpty()) continue;
            boolean bl = true;
            if (!sCCs.stateIsReachable(n, n)) continue;
            APElementIterator aPElementIterator = new APElementIterator(this._nba.getAPSize());
            while (aPElementIterator.hasNext()) {
                if (!nBA_State.getEdge(aPElementIterator.next()).isEmpty()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this._accepting_true_loops.set(n);
        }
    }
}

