/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import jltl2ba.MyBitSet;
import jltl2dstar.NBA;
import jltl2dstar.NBA_State;
import jltl2dstar.SCCs;

public class GraphAlgorithms {
    public static void calculateSCCs(NBA nBA, SCCs sCCs, boolean bl) {
        SCC_DFS sCC_DFS = new SCC_DFS(nBA, sCCs);
        sCC_DFS.calculate(bl);
    }

    public static class SCC_DFS {
        private NBA _graph;
        private SCCs _result;
        private int current_dfs_nr;
        private Stack<Integer> _stack;
        private Vector<SCC_DFS_Data> _dfs_data;
        private int scc_nr;

        public SCC_DFS(NBA nBA, SCCs sCCs) {
            this._graph = nBA;
            this._result = sCCs;
            this._stack = new Stack();
            this._dfs_data = new Vector();
        }

        public void calculate(boolean bl) {
            this.current_dfs_nr = 0;
            this._dfs_data.clear();
            this._dfs_data.setSize(this._graph.size());
            this.scc_nr = 0;
            NBA_State nBA_State = this._graph.getStartState();
            if (nBA_State == null) {
                return;
            }
            int n = nBA_State.getName();
            this.visit(n);
            if (bl) {
                for (int i = 0; i < this._graph.size(); ++i) {
                    if (this._dfs_data.get(i) != null) continue;
                    this._result.setGraphIsDisjoint();
                    this.visit(i);
                }
            }
            this.calculateDAG();
        }

        private void visit(int n) {
            SCC_DFS_Data sCC_DFS_Data;
            int n2;
            SCC_DFS_Data sCC_DFS_Data2 = new SCC_DFS_Data();
            sCC_DFS_Data2.dfs_nr = this.current_dfs_nr++;
            sCC_DFS_Data2.root_index = n;
            sCC_DFS_Data2.inComponent = false;
            this._stack.push(n);
            this._dfs_data.set(n, sCC_DFS_Data2);
            Object object = this._graph.get(n).successorIterator();
            while (object.hasNext()) {
                int n3;
                int n4;
                n2 = object.next();
                if (this._dfs_data.get(n2) == null) {
                    this.visit(n2);
                }
                sCC_DFS_Data = this._dfs_data.get(n2);
                if (sCC_DFS_Data.inComponent || (n4 = this._dfs_data.get((int)sCC_DFS_Data2.root_index).dfs_nr) <= (n3 = this._dfs_data.get((int)sCC_DFS_Data.root_index).dfs_nr)) continue;
                sCC_DFS_Data2.root_index = sCC_DFS_Data.root_index;
            }
            if (sCC_DFS_Data2.root_index == n) {
                object = new MyBitSet();
                do {
                    n2 = this._stack.pop();
                    ((BitSet)object).set(n2);
                    this._result.setState2SCC(n2, this.scc_nr);
                    sCC_DFS_Data = this._dfs_data.get(n2);
                    sCC_DFS_Data.inComponent = true;
                } while (n2 != n);
                this.scc_nr = this._result.addSCC((MyBitSet)object) + 1;
            }
        }

        private void calculateDAG() {
            int n;
            int n2;
            this._result._dag.clear();
            this._result._dag.setSize(this._result.countSCCs());
            this._result._reachability.setSize(this._result.countSCCs());
            int[] nArray = new int[this._result.countSCCs()];
            for (n2 = 0; n2 < this._result.countSCCs(); ++n2) {
                this._result._dag.set(n2, new MyBitSet());
                this._result._reachability.set(n2, new MyBitSet());
                MyBitSet myBitSet = this._result.get(n2);
                int n3 = myBitSet.nextSetBit(0);
                while (n3 >= 0) {
                    Iterator<Integer> iterator = this._graph.get(n3).successorIterator();
                    while (iterator.hasNext()) {
                        int n4 = iterator.next();
                        int n5 = this._result.state2scc(n4);
                        if (n5 != n2 && !this._result._dag.get(n2).get(n5)) {
                            int n6 = n5;
                            nArray[n6] = nArray[n6] + 1;
                            this._result._dag.get(n2).set(n5);
                        }
                        this._result._reachability.get(n2).set(n5);
                    }
                    n3 = myBitSet.nextSetBit(n3 + 1);
                }
            }
            n2 = 1;
            int n7 = 0;
            this._result._topological_order.clear();
            this._result._topological_order.setSize(this._result.countSCCs());
            int[] nArray2 = new int[this._result.countSCCs()];
            while (n2 != 0) {
                n2 = 0;
                for (int i = 0; i < this._result.countSCCs(); ++i) {
                    if (nArray[i] != 0) continue;
                    nArray2[i] = n7++;
                    n2 = 1;
                    nArray[i] = -1;
                    for (Integer n8 : this._result._dag.get(i)) {
                        int n9 = n8;
                        nArray[n9] = nArray[n9] - 1;
                    }
                }
            }
            for (n = 0; n < this._result.countSCCs(); ++n) {
                this._result._topological_order.set(nArray2[n], n);
            }
            for (n = this._result.countSCCs(); n > 0; --n) {
                int n10 = this._result._topological_order.get(n - 1);
                MyBitSet myBitSet = this._result._reachability.get(n10);
                for (Integer n11 : this._result._dag.get(n10)) {
                    myBitSet.or(this._result._reachability.get(n11));
                }
            }
        }

        public static class SCC_DFS_Data {
            public int dfs_nr;
            public int root_index;
            public boolean inComponent;
        }
    }
}

