/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.Iterator;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2ba.MyBitSet;
import jltl2dstar.APMonom2APElements;
import prism.PrismException;

public class APMonom {
    private MyBitSet bits_set;
    private MyBitSet bits_value;
    private boolean booleanValue;

    public APMonom() {
        this.bits_set = new MyBitSet();
        this.bits_value = new MyBitSet();
        this.booleanValue = true;
    }

    public APMonom(boolean bl) {
        this.bits_set = new MyBitSet();
        this.bits_value = new MyBitSet();
        this.booleanValue = bl;
    }

    public APMonom(MyBitSet myBitSet, MyBitSet myBitSet2) {
        this.bits_set = myBitSet;
        this.bits_value = myBitSet2;
    }

    public boolean isSet(int n) throws PrismException {
        if (!this.isNormal()) {
            return false;
        }
        return this.bits_set.get(n);
    }

    public boolean getValue(int n) throws PrismException {
        if (!this.isNormal()) {
            throw new PrismException("Can't get AP, is either TRUE/FALSE!");
        }
        if (!this.bits_set.get(n)) {
            throw new PrismException("Can't get value: AP not set!");
        }
        return this.bits_value.get(n);
    }

    public void setValue(int n, boolean bl) {
        this.bits_set.set(n, true);
        this.bits_value.set(n, bl);
    }

    public void andAP(int n, boolean bl) {
        if (this.isFalse()) {
            return;
        }
        if (!this.isTrue() && this.bits_set.get(n) && this.bits_value.get(n) != bl) {
            this.booleanValue = false;
            this.bits_set.clear();
            this.bits_value.clear();
            return;
        }
        this.setValue(n, bl);
    }

    public void unset(int n) {
        this.bits_value.set(n, false);
        this.bits_set.set(n, false);
    }

    public boolean isTrue() {
        return !this.isNormal() && this.booleanValue;
    }

    public boolean isFalse() {
        return !this.isNormal() && !this.booleanValue;
    }

    public boolean isNormal() {
        return !this.bits_set.isEmpty();
    }

    public MyBitSet getValueBits() {
        return this.bits_value;
    }

    public MyBitSet getSetBits() {
        return this.bits_set;
    }

    public boolean isNormalized() {
        if (this.isTrue() || this.isFalse()) {
            return true;
        }
        MyBitSet myBitSet = this.getValueBits();
        myBitSet.andNot(this.bits_set);
        return myBitSet.isEmpty();
    }

    public String toString() {
        Object object = "";
        if (this.isTrue()) {
            return "true";
        }
        if (this.isFalse()) {
            return "false";
        }
        for (int i = 0; i < this.bits_set.size(); ++i) {
            if (!this.bits_set.get(i)) continue;
            object = this.bits_value.get(i) ? (String)object + "+" + i : (String)object + "-" + i;
        }
        return object;
    }

    public boolean isIntersectionEmpty(APMonom aPMonom) {
        MyBitSet myBitSet = this.getSetBits();
        myBitSet.and(aPMonom.getSetBits());
        MyBitSet myBitSet2 = this.getValueBits();
        myBitSet2.and(myBitSet);
        MyBitSet myBitSet3 = aPMonom.getValueBits();
        myBitSet3.and(myBitSet);
        return !myBitSet2.equals(myBitSet3);
    }

    public APMonom and(APMonom aPMonom) {
        if (this.isFalse() || aPMonom.isFalse()) {
            return new APMonom(false);
        }
        if (this.isTrue()) {
            return aPMonom;
        }
        if (aPMonom.isTrue()) {
            return this;
        }
        if (this.isIntersectionEmpty(aPMonom)) {
            return new APMonom(false);
        }
        MyBitSet myBitSet = this.getSetBits();
        myBitSet.or(aPMonom.getSetBits());
        MyBitSet myBitSet2 = this.getValueBits();
        myBitSet2.or(aPMonom.getValueBits());
        return new APMonom(myBitSet, myBitSet2);
    }

    APMonom andNot(APMonom aPMonom) {
        if (this.isFalse()) {
            return new APMonom(false);
        }
        if (aPMonom.isFalse()) {
            return this;
        }
        if (aPMonom.isTrue()) {
            return new APMonom(false);
        }
        MyBitSet myBitSet = this.getSetBits();
        myBitSet.and(aPMonom.getSetBits());
        MyBitSet myBitSet2 = this.getValueBits();
        myBitSet2.and(myBitSet);
        MyBitSet myBitSet3 = aPMonom.getValueBits();
        myBitSet3.and(myBitSet);
        myBitSet3.flip(0, myBitSet3.size());
        if (!myBitSet2.equals(myBitSet3)) {
            return new APMonom(false);
        }
        MyBitSet myBitSet4 = this.getSetBits();
        myBitSet4.or(aPMonom.getSetBits());
        MyBitSet myBitSet5 = this.getValueBits();
        myBitSet5.andNot(aPMonom.getValueBits());
        return new APMonom(myBitSet4, myBitSet5);
    }

    public boolean equals(APMonom aPMonom) {
        return this.isNormal() && aPMonom.isNormal() && this.getValueBits().equals(aPMonom.getValueBits()) && this.getSetBits().equals(aPMonom.getSetBits()) || this.isTrue() && aPMonom.isTrue() || this.isFalse() && aPMonom.isFalse();
    }

    public boolean equals(Object object) {
        return object instanceof APMonom && this.equals((APMonom)object);
    }

    public Iterator<APElement> APElementIterator(APSet aPSet) {
        return new APMonom2APElements(aPSet, this);
    }

    public void setFromPosNeg(MyBitSet myBitSet, MyBitSet myBitSet2) throws PrismException {
        int n;
        int n2 = n = myBitSet.size() > myBitSet2.size() ? myBitSet.size() : myBitSet2.size();
        if (myBitSet.intersects(myBitSet2)) {
            throw new PrismException("MyBitSet contradiction");
        }
        if (myBitSet.cardinality() == n || myBitSet.cardinality() == 0 && myBitSet2.cardinality() == 0) {
            this.bits_set = new MyBitSet(n);
            this.bits_value = new MyBitSet(n);
            this.booleanValue = true;
        } else if (myBitSet2.cardinality() == n) {
            this.bits_set = new MyBitSet(n);
            this.bits_value = new MyBitSet(n);
            this.booleanValue = false;
        } else if (myBitSet.size() == n) {
            this.bits_set = (MyBitSet)myBitSet.clone();
            this.bits_set.or(myBitSet2);
            this.bits_value = (MyBitSet)myBitSet.clone();
        } else {
            this.bits_set = (MyBitSet)myBitSet2.clone();
            this.bits_set.or(myBitSet);
            this.bits_value = new MyBitSet(n);
            this.bits_value.or(myBitSet);
        }
    }
}

