/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;

public class JDDVars
implements Iterable<JDDNode> {
    private Vector<JDDNode> vars = new Vector();
    private long array = 0L;
    private boolean arrayBuilt = false;

    private native long DDV_BuildArray();

    private native void DDV_FreeArray(long var1);

    private native int DDV_GetIndex(long var1);

    public void addVar(JDDNode jDDNode) {
        this.vars.addElement(jDDNode);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    @Deprecated
    public void addVars(JDDVars jDDVars) {
        this.vars.addAll(jDDVars.vars);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public JDDVars copy() {
        JDDVars jDDVars = new JDDVars();
        for (JDDNode jDDNode : this) {
            jDDVars.addVar(jDDNode.copy());
        }
        return jDDVars;
    }

    public void copyVarsFrom(JDDVars jDDVars) {
        for (JDDNode jDDNode : jDDVars) {
            this.addVar(jDDNode.copy());
        }
    }

    public static JDDVars[] copyArray(JDDVars[] jDDVarsArray) {
        JDDVars[] jDDVarsArray2 = new JDDVars[jDDVarsArray.length];
        for (int i = 0; i < jDDVarsArray.length; ++i) {
            jDDVarsArray2[i] = jDDVarsArray[i].copy();
        }
        return jDDVarsArray2;
    }

    public void mergeVarsFrom(JDDVars jDDVars) {
        this.copyVarsFrom(jDDVars);
        this.sortByIndex();
    }

    public void removeVar(JDDNode jDDNode) {
        this.vars.remove(jDDNode);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public void removeVars(JDDVars jDDVars) {
        this.vars.removeAll(jDDVars.vars);
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public JDDNode getVar(int n) {
        return this.vars.elementAt(n);
    }

    public long getVarPtr(int n) {
        return this.vars.elementAt(n).ptr();
    }

    public int getVarIndex(int n) {
        return this.DDV_GetIndex(this.vars.elementAt(n).ptr());
    }

    public int getMinVarIndex() {
        int n = this.vars.size();
        if (n == 0) {
            return -1;
        }
        int n2 = this.getVarIndex(0);
        for (int i = 1; i < n; ++i) {
            int n3 = this.getVarIndex(i);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int getMaxVarIndex() {
        int n = this.vars.size();
        if (n == 0) {
            return -1;
        }
        int n2 = this.getVarIndex(0);
        for (int i = 1; i < n; ++i) {
            int n3 = this.getVarIndex(i);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    @Deprecated
    public void refAll() {
        for (int i = 0; i < this.vars.size(); ++i) {
            JDD.Ref(this.vars.elementAt(i));
        }
    }

    public void derefAll() {
        for (int i = 0; i < this.vars.size(); ++i) {
            JDD.Deref(this.vars.elementAt(i));
        }
    }

    public static void derefAllArray(JDDVars[] jDDVarsArray) {
        for (JDDVars jDDVars : jDDVarsArray) {
            jDDVars.derefAll();
        }
    }

    public long array() {
        if (this.arrayBuilt) {
            return this.array;
        }
        this.array = this.DDV_BuildArray();
        this.arrayBuilt = true;
        return this.array;
    }

    public int n() {
        return this.vars.size();
    }

    @Override
    public Iterator<JDDNode> iterator() {
        return this.vars.iterator();
    }

    public String toString() {
        Object object = "{";
        for (int i = 0; i < this.vars.size() - 1; ++i) {
            object = (String)object + this.getVarIndex(i) + ", ";
        }
        if (this.vars.size() > 0) {
            object = (String)object + this.getVarIndex(this.vars.size() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDDVars fromCubeSet(JDDNode jDDNode) {
        try {
            JDDVars jDDVars = new JDDVars();
            JDDNode jDDNode2 = jDDNode;
            while (!jDDNode2.equals(JDD.ONE)) {
                if (jDDNode2.isConstant()) {
                    throw new IllegalArgumentException("JDDVars.fromCubeSet: The argument is not a cubeset");
                }
                if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                    throw new IllegalArgumentException("JDDVars.fromCubeSet: The argument is not a cubeset");
                }
                int n = jDDNode2.getIndex();
                JDDNode jDDNode3 = JDD.Var(n);
                jDDVars.addVar(jDDNode3);
                jDDNode2 = jDDNode2.getThen();
            }
            JDDVars jDDVars2 = jDDVars;
            return jDDVars2;
        }
        finally {
            JDD.Deref(jDDNode);
        }
    }

    public JDDNode toCubeSet() {
        JDDNode jDDNode = JDD.Constant(1.0);
        for (JDDNode jDDNode2 : this.vars) {
            jDDNode = JDD.And(jDDNode, jDDNode2.copy());
        }
        return jDDNode;
    }

    public JDDNode allZero() {
        JDDNode jDDNode = JDD.Constant(1.0);
        for (JDDNode jDDNode2 : this.vars) {
            jDDNode = JDD.And(jDDNode, JDD.Not(jDDNode2.copy()));
        }
        return jDDNode;
    }

    public void sortByIndex() {
        if (this.arrayBuilt) {
            this.DDV_FreeArray(this.array);
        }
        this.arrayBuilt = false;
        Collections.sort(this.vars, new Comparator<JDDNode>(){

            @Override
            public int compare(JDDNode jDDNode, JDDNode jDDNode2) {
                return Integer.valueOf(jDDNode.getIndex()).compareTo(jDDNode2.getIndex());
            }
        });
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

