/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.IterableBitSet;
import common.IterableStateSet;
import common.iterable.FilteringIterable;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.Model;
import explicit.PredecessorRelation;
import explicit.StateValues;
import java.util.BitSet;
import java.util.List;
import prism.ActionList;
import prism.ActionListOwner;
import prism.PrismComponent;
import prism.PrismException;

public abstract class ModelView<Value>
implements Model<Value>,
ActionListOwner {
    protected ActionList actionList = new ActionList(this::findActionsUsed);
    protected BitSet deadlockStates = new BitSet();
    protected boolean fixedDeadlocks = false;
    protected PredecessorRelation predecessorRelation;

    public ModelView() {
    }

    public ModelView(ModelView<Value> modelView) {
        this.deadlockStates = (BitSet)modelView.deadlockStates.clone();
        this.fixedDeadlocks = modelView.fixedDeadlocks;
    }

    @Override
    public ActionList getActionList() {
        return this.actionList;
    }

    @Override
    public List<Object> getActions() {
        return this.actionList.getActions();
    }

    @Override
    public int actionIndex(Object object) {
        return this.actionList.actionIndex(object);
    }

    @Override
    public int getNumDeadlockStates() {
        return this.deadlockStates.cardinality();
    }

    public FunctionalPrimitiveIterable.OfInt getDeadlockStates() {
        return new IterableBitSet(this.deadlockStates);
    }

    @Override
    public StateValues getDeadlockStatesList() {
        return StateValues.createFromBitSet(this.deadlockStates, this);
    }

    @Override
    public int getFirstDeadlockState() {
        return this.deadlockStates.nextSetBit(0);
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.deadlockStates.get(n);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        FunctionalPrimitiveIterator.OfInt ofInt = this.findDeadlocks(new BitSet()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            this.deadlockStates.set(n);
        }
        if (bl && !this.fixedDeadlocks) {
            this.fixDeadlocks();
            this.fixedDeadlocks = true;
        }
    }

    public FunctionalPrimitiveIterable.OfInt findDeadlocks(BitSet bitSet) {
        IterableStateSet iterableStateSet = new IterableStateSet(bitSet, this.getNumStates(), true);
        return new FilteringIterable.OfInt(iterableStateSet, n -> !this.getSuccessorsIterator(n).hasNext());
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        this.checkForDeadlocks(null);
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        FunctionalPrimitiveIterator.OfInt ofInt = this.findDeadlocks(bitSet).iterator();
        if (ofInt.hasNext()) {
            throw new PrismException(String.valueOf((Object)this.getModelType()) + " has a deadlock in state " + ofInt.nextInt());
        }
    }

    @Override
    public boolean hasStoredPredecessorRelation() {
        return this.predecessorRelation != null;
    }

    @Override
    public PredecessorRelation getPredecessorRelation(PrismComponent prismComponent, boolean bl) {
        if (this.predecessorRelation != null) {
            return this.predecessorRelation;
        }
        PredecessorRelation predecessorRelation = PredecessorRelation.forModel(prismComponent, this);
        if (bl) {
            this.predecessorRelation = predecessorRelation;
        }
        return predecessorRelation;
    }

    @Override
    public void clearPredecessorRelation() {
        this.predecessorRelation = null;
    }

    protected abstract void fixDeadlocks();

    public boolean isVirtual() {
        return true;
    }
}

