/*
 * Decompiled with CFR 0.152.
 */
package explicit.graphviz;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class Decoration {
    private String label;
    private LabelType labelType = LabelType.PLAIN;
    private TreeMap<String, String> attributes;
    private Decoration defaults;

    public Decoration() {
        this.defaults = null;
        this.label = "";
    }

    public Decoration(Decoration decoration) {
        this.defaults = decoration;
    }

    public Map<String, String> attributes() {
        if (this.attributes == null) {
            this.attributes = new TreeMap();
        }
        return this.attributes;
    }

    public Map<String, String> attributesRO() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getEffectiveValue(String string) {
        if (string.equals("label")) {
            return this.label;
        }
        String string2 = this.attributesRO().get(string);
        if (string2 == null && this.defaults != null) {
            return this.defaults.getEffectiveValue(string);
        }
        return string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.append(stringBuffer, "label", this.labelType.getOpen() + this.label + this.labelType.getClose());
        for (Map.Entry<String, String> entry : this.attributesRO().entrySet()) {
            Object object;
            if (this.defaults != null && (object = this.defaults.getEffectiveValue(entry.getKey())) != null && ((String)object).equals(entry.getValue())) continue;
            object = entry.getValue();
            object = "\"" + (String)object + "\"";
            this.append(stringBuffer, entry.getKey(), (String)object);
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return "[" + stringBuffer.toString() + "]";
    }

    protected void append(StringBuffer stringBuffer, String string, String string2) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(",");
        }
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public void setLabelType(LabelType labelType) {
        this.labelType = labelType;
    }

    public void labelAddBelow(String string) {
        this.setLabel(this.getLabel() + this.labelType.getNewLine() + string);
    }

    public void labelAddAbove(String string) {
        this.setLabel(string + this.labelType.getNewLine() + this.getLabel());
    }

    public void labelAddRight(String string, String string2) {
        this.setLabel(this.getLabel() + (string2 == null ? " " : string2) + string);
    }

    public void labelAddLeft(String string, String string2) {
        this.setLabel(string + (string2 == null ? " " : string2) + this.getLabel());
    }

    public static enum LabelType {
        PLAIN("\"", "\"", "\\n"),
        HTML("<", ">", "<br/>");

        private final String labelOpen;
        private final String labelClose;
        private final String newLine;

        private LabelType(String string2, String string3, String string4) {
            this.labelOpen = string2;
            this.labelClose = string3;
            this.newLine = string4;
        }

        public String getOpen() {
            return this.labelOpen;
        }

        public String getClose() {
            return this.labelClose;
        }

        public String getNewLine() {
            return this.newLine;
        }
    }
}

