/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableBitSet;
import explicit.Model;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import prism.PrismComponent;

public class PredecessorRelation {
    List<ArrayList<Integer>> pre;

    public PredecessorRelation(Model<?> model) {
        this.pre = new ArrayList<ArrayList<Integer>>(model.getNumStates());
        for (int i = 0; i < model.getNumStates(); ++i) {
            this.pre.add(i, new ArrayList());
        }
        this.compute(model);
    }

    private void compute(Model<?> model) {
        int n = model.getNumStates();
        for (int i = 0; i < n; ++i) {
            Iterator<Integer> iterator = model.getSuccessorsIterator(i);
            while (iterator.hasNext()) {
                Integer n2 = iterator.next();
                this.pre.get(n2).add(i);
            }
        }
    }

    public Iterable<Integer> getPre(int n) {
        return this.pre.get(n);
    }

    public Iterator<Integer> getPredecessorsIterator(int n) {
        return this.getPre(n).iterator();
    }

    public static PredecessorRelation forModel(PrismComponent prismComponent, Model<?> model) {
        long l = System.currentTimeMillis();
        prismComponent.getLog().print("Calculating predecessor relation for " + model.getModelType().fullName() + "...  ");
        prismComponent.getLog().flush();
        PredecessorRelation predecessorRelation = new PredecessorRelation(model);
        l = System.currentTimeMillis() - l;
        prismComponent.getLog().println("done (" + (double)l / 1000.0 + " seconds)");
        return predecessorRelation;
    }

    public BitSet calculatePreStar(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        BitSet bitSet4 = (BitSet)bitSet2.clone();
        Stack<Integer> stack = new Stack<Integer>();
        for (Integer n : IterableBitSet.getSetBits(bitSet2)) {
            stack.add(n);
        }
        BitSet bitSet5 = new BitSet();
        while (!stack.isEmpty()) {
            int n = (Integer)stack.pop();
            if (bitSet5.get(n)) continue;
            bitSet5.set(n);
            for (int n2 : this.getPre(n)) {
                if (bitSet3 != null && bitSet3.get(n2) || bitSet != null && !bitSet.get(n2)) continue;
                bitSet4.set(n2);
                if (bitSet5.get(n2)) continue;
                stack.add(n2);
            }
        }
        return bitSet4;
    }
}

