/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class ListSimple<E> {
    protected List<E> values;
    protected E zero = null;
    protected Predicate<E> isZero = Objects::isNull;

    public ListSimple() {
        this(null, Objects::isNull);
    }

    public ListSimple(E e, Predicate<E> predicate) {
        this.values = null;
        this.setZero(e, predicate);
    }

    public ListSimple(ListSimple<E> listSimple) {
        this.values = listSimple.values == null ? null : new ArrayList<E>(listSimple.values);
        this.setZero(listSimple.zero, listSimple.isZero);
    }

    public <T> ListSimple(ListSimple<T> listSimple, Function<? super T, ? extends E> function, E e, Predicate<E> predicate) {
        if (listSimple.values == null) {
            this.values = null;
        } else {
            this.values = new ArrayList(listSimple.values.size());
            for (E e2 : listSimple.values) {
                this.values.add(function.apply(e2));
            }
        }
        this.setZero(e, predicate);
    }

    public ListSimple(ListSimple<E> listSimple, int[] nArray) {
        if (listSimple.values == null) {
            this.values = null;
        } else {
            int n = nArray.length;
            this.values = new ArrayList(n);
            this.values.addAll(Collections.nCopies(n, null));
            for (int i = 0; i < n; ++i) {
                this.values.set(nArray[i], listSimple.values.get(i));
            }
        }
        this.setZero(listSimple.zero, listSimple.isZero);
    }

    public <T> ListSimple(ListSimple<T> listSimple, int[] nArray, Function<? super T, ? extends E> function, E e, Predicate<E> predicate) {
        if (listSimple.values == null) {
            this.values = null;
        } else {
            int n = nArray.length;
            this.values = new ArrayList(n);
            this.values.addAll(Collections.nCopies(n, null));
            for (int i = 0; i < n; ++i) {
                this.values.set(nArray[i], function.apply(listSimple.values.get(i)));
            }
        }
        this.setZero(e, predicate);
    }

    public void setZero(E e, Predicate<E> predicate) {
        this.zero = e;
        this.isZero = predicate;
    }

    public void setValue(int n, E e) {
        if (this.values == null) {
            if (this.isZero.test(e)) {
                return;
            }
            this.values = new ArrayList(n + 1);
        }
        if (n >= this.values.size()) {
            if (this.isZero.test(e)) {
                return;
            }
            int n2 = n - this.values.size() + 1;
            for (int i = 0; i < n2; ++i) {
                this.values.add(this.zero);
            }
        }
        this.values.set(n, e);
    }

    public E getValue(int n) {
        return this.values == null || n >= this.values.size() ? this.zero : this.values.get(n);
    }

    public boolean allZero() {
        return this.values == null;
    }

    public String toString() {
        return this.values == null ? "[]" : this.values.toString();
    }
}

