/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceBuchi;
import acceptance.AcceptanceGenRabin;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTL2DA;
import automata.LTL2WDBA;
import common.Interval;
import common.IterableStateSet;
import common.StopWatch;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.ECComputer;
import explicit.IDTMC;
import explicit.IDTMCSimple;
import explicit.IMDP;
import explicit.IMDPSimple;
import explicit.IntervalModel;
import explicit.IntervalModelExplicit;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.ModelSimple;
import explicit.NondetModel;
import explicit.POMDP;
import explicit.POMDPSimple;
import explicit.ProbModelChecker;
import explicit.Product;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import explicit.STPG;
import explicit.STPGSimple;
import explicit.StateModelChecker;
import explicit.StateValues;
import java.awt.Point;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import jltl2ba.SimpleLTL;
import parser.State;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class LTLModelChecker
extends PrismComponent {
    public LTLModelChecker(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public static boolean isSupportedLTLFormula(ModelType modelType, Expression expression) throws PrismLangException {
        if (!expression.isPathFormula(true)) {
            return false;
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (modelType.continuousTime()) {
                return false;
            }
            if (!expression.isSimplePathFormula()) {
                return false;
            }
        }
        return true;
    }

    public Expression checkMaximalStateFormulas(StateModelChecker stateModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector) throws PrismException {
        if (expression.getType() instanceof TypeBool) {
            StateValues stateValues = stateModelChecker.checkExpression(model, expression, null);
            BitSet bitSet = stateValues.getBitSet();
            if (bitSet.isEmpty()) {
                return Expression.False();
            }
            if (bitSet.cardinality() == model.getNumStates()) {
                return Expression.True();
            }
            int n = vector.indexOf(bitSet);
            if (n != -1) {
                stateValues.clear();
                return new ExpressionLabel("L" + n);
            }
            BitSet bitSet2 = new BitSet(model.getNumStates());
            bitSet2.set(0, model.getNumStates());
            bitSet2.andNot(bitSet);
            n = vector.indexOf(bitSet2);
            if (n != -1) {
                stateValues.clear();
                return Expression.Not(new ExpressionLabel("L" + n));
            }
            vector.add(bitSet);
            return new ExpressionLabel("L" + (vector.size() - 1));
        }
        if (expression.getType() instanceof TypePathBool) {
            if (expression instanceof ExpressionBinaryOp) {
                ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
                expressionBinaryOp.setOperand1(this.checkMaximalStateFormulas(stateModelChecker, model, expressionBinaryOp.getOperand1(), vector));
                expressionBinaryOp.setOperand2(this.checkMaximalStateFormulas(stateModelChecker, model, expressionBinaryOp.getOperand2(), vector));
            } else if (expression instanceof ExpressionUnaryOp) {
                ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
                expressionUnaryOp.setOperand(this.checkMaximalStateFormulas(stateModelChecker, model, expressionUnaryOp.getOperand(), vector));
            } else if (expression instanceof ExpressionTemporal) {
                ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
                if (expressionTemporal.getOperand1() != null) {
                    expressionTemporal.setOperand1(this.checkMaximalStateFormulas(stateModelChecker, model, expressionTemporal.getOperand1(), vector));
                }
                if (expressionTemporal.getOperand2() != null) {
                    expressionTemporal.setOperand2(this.checkMaximalStateFormulas(stateModelChecker, model, expressionTemporal.getOperand2(), vector));
                }
            }
        }
        return expression;
    }

    public DA<BitSet, ? extends AcceptanceOmega> constructDAForLTLFormula(ProbModelChecker probModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (model.getModelType().continuousTime()) {
                throw new PrismException("Automaton construction for time-bounded operators not supported for " + String.valueOf((Object)model.getModelType()) + ".");
            }
            if (!expression.isSimplePathFormula()) {
                throw new PrismNotSupportedException("Time-bounded operators not supported in LTL: " + String.valueOf(expression));
            }
        }
        Expression expression2 = this.checkMaximalStateFormulas(probModelChecker, model, expression.deepCopy(), vector);
        this.mainLog.println("\nBuilding deterministic automaton (for " + String.valueOf(expression2) + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this);
        DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression2, probModelChecker.getConstantValues(), acceptanceTypeArray);
        this.mainLog.println(dA.getAutomataType() + " has " + dA.size() + " states, " + dA.getAcceptance().getSizeStatistics() + ".");
        dA.checkForCanonicalAPs(vector.size());
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for " + dA.getAutomataType() + " translation: " + (double)l / 1000.0 + " seconds.");
        if (this.settings.getExportPropAut()) {
            this.mainLog.println("Exporting " + dA.getAutomataType() + " to file \"" + this.settings.getExportPropAutFilename() + "\"...");
            PrintStream printStream = PrismUtils.newPrintStream(this.settings.getExportPropAutFilename());
            dA.print(printStream, this.settings.getExportPropAutType());
            printStream.close();
        }
        return dA;
    }

    public DA<BitSet, AcceptanceReach> constructDFAForCosafetyProbLTL(StateModelChecker stateModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector) throws PrismException {
        Expression expression2 = this.checkMaximalStateFormulas(stateModelChecker, model, expression.deepCopy(), vector);
        SimpleLTL simpleLTL = expression2.convertForJltl2ba();
        simpleLTL = simpleLTL.toBasicOperators();
        simpleLTL = simpleLTL.pushNegation();
        LTL2WDBA lTL2WDBA = new LTL2WDBA(this);
        this.mainLog.println("\nBuilding deterministic finite automaton via LTL2WDBA construction (for " + String.valueOf(simpleLTL) + ")...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("constructing DFA");
        DA<BitSet, AcceptanceReach> dA = lTL2WDBA.cosafeltl2dfa(simpleLTL);
        stopWatch.stop("DFA has " + dA.size() + " states");
        return dA;
    }

    public DA<BitSet, AcceptanceReach> constructDFAForCosafetyRewardLTL(StateModelChecker stateModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector) throws PrismException {
        Object object;
        Object object2;
        Expression expression2 = this.checkMaximalStateFormulas(stateModelChecker, model, expression.deepCopy(), vector);
        SimpleLTL simpleLTL = expression2.convertForJltl2ba();
        simpleLTL = simpleLTL.toBasicOperators();
        if ((simpleLTL = simpleLTL.pushNegation()).hasNextStep()) {
            object2 = "L" + vector.size();
            object = new BitSet();
            ((BitSet)object).set(0, model.getNumStates(), true);
            vector.add((BitSet)object);
            simpleLTL = simpleLTL.extendNextStepWithAP((String)object2);
        }
        object2 = new LTL2WDBA(this);
        this.mainLog.println("\nBuilding deterministic finite automaton via LTL2WDBA construction (for " + String.valueOf(simpleLTL) + ")...");
        object = new StopWatch(this.getLog());
        ((StopWatch)object).start("constructing DFA");
        DA<BitSet, AcceptanceReach> dA = ((LTL2WDBA)object2).cosafeltl2dfa(simpleLTL);
        ((StopWatch)object).stop("DFA has " + dA.size() + " states");
        return dA;
    }

    public <Value> LTLProduct<DTMC<Value>> constructProductMC(ProbModelChecker probModelChecker, DTMC<Value> dTMC, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, dTMC, expression, bitSet, acceptanceTypeArray);
    }

    public <Value> LTLProduct<MDP<Value>> constructProductMDP(ProbModelChecker probModelChecker, MDP<Value> mDP, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, mDP, expression, bitSet, acceptanceTypeArray);
    }

    public <Value> LTLProduct<STPG<Value>> constructProductSTPG(ProbModelChecker probModelChecker, STPG<Value> sTPG, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, sTPG, expression, bitSet, acceptanceTypeArray);
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructDAProductForLTLFormula(ProbModelChecker probModelChecker, M m, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, ? extends AcceptanceOmega> dA = this.constructDAForLTLFormula(probModelChecker, m, expression, vector, acceptanceTypeArray);
        this.mainLog.println("Constructing " + String.valueOf((Object)m.getModelType()) + "-" + dA.getAutomataType() + " product...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        LTLProduct<M> lTLProduct = this.constructProductModel(dA, m, vector, bitSet);
        stopWatch.stop("product has " + lTLProduct.getProductModel().infoString());
        return lTLProduct;
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructDFAProductForCosafetyProbLTL(ProbModelChecker probModelChecker, M m, Expression expression, BitSet bitSet) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, AcceptanceReach> dA = this.constructDFAForCosafetyProbLTL(probModelChecker, m, expression, vector);
        this.mainLog.println("Constructing " + String.valueOf((Object)m.getModelType()) + "-" + dA.getAutomataType() + " product...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        LTLProduct<M> lTLProduct = this.constructProductModel(dA, m, vector, bitSet);
        stopWatch.stop("product has " + lTLProduct.getProductModel().infoString());
        return lTLProduct;
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructDFAProductForCosafetyReward(ProbModelChecker probModelChecker, M m, Expression expression, BitSet bitSet) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, AcceptanceReach> dA = this.constructDFAForCosafetyRewardLTL(probModelChecker, m, expression, vector);
        this.mainLog.println("Constructing " + String.valueOf((Object)m.getModelType()) + "-" + dA.getAutomataType() + " product...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        LTLProduct<M> lTLProduct = this.constructProductModel(dA, m, vector, bitSet);
        stopWatch.stop("product has " + lTLProduct.getProductModel().infoString());
        return lTLProduct;
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructProductModel(DA<BitSet, ? extends AcceptanceOmega> dA, M m, Vector<BitSet> vector, BitSet bitSet) throws PrismException {
        Object object;
        Object object2;
        VarList varList = null;
        if (m.getVarList() != null) {
            object2 = m.getVarList();
            object = "_da";
            while (((VarList)object2).exists((String)object)) {
                object = "_" + (String)object;
            }
            varList = (VarList)((VarList)object2).clone();
            Declaration declaration = new Declaration((String)object, new DeclarationInt(Expression.Int(0), Expression.Int(Math.max(dA.size() - 1, 1))));
            varList.addVarAtStart(declaration, 1);
        }
        object2 = m.getModelType();
        object = ModelSimple.forModelType((ModelType)((Object)object2));
        ((ModelExplicit)object).setEvaluator(m.getEvaluator());
        if (object instanceof IntervalModelExplicit) {
            ((IntervalModelExplicit)object).setIntervalEvaluator(((IntervalModel)m).getIntervalEvaluator());
        }
        ((ModelExplicit)object).setVarList(varList);
        return this.doConstructProductModel((ModelType)((Object)object2), (ModelSimple<?>)object, dA, m, vector, bitSet);
    }

    protected <Value, M extends Model<Value>> LTLProduct<M> doConstructProductModel(ModelType modelType, ModelSimple<?> modelSimple, DA<BitSet, ? extends AcceptanceOmega> dA, M m, Vector<BitSet> vector, BitSet bitSet) throws PrismException {
        int n;
        int n2;
        ArrayList<State> arrayList;
        ArrayList<State> arrayList2;
        int n5 = dA.size();
        int n6 = dA.getAPList().size();
        int n7 = m.getNumStates();
        int n8 = Math.multiplyExact(n7, n5);
        BitSet bitSet2 = new BitSet(n6);
        try {
            n8 = Math.multiplyExact(n7, n5);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismException("Size of product state space of model and automaton is too large for explicit engine");
        }
        LinkedList linkedList = new LinkedList();
        BitSet bitSet3 = new BitSet(n8);
        int[] nArray = new int[n8];
        Arrays.fill(nArray, -1);
        if (m.getStatesList() != null) {
            arrayList2 = new ArrayList<State>();
            arrayList = new ArrayList<State>(dA.size());
            for (int i = 0; i < dA.size(); ++i) {
                arrayList.add(new State(1).setValue(0, i));
            }
        } else {
            arrayList2 = null;
            arrayList = null;
        }
        NewStateMap newStateMap = (n3, n4) -> {
            int n5;
            for (n5 = 0; n5 < n6; ++n5) {
                bitSet2.set(n5, ((BitSet)vector.get(Integer.parseInt(dA.getAPList().get(n5).substring(1)))).get(n4));
            }
            n5 = dA.getEdgeDestByLabel(n3, bitSet2);
            if (n5 < 0) {
                throw new PrismException("The deterministic automaton is not complete (state " + n3 + ")");
            }
            if (!bitSet3.get(n4 * n5 + n5) && nArray[n4 * n5 + n5] == -1) {
                linkedList.add(new Point(n4, n5));
                switch (modelType) {
                    case STPG: {
                        ((STPGSimple)modelSimple).addState(((STPG)m).getPlayer(n4));
                        break;
                    }
                    default: {
                        modelSimple.addState();
                    }
                }
                nArray[n4 * n2 + n5] = modelSimple.getNumStates() - 1;
                if (arrayList2 != null) {
                    arrayList2.add(new State((State)arrayList.get(n5), m.getStatesList().get(n4)));
                }
            }
            return nArray[n4 * n5 + n5];
        };
        Object object = new IterableStateSet(bitSet, m.getNumStates()).iterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            n = newStateMap.apply(dA.getStartState(), n2);
            modelSimple.addInitialState(n);
        }
        while (!linkedList.isEmpty()) {
            Iterator iterator;
            object = (Point)linkedList.pop();
            n2 = ((Point)object).x;
            n = ((Point)object).y;
            bitSet3.set(n2 * n5 + n);
            int n9 = nArray[n2 * n5 + n];
            int n10 = m instanceof NondetModel ? ((NondetModel)m).getNumChoices(n2) : 1;
            block27: for (int i = 0; i < n10; ++i) {
                int n11;
                Object object2;
                int n12;
                Map.Entry<Integer, Object> entry;
                iterator = null;
                Iterator iterator2 = null;
                switch (modelType) {
                    case DTMC: {
                        iterator = ((DTMC)m).getTransitionsIterator(n2);
                        break;
                    }
                    case MDP: {
                        iterator = ((MDP)m).getTransitionsIterator(n2, i);
                        break;
                    }
                    case POMDP: {
                        iterator = ((POMDP)m).getTransitionsIterator(n2, i);
                        break;
                    }
                    case IDTMC: {
                        iterator2 = ((IDTMC)m).getIntervalTransitionsIterator(n2);
                        break;
                    }
                    case IMDP: {
                        iterator2 = ((IMDP)m).getIntervalTransitionsIterator(n2, i);
                        break;
                    }
                    case STPG: {
                        iterator = ((STPG)m).getTransitionsIterator(n2, i);
                        break;
                    }
                    default: {
                        throw new PrismNotSupportedException("Product construction not implemented for " + String.valueOf((Object)modelType) + "s");
                    }
                }
                Distribution<Object> distribution = null;
                Distribution<Interval<Object>> distribution2 = null;
                if (modelType.nondeterministic()) {
                    if (modelType != ModelType.IMDP) {
                        distribution = new Distribution<Object>(m.getEvaluator());
                    } else {
                        distribution2 = new Distribution<Interval<Object>>(((IMDP)m).getIntervalEvaluator());
                    }
                }
                if (!(m instanceof IntervalModel)) {
                    block28: while (iterator.hasNext()) {
                        entry = iterator.next();
                        n12 = entry.getKey();
                        object2 = entry.getValue();
                        n11 = newStateMap.apply(n, n12);
                        switch (modelType) {
                            case DTMC: {
                                ((DTMCSimple)modelSimple).setProbability(n9, n11, object2);
                                continue block28;
                            }
                            case MDP: 
                            case POMDP: 
                            case STPG: {
                                distribution.set(n11, object2);
                                continue block28;
                            }
                        }
                        throw new PrismNotSupportedException("Product construction not implemented for " + String.valueOf((Object)modelType) + "s");
                    }
                } else {
                    block29: while (iterator2.hasNext()) {
                        entry = iterator2.next();
                        n12 = entry.getKey();
                        object2 = (Interval)entry.getValue();
                        n11 = newStateMap.apply(n, n12);
                        switch (modelType) {
                            case IDTMC: {
                                ((IDTMCSimple)modelSimple).setProbability(n9, n11, object2);
                                continue block29;
                            }
                            case IMDP: {
                                distribution2.set(n11, (Interval<Object>)object2);
                                continue block29;
                            }
                        }
                        throw new PrismNotSupportedException("Product construction not implemented for " + String.valueOf((Object)modelType) + "s");
                    }
                }
                switch (modelType) {
                    case MDP: {
                        ((MDPSimple)modelSimple).addActionLabelledChoice(n9, distribution, ((MDP)m).getAction(n2, i));
                        continue block27;
                    }
                    case POMDP: {
                        ((POMDPSimple)modelSimple).addActionLabelledChoice(n9, distribution, ((POMDP)m).getAction(n2, i));
                        continue block27;
                    }
                    case IMDP: {
                        ((IMDPSimple)modelSimple).addActionLabelledChoice(n9, distribution2, ((IMDP)m).getAction(n2, i));
                        continue block27;
                    }
                    case STPG: {
                        ((STPGSimple)modelSimple).addActionLabelledChoice(n9, distribution, ((STPG)m).getAction(n2, i));
                        continue block27;
                    }
                }
            }
            if (modelType != ModelType.POMDP) continue;
            State state = ((POMDP)m).getObservationAsState(n2);
            iterator = ((POMDP)m).getUnobservationAsState(n2);
            ((POMDPSimple)modelSimple).setObservation(n9, state, (State)((Object)iterator), null);
        }
        object = new int[modelSimple.getNumStates()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == -1) continue;
            object[nArray[n2]] = n2;
        }
        modelSimple.findDeadlocks(false);
        if (arrayList2 != null) {
            modelSimple.setStatesList(arrayList2);
        }
        LTLProduct lTLProduct = new LTLProduct(this, modelSimple, m, null, n5, (int[])object);
        lTLProduct.setAcceptance(this.liftAcceptance(lTLProduct, dA.getAcceptance()));
        for (String string : m.getLabels()) {
            BitSet bitSet4 = lTLProduct.liftFromModel(m.getLabelStates(string));
            modelSimple.addLabel(string, bitSet4);
        }
        return lTLProduct;
    }

    public BitSet findAcceptingBSCCs(Model<?> model, AcceptanceOmega acceptanceOmega) throws PrismException {
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, model, sCCConsumerStore);
        sCCComputer.computeSCCs();
        List<BitSet> list = sCCConsumerStore.getBSCCs();
        BitSet bitSet = new BitSet();
        for (BitSet bitSet2 : list) {
            if (!acceptanceOmega.isBSCCAccepting(bitSet2)) continue;
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public BitSet findAcceptingECStates(NondetModel<?> nondetModel, AcceptanceOmega acceptanceOmega) throws PrismException {
        if (acceptanceOmega instanceof AcceptanceBuchi) {
            return this.findAcceptingECStatesForBuchi(nondetModel, (AcceptanceBuchi)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceRabin) {
            return this.findAcceptingECStatesForRabin(nondetModel, (AcceptanceRabin)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceStreett) {
            return this.findAcceptingECStatesForStreett(nondetModel, (AcceptanceStreett)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceGenRabin) {
            return this.findAcceptingECStatesForGeneralizedRabin(nondetModel, (AcceptanceGenRabin)acceptanceOmega);
        }
        throw new PrismNotSupportedException("Computing end components for acceptance type '" + String.valueOf((Object)acceptanceOmega.getType()) + "' currently not supported (explicit engine).");
    }

    public BitSet findAcceptingECStatesForBuchi(NondetModel<?> nondetModel, AcceptanceBuchi acceptanceBuchi) throws PrismException {
        BitSet bitSet = new BitSet();
        if (acceptanceBuchi.getAcceptingStates().isEmpty()) {
            return bitSet;
        }
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates();
        List<BitSet> list = eCComputer.getMECStates();
        for (BitSet bitSet2 : list) {
            if (!bitSet2.intersects(acceptanceBuchi.getAcceptingStates())) continue;
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForRabin(NondetModel<?> nondetModel, AcceptanceRabin acceptanceRabin) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = nondetModel.getNumStates();
        for (int i = 0; i < acceptanceRabin.size(); ++i) {
            BitSet bitSet2 = ((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getL();
            BitSet bitSet3 = new BitSet();
            for (int j = 0; j < n; ++j) {
                if (bitSet2.get(j)) continue;
                bitSet3.set(j);
            }
            if (bitSet3.cardinality() == 0) continue;
            ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates(bitSet3, ((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getK());
            List<BitSet> list = eCComputer.getMECStates();
            for (BitSet bitSet4 : list) {
                bitSet.or(bitSet4);
            }
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForStreett(NondetModel<?> nondetModel, AcceptanceStreett acceptanceStreett) throws PrismException {
        Object object;
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(0, acceptanceStreett.size());
        class ECandPairs {
            BitSet MEC;
            BitSet activePairs;

            ECandPairs() {
            }
        }
        Stack<ECandPairs> stack = new Stack<ECandPairs>();
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates();
        for (BitSet bitSet3 : eCComputer.getMECStates()) {
            object = new ECandPairs();
            ((ECandPairs)object).MEC = bitSet3;
            ((ECandPairs)object).activePairs = bitSet2;
            stack.push((ECandPairs)object);
        }
        while (!stack.empty()) {
            BitSet bitSet3;
            ECandPairs eCandPairs = (ECandPairs)stack.pop();
            bitSet3 = (BitSet)eCandPairs.activePairs.clone();
            object = null;
            boolean bl = true;
            int n = eCandPairs.activePairs.nextSetBit(0);
            while (n != -1) {
                if (!((AcceptanceStreett.StreettPair)acceptanceStreett.get(n)).isBSCCAccepting(eCandPairs.MEC)) {
                    if (object == null) {
                        object = (BitSet)eCandPairs.MEC.clone();
                    }
                    ((BitSet)object).andNot(((AcceptanceStreett.StreettPair)acceptanceStreett.get(n)).getR());
                    bitSet3.clear(n);
                    bl = false;
                }
                n = eCandPairs.activePairs.nextSetBit(n + 1);
            }
            if (bl) {
                bitSet.or(eCandPairs.MEC);
                continue;
            }
            if (((BitSet)object).isEmpty()) continue;
            eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates((BitSet)object);
            for (BitSet bitSet4 : eCComputer.getMECStates()) {
                ECandPairs eCandPairs2 = new ECandPairs();
                eCandPairs2.MEC = bitSet4;
                eCandPairs2.activePairs = bitSet3;
                stack.push(eCandPairs2);
            }
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForGeneralizedRabin(NondetModel<?> nondetModel, AcceptanceGenRabin acceptanceGenRabin) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = nondetModel.getNumStates();
        for (int i = 0; i < acceptanceGenRabin.size(); ++i) {
            BitSet bitSet2 = ((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getL();
            BitSet bitSet3 = new BitSet();
            for (int j = 0; j < n; ++j) {
                if (bitSet2.get(j)) continue;
                bitSet3.set(j);
            }
            if (bitSet3.cardinality() == 0) continue;
            ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates(bitSet3);
            List<BitSet> list = eCComputer.getMECStates();
            int n2 = ((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getNumK();
            for (BitSet bitSet4 : list) {
                boolean bl = true;
                for (int j = 0; j < n2; ++j) {
                    if (bitSet4.intersects(((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getK(j))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                bitSet.or(bitSet4);
            }
        }
        return bitSet;
    }

    private AcceptanceOmega liftAcceptance(final LTLProduct<?> lTLProduct, AcceptanceOmega acceptanceOmega) {
        AcceptanceOmega acceptanceOmega2 = acceptanceOmega.clone();
        acceptanceOmega2.lift(new AcceptanceOmega.LiftBitSet(){

            @Override
            public BitSet lift(BitSet bitSet) {
                return lTLProduct.liftFromAutomaton(bitSet);
            }
        });
        return acceptanceOmega2;
    }

    public static class LTLProduct<M extends Model<?>>
    extends Product<M> {
        private int daSize;
        private int[] invMap;
        private AcceptanceOmega acceptance;
        final /* synthetic */ LTLModelChecker this$0;

        public LTLProduct(M m, M m2, AcceptanceOmega acceptanceOmega, int n, int[] nArray) {
            this.this$0 = var1_1;
            super(m, m2);
            this.daSize = n;
            this.invMap = nArray;
            this.acceptance = acceptanceOmega;
        }

        @Override
        public int getModelState(int n) {
            return this.invMap[n] / this.daSize;
        }

        @Override
        public int getAutomatonState(int n) {
            return this.invMap[n] % this.daSize;
        }

        @Override
        public int getAutomatonSize() {
            return this.daSize;
        }

        public AcceptanceOmega getAcceptance() {
            return this.acceptance;
        }

        public void setAcceptance(AcceptanceOmega acceptanceOmega) {
            this.acceptance = acceptanceOmega;
        }
    }

    @FunctionalInterface
    static interface NewStateMap {
        public int apply(int var1, int var2) throws PrismException;
    }
}

