/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.BirthProcess;
import explicit.StateValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.LabelList;
import parser.ast.RewardStruct;
import prism.ModelGenerator;
import prism.PrismComponent;
import prism.PrismException;

public final class FastAdaptiveUniformisation
extends PrismComponent {
    private ModelGenerator<Double> modelGen;
    private double epsilon;
    private double delta;
    private int numIntervals;
    private int arrayThreshold;
    private RewardStruct rewStruct = null;
    private double value;
    private Values constantValues = null;
    private LinkedHashMap<State, StateProp> states;
    private ArrayList<State> addDistr;
    private ArrayList<State> deleteStates;
    private final int initSize = 3000;
    private double maxRate = 0.0;
    private Expression target;
    private int itersUnchanged;
    private double birthProbSum;
    private BirthProcess birthProc;
    private Expression sink;
    private boolean keepSumProb;
    private int maxNumStates;
    private LabelList specialLabels;
    private HashSet<State> initStates;
    private AnalysisType analysisType;
    private double totalProbLoss;
    private double totalProbSetZero;

    public FastAdaptiveUniformisation(PrismComponent prismComponent, ModelGenerator<Double> modelGenerator) throws PrismException {
        super(prismComponent);
        this.modelGen = modelGenerator;
        this.maxNumStates = 0;
        this.epsilon = this.settings.getDouble("prism.fau.epsilon");
        this.delta = this.settings.getDouble("prism.fau.delta");
        this.numIntervals = this.settings.getInteger("prism.fau.intervals");
        this.arrayThreshold = this.settings.getInteger("prism.fau.arraythreshold");
        this.analysisType = AnalysisType.TRANSIENT;
        this.rewStruct = null;
        this.target = Expression.False();
        this.sink = Expression.False();
        this.specialLabels = new LabelList();
        this.specialLabels.addLabel(new ExpressionIdent("deadlock"), new ExpressionIdent("deadlock"));
        this.specialLabels.addLabel(new ExpressionIdent("init"), new ExpressionIdent("init"));
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType;
    }

    public void setConstantValues(Values values) {
        this.constantValues = values;
    }

    public void setRewardStruct(RewardStruct rewardStruct) {
        this.rewStruct = rewardStruct;
    }

    public void setTarget(Expression expression) {
        this.target = expression;
    }

    public int getMaxNumStates() {
        return this.maxNumStates;
    }

    public double getValue() {
        return this.value;
    }

    public void setSink(Expression expression) throws PrismException {
        this.sink = expression;
        if (this.states != null) {
            for (Map.Entry<State, StateProp> entry : this.states.entrySet()) {
                State state = entry.getKey();
                StateProp stateProp = entry.getValue();
                this.modelGen.exploreState(state);
                this.specialLabels.setLabel(0, this.modelGen.getNumTransitions() == 0 ? Expression.True() : Expression.False());
                this.specialLabels.setLabel(1, this.initStates.contains(state) ? Expression.True() : Expression.False());
                Expression expression2 = expression.deepCopy();
                if (!(expression2 = (Expression)expression2.expandLabels(this.specialLabels)).evaluateBoolean(this.constantValues, state)) continue;
                double[] dArray = new double[1];
                StateProp[] statePropArray = new StateProp[1];
                dArray[0] = 1.0;
                statePropArray[0] = this.states.get(state);
                stateProp.setSuccRates(dArray);
                stateProp.setSuccStates(statePropArray);
            }
        }
    }

    public int getNumStates() {
        return this.states.size();
    }

    public StateValues doTransient(double d) throws PrismException {
        return this.doTransient(d, null);
    }

    public StateValues doTransient(double d, StateValues stateValues) throws PrismException {
        Object object;
        int n;
        ListIterator<State> listIterator;
        if (!this.modelGen.hasSingleInitialState()) {
            throw new PrismException("Fast adaptive uniformisation does not yet support models with multiple initial states");
        }
        this.mainLog.println("\nComputing probabilities (fast adaptive uniformisation)...");
        if (stateValues == null) {
            listIterator = new ArrayList<State>();
            listIterator.add(this.modelGen.getInitialState());
            stateValues = StateValues.createFromDoubleArray(new double[]{1.0}, listIterator);
        }
        this.addDistr = new ArrayList();
        this.deleteStates = new ArrayList();
        this.states = new LinkedHashMap(3000);
        this.value = 0.0;
        this.initStates = new HashSet();
        listIterator = stateValues.statesList.listIterator();
        double[] dArray = stateValues.getDoubleArray();
        this.maxRate = 0.0;
        for (n = 0; n < stateValues.size; ++n) {
            object = (State)listIterator.next();
            this.addToModel((State)object);
        }
        listIterator = stateValues.statesList.listIterator();
        for (n = 0; n < stateValues.size; ++n) {
            object = listIterator.next();
            this.computeStateRatesAndRewards((State)object);
            this.states.get(object).setProb(dArray[n]);
            this.maxRate = Math.max(this.maxRate, this.states.get(object).sumRates() * 1.02);
        }
        this.computeTransientProbsAdaptive(d);
        ArrayList<State> arrayList = new ArrayList<State>(this.states.size());
        object = new double[this.states.size()];
        int n2 = 0;
        for (Map.Entry<State, StateProp> entry : this.states.entrySet()) {
            arrayList.add(entry.getKey());
            object[n2] = entry.getValue().getProb();
            ++n2;
        }
        StateValues stateValues2 = StateValues.createFromDoubleArray((double[])object, arrayList);
        this.mainLog.println("\nTotal probability lost is : " + this.getTotalDiscreteLoss());
        this.mainLog.println("Maximal number of states stored during analysis : " + this.getMaxNumStates());
        return stateValues2;
    }

    public void computeTransientProbsAdaptive(double d) throws PrismException {
        double d2;
        if (this.addDistr == null) {
            this.addDistr = new ArrayList();
            this.deleteStates = new ArrayList();
            this.states = new LinkedHashMap(3000);
            this.value = 0.0;
            this.prepareInitialDistribution();
        }
        if (d - (d2 = this.settings.getDouble("prism.fau.initival")) < 0.0) {
            d2 = 0.0;
        }
        if (d2 != 0.0) {
            this.iterateAdaptiveInterval(d2);
            for (StateProp stateProp : this.states.values()) {
                stateProp.setProb(stateProp.getSum());
                stateProp.setSum(0.0);
                stateProp.setNextProb(0.0);
            }
            this.updateStates();
        }
        for (int i = 0; i < this.numIntervals; ++i) {
            double d3 = (d - d2) / (double)this.numIntervals;
            this.iterateAdaptiveInterval(d3);
            for (StateProp object : this.states.values()) {
                object.setProb(object.getSum());
                object.setSum(0.0);
                object.setNextProb(0.0);
            }
            this.updateStates();
        }
        if (AnalysisType.REW_INST == this.analysisType) {
            for (StateProp stateProp : this.states.values()) {
                this.value += stateProp.getProb() * stateProp.getReward();
            }
        } else {
            for (Map.Entry<State, StateProp> entry : this.states.entrySet()) {
                State state = entry.getKey();
                StateProp stateProp = entry.getValue();
                this.modelGen.exploreState(state);
                this.specialLabels.setLabel(0, this.modelGen.getNumTransitions() == 0 ? Expression.True() : Expression.False());
                this.specialLabels.setLabel(1, this.initStates.contains(state) ? Expression.True() : Expression.False());
                Expression expression2 = this.target.deepCopy();
                expression2 = (Expression)expression2.expandLabels(this.specialLabels);
                if (AnalysisType.REACH != this.analysisType) continue;
                this.value += stateProp.getProb() * (expression2.evaluateBoolean(this.constantValues, state) ? 1.0 : 0.0);
            }
        }
    }

    private void iterateAdaptiveInterval(double d) throws PrismException {
        this.birthProc = new BirthProcess();
        this.birthProc.setTime(d);
        this.birthProc.setEpsilon(this.epsilon);
        int n = 0;
        this.birthProbSum = 0.0;
        this.itersUnchanged = 0;
        this.keepSumProb = false;
        while (this.birthProbSum < 1.0 - this.epsilon) {
            if (this.birthProbSum >= this.epsilon / 2.0) {
                this.keepSumProb = true;
            }
            if (this.itersUnchanged == this.arrayThreshold) {
                n = this.arrayIterate(n);
                continue;
            }
            long l = System.currentTimeMillis();
            double d2 = this.birthProc.calculateNextProb(this.maxRate);
            l = System.currentTimeMillis() - l;
            this.birthProbSum += d2;
            this.collectValuePostIter(d2, this.birthProbSum);
            for (StateProp stateProp : this.states.values()) {
                stateProp.addToSum(d2);
            }
            this.mvMult(this.maxRate);
            this.updateStates();
            ++n;
        }
        this.computeTotalDiscreteLoss();
    }

    /*
     * Could not resolve type clashes
     */
    private int arrayIterate(int n) throws PrismException {
        Object[] objectArray;
        Object object5;
        Object object22;
        Object object32;
        Object object42;
        int n2 = this.states.size();
        int n3 = 0;
        for (Object object42 : this.states.values()) {
            n3 += ((StateProp)object42).getNumSuccs() + 1;
        }
        int n4 = 0;
        object42 = new HashMap(n2);
        StateProp[] statePropArray = new StateProp[n2];
        for (Object object32 : this.states.values()) {
            if (!((StateProp)object32).isAlive()) continue;
            ((HashMap)object42).put(object32, n4);
            statePropArray[n4] = object32;
            ++n4;
        }
        int n5 = n4;
        for (Object object22 : this.states.values()) {
            if (((StateProp)object22).isAlive()) continue;
            ((HashMap)object42).put(object22, n4);
            statePropArray[n4] = object22;
            ++n4;
        }
        object32 = new double[n3];
        object22 = new int[n2 + 1];
        int[] nArray = new int[n3];
        double[] dArray = new double[n2];
        for (Object object5 : this.states.values()) {
            StateProp[] statePropArray2 = ((StateProp)object5).getSuccStates();
            if (statePropArray2 != null) {
                for (StateProp stateProp : statePropArray2) {
                    Object object6 = object22;
                    int n6 = (Integer)((HashMap)object42).get(stateProp) + 1;
                    object6[n6] = object6[n6] + true;
                }
            }
            Object object7 = object22;
            int n7 = (Integer)((HashMap)object42).get(object5) + 1;
            object7[n7] = object7[n7] + true;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            Object object8 = object22;
            int n8 = n4 + 1;
            object8[n8] = object8[n8] + object22[n4];
        }
        for (Object object5 : this.states.values()) {
            int n9 = (Integer)((HashMap)object42).get(object5);
            objectArray = ((StateProp)object5).getSuccStates();
            double[] dArray2 = ((StateProp)object5).getSuccRates();
            if (objectArray == null) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                StateProp stateProp;
                stateProp = objectArray[i];
                int n10 = (Integer)((HashMap)object42).get(stateProp);
                double d = dArray2[i];
                nArray[object22[n10]] = n9;
                object32[object22[n10]] = d / this.maxRate;
                Object object9 = object22;
                int n11 = n10;
                object9[n11] = object9[n11] + true;
                int n12 = n9;
                dArray[n12] = dArray[n12] + d;
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            nArray[object22[n4]] = n4;
            object32[object22[n4]] = (this.maxRate - dArray[n4]) / this.maxRate;
        }
        Arrays.fill((int[])object22, 0);
        for (Object object5 : this.states.values()) {
            StateProp[] statePropArray3 = ((StateProp)object5).getSuccStates();
            if (statePropArray3 != null) {
                for (StateProp stateProp : statePropArray3) {
                    Object object10 = object22;
                    int n13 = (Integer)((HashMap)object42).get(stateProp) + 1;
                    object10[n13] = object10[n13] + true;
                }
            }
            Object object11 = object22;
            int n14 = (Integer)((HashMap)object42).get(object5) + 1;
            object11[n14] = object11[n14] + true;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            Object object12 = object22;
            int n15 = n4 + 1;
            object12[n15] = object12[n15] + object22[n4];
        }
        Object object13 = new double[n2];
        object5 = new double[n2];
        Object object14 = new double[n2];
        objectArray = new double[n2];
        for (n4 = 0; n4 < statePropArray.length; ++n4) {
            StateProp stateProp = statePropArray[n4];
            if (this.analysisType == AnalysisType.REW_CUMUL) {
                object13[n4] = stateProp.getReward();
            }
            object5[n4] = stateProp.getProb();
            objectArray[n4] = (StateProp)stateProp.getSum();
        }
        boolean bl = true;
        while (this.birthProbSum < 1.0 - this.epsilon && bl) {
            double d = this.birthProc.calculateNextProb(this.maxRate);
            this.birthProbSum += d;
            double d2 = (1.0 - this.birthProbSum) / this.maxRate;
            for (n4 = 0; n4 < n2; ++n4) {
                this.value += object5[n4] * d2 * object13[n4];
                int n16 = n4;
                objectArray[n16] = objectArray[n16] + d * object5[n4];
                object14[n4] = 0.0;
                for (reference var21_35 = object22[n4]; var21_35 < object22[n4 + 1]; ++var21_35) {
                    int n17 = n4;
                    object14[n17] = object14[n17] + object32[var21_35] * object5[nArray[var21_35]];
                }
                if (n4 < n5 != object14[n4] > this.delta) {
                    bl = false;
                    continue;
                }
                if (n4 < n5) continue;
                object14[n4] = 0.0;
            }
            Object object15 = object5;
            object5 = object14;
            object14 = object15;
            ++n;
        }
        for (n4 = 0; n4 < statePropArray.length; ++n4) {
            StateProp stateProp = statePropArray[n4];
            stateProp.setProb((double)object5[n4]);
            stateProp.setSum((double)objectArray[n4]);
        }
        this.updateStates();
        return n;
    }

    private void collectValuePostIter(double d, double d2) {
        switch (this.analysisType.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                double d3 = (1.0 - d2) / this.maxRate;
                for (StateProp stateProp : this.states.values()) {
                    this.value += stateProp.getProb() * d3 * stateProp.getReward();
                }
                break;
            }
        }
    }

    private void updateStates() throws PrismException {
        this.maxRate = 0.0;
        this.addDistr.clear();
        for (Map.Entry<State, StateProp> entry : this.states.entrySet()) {
            State state = entry.getKey();
            StateProp stateProp = entry.getValue();
            if (stateProp.getProb() > this.delta) {
                stateProp.setAlive(true);
                if (!stateProp.hasSuccs()) {
                    this.itersUnchanged = 0;
                    this.addDistr.add(state);
                    continue;
                }
                this.maxRate = Math.max(this.maxRate, stateProp.sumRates());
                continue;
            }
            stateProp.delete();
        }
        for (int i = 0; i < this.addDistr.size(); ++i) {
            this.computeStateRatesAndRewards(this.addDistr.get(i));
            this.maxRate = Math.max(this.maxRate, this.states.get(this.addDistr.get(i)).sumRates());
        }
        this.maxRate *= 1.02;
        this.removeDeletedStates();
    }

    private void removeDeletedStates() {
        boolean bl = true;
        for (Map.Entry<State, StateProp> entry : this.states.entrySet()) {
            State state = entry.getKey();
            StateProp stateProp = entry.getValue();
            if (!stateProp.canRemove()) continue;
            this.deleteStates.add(state);
            bl = false;
        }
        if (!this.keepSumProb) {
            for (int i = 0; i < this.deleteStates.size(); ++i) {
                this.states.remove(this.deleteStates.get(i));
            }
        }
        this.itersUnchanged = bl ? ++this.itersUnchanged : 0;
        this.deleteStates.clear();
    }

    private void prepareInitialDistribution() throws PrismException {
        this.initStates = new HashSet();
        State state = this.modelGen.getInitialState();
        this.initStates.add(state);
        this.addToModel(state);
        this.computeStateRatesAndRewards(state);
        this.states.get(state).setProb(1.0);
        this.maxRate = this.states.get(state).sumRates() * 1.02;
    }

    public void computeTotalDiscreteLoss() {
        double d = 0.0;
        for (StateProp stateProp : this.states.values()) {
            d += stateProp.getSum();
        }
        this.totalProbLoss = 1.0 - (d += this.totalProbSetZero);
    }

    public double getTotalDiscreteLoss() {
        return this.totalProbLoss;
    }

    public void clearSinkStates() throws PrismException {
        for (Map.Entry<State, StateProp> entry : this.states.entrySet()) {
            State state = entry.getKey();
            StateProp stateProp = entry.getValue();
            this.modelGen.exploreState(state);
            this.specialLabels.setLabel(0, this.modelGen.getNumTransitions() == 0 ? Expression.True() : Expression.False());
            this.specialLabels.setLabel(1, this.initStates.contains(state) ? Expression.True() : Expression.False());
            Expression expression = this.sink.deepCopy();
            if (!(expression = (Expression)expression.expandLabels(this.specialLabels)).evaluateBoolean(this.constantValues, state)) continue;
            this.totalProbSetZero += stateProp.getProb();
            stateProp.setProb(0.0);
        }
    }

    private void addToModel(State state) throws PrismException {
        StateProp stateProp = new StateProp();
        stateProp.setReward(this.computeRewards(state));
        this.states.put(state, stateProp);
        this.maxNumStates = Math.max(this.maxNumStates, this.states.size());
    }

    private void computeStateRatesAndRewards(State state) throws PrismException {
        StateProp[] statePropArray;
        double[] dArray;
        this.modelGen.exploreState(state);
        this.specialLabels.setLabel(0, this.modelGen.getNumTransitions() == 0 ? Expression.True() : Expression.False());
        this.specialLabels.setLabel(1, this.initStates.contains(state) ? Expression.True() : Expression.False());
        Expression expression = this.sink.deepCopy();
        expression = (Expression)expression.expandLabels(this.specialLabels);
        if (expression.evaluateBoolean(this.constantValues, state)) {
            dArray = new double[1];
            statePropArray = new StateProp[1];
            dArray[0] = 1.0;
            statePropArray[0] = this.states.get(state);
        } else {
            int n = this.modelGen.getNumTransitions();
            if (n > 0) {
                dArray = new double[n];
                statePropArray = new StateProp[n];
                int n2 = 0;
                int n3 = this.modelGen.getNumChoices();
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.modelGen.getNumTransitions(i);
                    for (int j = 0; j < n4; ++j) {
                        State state2 = this.modelGen.computeTransitionTarget(i, j);
                        StateProp stateProp = this.states.get(state2);
                        if (null == stateProp) {
                            this.addToModel(state2);
                            stateProp = this.states.get(state2);
                            this.modelGen.exploreState(state);
                        }
                        dArray[n2] = this.modelGen.getTransitionProbability(i, j);
                        statePropArray[n2] = stateProp;
                        ++n2;
                    }
                }
            } else {
                dArray = new double[1];
                statePropArray = new StateProp[1];
                dArray[0] = 1.0;
                statePropArray[0] = this.states.get(state);
            }
        }
        this.states.get(state).setSuccRates(dArray);
        this.states.get(state).setSuccStates(statePropArray);
    }

    private void mvMult(double d) {
        for (StateProp stateProp : this.states.values()) {
            double[] dArray = stateProp.getSuccRates();
            StateProp[] statePropArray = stateProp.getSuccStates();
            double d2 = stateProp.getProb();
            if (null == statePropArray) continue;
            double d3 = 0.0;
            for (int i = 0; i < statePropArray.length; ++i) {
                double d4 = dArray[i];
                d3 += d4;
                statePropArray[i].addToNextProb(d4 / d * d2);
            }
            stateProp.addToNextProb((d - d3) / d * stateProp.getProb());
        }
        for (StateProp stateProp : this.states.values()) {
            stateProp.prepareNextIteration();
        }
    }

    private boolean isRewardAnalysis() {
        return this.analysisType == AnalysisType.REW_INST || this.analysisType == AnalysisType.REW_CUMUL;
    }

    private double computeRewards(State state) throws PrismException {
        if (!this.isRewardAnalysis()) {
            return 0.0;
        }
        int n = 0;
        if (AnalysisType.REW_CUMUL == this.analysisType) {
            this.modelGen.exploreState(state);
            n = this.modelGen.getNumChoices();
        }
        double d = 0.0;
        int n2 = this.rewStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = this.rewStruct.getStates(i);
            if (!expression.evaluateBoolean(this.constantValues, state)) continue;
            double d2 = this.rewStruct.getReward(i).evaluateDouble(this.constantValues, state);
            String string = this.rewStruct.getSynch(i);
            if (string != null) {
                if (AnalysisType.REW_CUMUL != this.analysisType) continue;
                for (int j = 0; j < n; ++j) {
                    int n3 = this.modelGen.getNumTransitions(j);
                    for (int k = 0; k < n3; ++k) {
                        Object object = this.modelGen.getTransitionAction(j, k);
                        if (object == null) {
                            object = "";
                        }
                        if (!object.toString().equals(string)) continue;
                        d += d2 * this.modelGen.getTransitionProbability(j, k);
                    }
                }
                continue;
            }
            d += d2;
        }
        return d;
    }

    public static enum AnalysisType {
        TRANSIENT,
        REACH,
        REW_INST,
        REW_CUMUL;

    }

    private static final class StateProp {
        private double prob = 0.0;
        private double nextProb = 0.0;
        private double sum = 0.0;
        private double reward = 0.0;
        private double[] succRates = null;
        private StateProp[] succStates = null;
        private int references = 0;
        private boolean alive = true;

        StateProp() {
        }

        void setProb(double d) {
            this.prob = d;
        }

        double getProb() {
            return this.prob;
        }

        void setNextProb(double d) {
            this.nextProb = d;
        }

        void addToNextProb(double d) {
            this.nextProb += d;
        }

        void setSum(double d) {
            this.sum = d;
        }

        void addToSum(double d) {
            this.sum += d * this.prob;
        }

        double getSum() {
            return this.sum;
        }

        void prepareNextIteration() {
            this.prob = this.nextProb;
            this.nextProb = 0.0;
        }

        void setReward(double d) {
            this.reward = d;
        }

        double getReward() {
            return this.reward;
        }

        void setSuccRates(double[] dArray) {
            this.succRates = dArray;
        }

        void setSuccStates(StateProp[] statePropArray) {
            this.succStates = statePropArray;
            if (statePropArray != null) {
                for (int i = 0; i < statePropArray.length; ++i) {
                    statePropArray[i].incReferences();
                }
            }
        }

        int getNumSuccs() {
            if (this.succRates == null) {
                return 0;
            }
            return this.succRates.length;
        }

        double[] getSuccRates() {
            return this.succRates;
        }

        StateProp[] getSuccStates() {
            return this.succStates;
        }

        void setAlive(boolean bl) {
            this.alive = bl;
        }

        boolean isAlive() {
            return this.alive;
        }

        void incReferences() {
            ++this.references;
        }

        void decReferences() {
            --this.references;
        }

        void delete() {
            if (null != this.succStates) {
                for (int i = 0; i < this.succStates.length; ++i) {
                    this.succStates[i].decReferences();
                }
            }
            this.succStates = null;
            this.succRates = null;
            this.alive = false;
            this.prob = 0.0;
            this.nextProb = 0.0;
        }

        boolean canRemove() {
            return !this.alive && 0 == this.references;
        }

        boolean hasSuccs() {
            return this.succStates != null;
        }

        double sumRates() {
            if (null == this.succRates) {
                return 0.0;
            }
            double d = 0.0;
            for (int i = 0; i < this.succRates.length; ++i) {
                d += this.succRates[i];
            }
            return d;
        }
    }
}

