/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.iterable.Reducible;
import explicit.ChoiceActionsSimple;
import explicit.DTMC;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.ModelSimple;
import explicit.SuccessorsIterator;
import io.ExplicitModelImporter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import prism.Evaluator;
import prism.Pair;
import prism.PrismException;

public class DTMCSimple<Value>
extends DTMCExplicit<Value>
implements ModelSimple<Value> {
    protected List<List<Integer>> succ;
    protected List<List<Value>> trans;
    protected ChoiceActionsSimple actions;

    public DTMCSimple() {
        this.initialise(0);
    }

    public DTMCSimple(int n) {
        this.initialise(n);
    }

    public DTMCSimple(DTMCSimple<Value> dTMCSimple) {
        this(dTMCSimple.numStates);
        this.copyFrom(dTMCSimple);
        for (int i = 0; i < this.numStates; ++i) {
            this.succ.set(i, new ArrayList(dTMCSimple.succ.get(i)));
            this.trans.set(i, new ArrayList(dTMCSimple.trans.get(i)));
        }
        this.actions = new ChoiceActionsSimple(dTMCSimple.actions);
    }

    public DTMCSimple(DTMCSimple<Value> dTMCSimple, int[] nArray) {
        this(dTMCSimple.numStates);
        this.copyFrom(dTMCSimple, nArray);
        for (int i = 0; i < this.numStates; ++i) {
            int n = dTMCSimple.succ.get(i).size();
            for (int j = 0; j < n; ++j) {
                this.succ.get(nArray[i]).add(nArray[dTMCSimple.succ.get(i).get(j)]);
                this.trans.get(nArray[i]).add(dTMCSimple.trans.get(i).get(j));
            }
        }
        this.actions = new ChoiceActionsSimple(dTMCSimple.actions, nArray);
    }

    public DTMCSimple(DTMC<Value> dTMC) {
        this(dTMC, object -> object);
    }

    public DTMCSimple(DTMC<Value> dTMC, Function<? super Value, ? extends Value> function) {
        this(dTMC, function, dTMC.getEvaluator());
    }

    public <T> DTMCSimple(DTMC<T> dTMC, Function<? super T, ? extends Value> function, Evaluator<Value> evaluator) {
        this(dTMC.getNumStates());
        this.copyFrom(dTMC);
        this.setEvaluator(evaluator);
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Iterator<Map.Entry<Integer, Pair<T, Object>>> iterator = dTMC.getTransitionsAndActionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<T, Object>> entry = iterator.next();
                this.addToProbability(i, entry.getKey(), function.apply(entry.getValue().first), entry.getValue().second);
            }
        }
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.succ = new ArrayList<List<Integer>>(n);
        this.trans = new ArrayList<List<Value>>(n);
        for (int i = 0; i < n; ++i) {
            this.succ.add(new ArrayList());
            this.trans.add(new ArrayList());
        }
        this.actions = new ChoiceActionsSimple();
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        this.succ.get(n).clear();
        this.trans.get(n).clear();
        this.actions.clearState(n);
        this.actionList.markNeedsRecomputing();
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.succ.add(new ArrayList());
            this.trans.add(new ArrayList());
            ++this.numStates;
        }
    }

    @Override
    public void buildFromExplicitImport(ExplicitModelImporter explicitModelImporter) throws PrismException {
        this.initialise(explicitModelImporter.getNumStates());
        explicitModelImporter.extractMCTransitions(this::setProbability, this.getEvaluator());
    }

    public void setProbability(int n, int n2, Value Value2) {
        this.setProbability(n, n2, Value2, null);
    }

    public void setProbability(int n, int n2, Value Value2, Object object) {
        List<Integer> list = this.succ.get(n);
        List<Value> list2 = this.trans.get(n);
        int n3 = this.succ.get(n).size();
        for (int i = 0; i < n3; ++i) {
            if (list.get(i) != n2 || !this.actions.actionMatches(n, i, object)) continue;
            if (this.getEvaluator().isZero(Value2)) {
                list.remove(i);
                list2.remove(i);
            } else {
                list2.set(i, Value2);
            }
            return;
        }
        list.add(n2);
        list2.add(Value2);
        this.actions.setAction(n, n3, object);
        this.actionList.markNeedsRecomputing();
    }

    public void addToProbability(int n, int n2, Value Value2) {
        this.addToProbability(n, n2, Value2, null);
    }

    public void addToProbability(int n, int n2, Value Value2, Object object) {
        if (this.getEvaluator().isZero(Value2)) {
            return;
        }
        List<Integer> list = this.succ.get(n);
        List<Value> list2 = this.trans.get(n);
        int n3 = this.succ.get(n).size();
        for (int i = 0; i < n3; ++i) {
            if (list.get(i) != n2 || !this.actions.actionMatches(n, i, object)) continue;
            list2.set(i, this.getEvaluator().add(list2.get(i), Value2));
            return;
        }
        list.add(n2);
        list2.add(Value2);
        this.actions.setAction(n, n3, object);
        this.actionList.markNeedsRecomputing();
    }

    @Override
    public List<Object> findActionsUsed() {
        return this.actions.findActionsUsed(this.getNumStates(), this::getNumTransitions);
    }

    @Override
    public boolean onlyNullActionUsed() {
        return this.actions.onlyNullActionUsed();
    }

    @Override
    public int getNumTransitions(int n) {
        return this.succ.get(n).size();
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        return new HashSet(this.succ.get(n)).iterator();
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        return SuccessorsIterator.from(this.getSuccessorsIterator(n), true);
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        return this.succ.get(n).contains(n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return Reducible.extend(this.succ.get(n)).allMatch(bitSet::get);
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return Reducible.extend(this.succ.get(n)).anyMatch(bitSet::get);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.succ.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            this.setProbability(i, i, this.getEvaluator().one(), null);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.succ.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("DTMC has a deadlock in state " + i);
        }
    }

    @Override
    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(final int n) {
        return new Iterator<Map.Entry<Integer, Value>>(){
            private final int n;
            private int i;
            {
                this.n = DTMCSimple.this.succ.get(n).size();
                this.i = 0;
            }

            @Override
            public Map.Entry<Integer, Value> next() {
                return new AbstractMap.SimpleImmutableEntry(DTMCSimple.this.succ.get(n).get(this.i), DTMCSimple.this.trans.get(n).get(this.i++));
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }
        };
    }

    @Override
    public Iterator<Map.Entry<Integer, Pair<Value, Object>>> getTransitionsAndActionsIterator(final int n) {
        return new Iterator<Map.Entry<Integer, Pair<Value, Object>>>(){
            private final int n;
            private int i;
            {
                this.n = DTMCSimple.this.succ.get(n).size();
                this.i = 0;
            }

            @Override
            public Map.Entry<Integer, Pair<Value, Object>> next() {
                Pair pair = new Pair(DTMCSimple.this.trans.get(n).get(this.i), DTMCSimple.this.actions.getAction(n, this.i));
                return new AbstractMap.SimpleImmutableEntry(DTMCSimple.this.succ.get(n).get(this.i++), pair);
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }
        };
    }

    @Override
    public Iterator<Object> getActionsIterator(final int n) {
        return new Iterator<Object>(){
            private final int n;
            private int i;
            {
                this.n = DTMCSimple.this.succ.get(n).size();
                this.i = 0;
            }

            @Override
            public Object next() {
                return DTMCSimple.this.actions.getAction(n, this.i++);
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }
        };
    }

    public Distribution<Value> getTransitions(int n) {
        return new Distribution<Value>(this.getTransitionsIterator(n), this.getEvaluator());
    }

    public String toString() {
        Object object = "";
        object = "[ ";
        boolean bl = true;
        for (int i = 0; i < this.numStates; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": " + this.toStringDistr(i);
        }
        object = (String)object + " ]";
        return object;
    }

    protected String toStringDistr(int n) {
        Object object = "";
        boolean bl = true;
        object = "{";
        int n2 = this.succ.get(n).size();
        for (int i = 0; i < n2; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + String.valueOf(this.succ.get(n).get(i)) + "=" + String.valueOf(this.trans.get(n).get(i));
            Object object2 = this.actions.getAction(n, i);
            if (object2 == null) continue;
            object = (String)object + ":" + String.valueOf(object2);
        }
        object = (String)object + "}";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCSimple)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DTMCSimple dTMCSimple = (DTMCSimple)object;
        if (!this.succ.equals(dTMCSimple.succ)) {
            return false;
        }
        if (!this.trans.equals(dTMCSimple.trans)) {
            return false;
        }
        return this.actions.equals(dTMCSimple.actions);
    }
}

