/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import explicit.CTMCSimple;
import explicit.CTMDPSimple;
import explicit.DTMCSimple;
import explicit.DTMCSparse;
import explicit.Distribution;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.IndexedSet;
import explicit.IntervalModelExplicit;
import explicit.LTSSimple;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.MDPSparse;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.NondetModel;
import explicit.POMDPSimple;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ModulesFile;
import prism.ModelGenerator;
import prism.ModelType;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismPrintStreamLog;
import prism.ProgressDisplay;
import prism.UndefinedConstants;
import simulator.ModulesFileModelGenerator;

public class ConstructModel
extends PrismComponent {
    protected boolean findDeadlocks = true;
    protected boolean fixDeadlocks = true;
    protected boolean sortStates = true;
    protected boolean buildSparse = true;
    protected boolean distinguishActions = true;
    protected boolean attachLabels = true;
    protected List<State> statesList;

    public ConstructModel(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public List<State> getStatesList() {
        return this.statesList;
    }

    public void setFixDeadlocks(boolean bl) {
        this.fixDeadlocks = bl;
    }

    public void setSortStates(boolean bl) {
        this.sortStates = bl;
    }

    public void setBuildSparse(boolean bl) {
        this.buildSparse = bl;
    }

    public void setDistinguishActions(boolean bl) {
        this.distinguishActions = bl;
    }

    public void setAttachLabels(boolean bl) {
        this.attachLabels = bl;
    }

    public List<State> computeReachableStates(ModelGenerator<?> modelGenerator) throws PrismException {
        this.constructModel(modelGenerator, true);
        return this.getStatesList();
    }

    public <Value> Model<Value> constructModel(ModelGenerator<Value> modelGenerator) throws PrismException {
        return this.constructModel(modelGenerator, false);
    }

    /*
     * WARNING - void declaration
     */
    public <Value> Model<Value> constructModel(ModelGenerator<Value> modelGenerator, boolean bl) throws PrismException {
        void var30_37;
        Object object;
        ModelExplicit modelExplicit = null;
        DTMCSimple<Double> dTMCSimple = null;
        CTMCSimple<Value> cTMCSimple = null;
        MDPSimple<Double> mDPSimple = null;
        POMDPSimple<Value> pOMDPSimple = null;
        CTMDPSimple<Value> cTMDPSimple = null;
        IDTMCSimple<Value> iDTMCSimple = null;
        IMDPSimple<Value> iMDPSimple = null;
        LTSSimple lTSSimple = null;
        Distribution<Value> distribution = null;
        Distribution<Interval<Interval<Value>>> distribution2 = null;
        ModelType modelType = modelGenerator.getModelType();
        VarList varList = modelGenerator.createVarList();
        if (modelGenerator.containsUnboundedVariables()) {
            this.mainLog.printWarning("Model contains one or more unbounded variables: model construction may not terminate");
        }
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        if (!bl) {
            switch (modelType) {
                case DTMC: {
                    dTMCSimple = new DTMCSimple<Double>();
                    modelExplicit = dTMCSimple;
                    break;
                }
                case CTMC: {
                    cTMCSimple = new CTMCSimple<Value>();
                    modelExplicit = cTMCSimple;
                    break;
                }
                case MDP: {
                    mDPSimple = new MDPSimple<Double>();
                    modelExplicit = mDPSimple;
                    break;
                }
                case POMDP: {
                    pOMDPSimple = new POMDPSimple<Value>();
                    modelExplicit = pOMDPSimple;
                    break;
                }
                case CTMDP: {
                    cTMDPSimple = new CTMDPSimple<Value>();
                    modelExplicit = cTMDPSimple;
                    break;
                }
                case IDTMC: {
                    iDTMCSimple = new IDTMCSimple<Value>();
                    modelExplicit = iDTMCSimple;
                    break;
                }
                case IMDP: {
                    iMDPSimple = new IMDPSimple<Value>();
                    modelExplicit = iMDPSimple;
                    break;
                }
                case LTS: {
                    lTSSimple = new LTSSimple();
                    modelExplicit = lTSSimple;
                    break;
                }
                case STPG: 
                case SMG: 
                case PTA: 
                case POPTA: {
                    throw new PrismNotSupportedException("Model construction not supported for " + String.valueOf((Object)modelType) + "s");
                }
            }
            ((ModelExplicit)modelExplicit).setEvaluator(modelGenerator.getEvaluator());
            if (modelExplicit instanceof IntervalModelExplicit) {
                ((IntervalModelExplicit)((Object)modelExplicit)).setIntervalEvaluator(modelGenerator.getIntervalEvaluator());
            }
            ((ModelExplicit)modelExplicit).setVarList(varList);
        }
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State object22 : modelGenerator.getInitialStates()) {
            linkedList.add(object22);
            indexedSet.add(object22);
            if (bl) continue;
            modelExplicit.addState();
            modelExplicit.addInitialState(modelExplicit.getNumStates() - 1);
        }
        int n = -1;
        while (!linkedList.isEmpty()) {
            State state = (State)linkedList.removeFirst();
            ++n;
            modelGenerator.exploreState(state);
            int n2 = modelGenerator.getNumChoices();
            for (int i = 0; i < n2; ++i) {
                if (modelType.partiallyObservable() && ((NondetModel)((Object)modelExplicit)).getChoiceByAction(n, modelGenerator.getChoiceAction(i)) != -1) {
                    object = modelGenerator.getChoiceAction(i) == null ? "" : modelGenerator.getChoiceAction(i).toString();
                    String string2 = String.valueOf((Object)modelType) + " is not allowed duplicate action";
                    string2 = string2 + " (\"" + (String)object + "\") in state " + state.toString(modelGenerator);
                    throw new PrismException(string2);
                }
                if (!bl && modelType.nondeterministic()) {
                    if (!modelType.uncertain()) {
                        distribution = new Distribution<Value>(modelGenerator.getEvaluator());
                    } else {
                        distribution2 = new Distribution<Interval<Interval<Value>>>(modelGenerator.getIntervalEvaluator());
                    }
                }
                int n3 = modelGenerator.getNumTransitions(i);
                block33: for (int j = 0; j < n3; ++j) {
                    State state2 = modelGenerator.computeTransitionTarget(i, j);
                    if (indexedSet.add(state2)) {
                        linkedList.add(state2);
                        if (!bl) {
                            modelExplicit.addState();
                        }
                    }
                    int n4 = indexedSet.getIndexOfLastAdd();
                    object = null;
                    if (this.distinguishActions && !modelType.nondeterministic()) {
                        object = modelGenerator.getTransitionAction(i, j);
                    }
                    if (bl) continue;
                    switch (modelType) {
                        case DTMC: {
                            dTMCSimple.addToProbability(n, n4, (Double)modelGenerator.getTransitionProbability(i, j), object);
                            continue block33;
                        }
                        case CTMC: {
                            cTMCSimple.addToProbability(n, n4, modelGenerator.getTransitionProbability(i, j), object);
                            continue block33;
                        }
                        case IDTMC: {
                            iDTMCSimple.addToProbability(n, n4, modelGenerator.getTransitionProbabilityInterval(i, j), object);
                            continue block33;
                        }
                        case MDP: 
                        case POMDP: 
                        case CTMDP: {
                            distribution.add(n4, modelGenerator.getTransitionProbability(i, j));
                            continue block33;
                        }
                        case IMDP: {
                            distribution2.add(n4, modelGenerator.getTransitionProbabilityInterval(i, j));
                            continue block33;
                        }
                        case LTS: {
                            if (this.distinguishActions) {
                                lTSSimple.addActionLabelledTransition(n, n4, modelGenerator.getChoiceAction(i));
                                continue block33;
                            }
                            lTSSimple.addTransition(n, n4);
                            continue block33;
                        }
                        case STPG: 
                        case SMG: 
                        case PTA: 
                        case POPTA: {
                            throw new PrismNotSupportedException("Model construction not supported for " + String.valueOf((Object)modelType) + "s");
                        }
                    }
                }
                int n5 = -1;
                if (!bl) {
                    if (modelType == ModelType.MDP) {
                        if (this.distinguishActions) {
                            mDPSimple.addActionLabelledChoice(n, distribution, modelGenerator.getChoiceAction(i));
                        } else {
                            mDPSimple.addChoice(n, distribution);
                        }
                    } else if (modelType == ModelType.POMDP) {
                        if (this.distinguishActions) {
                            pOMDPSimple.addActionLabelledChoice(n, distribution, modelGenerator.getChoiceAction(i));
                        } else {
                            pOMDPSimple.addChoice(n, distribution);
                        }
                    } else if (modelType == ModelType.CTMDP) {
                        if (this.distinguishActions) {
                            cTMDPSimple.addActionLabelledChoice(n, distribution, modelGenerator.getChoiceAction(i));
                        } else {
                            cTMDPSimple.addChoice(n, distribution);
                        }
                    } else if (modelType == ModelType.IMDP) {
                        n5 = this.distinguishActions ? iMDPSimple.addActionLabelledChoice(n, distribution2, modelGenerator.getChoiceAction(i)) : iMDPSimple.addChoice(n, distribution2);
                    }
                }
                if (modelType == ModelType.IDTMC) {
                    iDTMCSimple.delimit(n);
                    continue;
                }
                if (modelType != ModelType.IMDP) continue;
                iMDPSimple.delimit(n, n5);
            }
            if (!bl && modelType == ModelType.POMDP) {
                this.setStateObservation(modelGenerator, (POMDPSimple)modelExplicit, n, state);
            }
            progressDisplay.updateIfReady(n + 1);
        }
        progressDisplay.update(n + 1);
        progressDisplay.end(" states");
        this.mainLog.print("Reachable states exploration" + (bl ? "" : " and model construction"));
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        if (!bl && this.findDeadlocks) {
            modelExplicit.findDeadlocks(this.fixDeadlocks);
        }
        object = null;
        if (this.sortStates) {
            this.mainLog.println("Sorting reachable states list...");
            object = indexedSet.buildSortingPermutation();
            this.statesList = indexedSet.toPermutedArrayList((int[])object);
        } else {
            this.statesList = indexedSet.toArrayList();
        }
        indexedSet.clear();
        indexedSet = null;
        Object var30_25 = null;
        if (!bl) {
            void var30_36;
            boolean bl2 = modelExplicit.getEvaluator().one() instanceof Double;
            switch (modelType) {
                case DTMC: {
                    if (this.buildSparse && bl2) {
                        DTMCSparse dTMCSparse = this.sortStates ? new DTMCSparse(dTMCSimple, (int[])object) : new DTMCSparse(dTMCSimple);
                        break;
                    }
                    DTMCSimple<Double> dTMCSimple2 = this.sortStates ? new DTMCSimple<Double>(dTMCSimple, (int[])object) : dTMCSimple;
                    break;
                }
                case CTMC: {
                    CTMCSimple<Value> cTMCSimple2 = this.sortStates ? new CTMCSimple<Value>(cTMCSimple, (int[])object) : cTMCSimple;
                    break;
                }
                case MDP: {
                    if (this.buildSparse && bl2) {
                        MDPSparse mDPSparse = this.sortStates ? new MDPSparse(mDPSimple, true, (int[])object) : new MDPSparse((MDP<Double>)mDPSimple);
                        break;
                    }
                    MDPSimple<Double> mDPSimple2 = this.sortStates ? new MDPSimple<Double>(mDPSimple, (int[])object) : mDPSimple;
                    break;
                }
                case POMDP: {
                    POMDPSimple<Value> pOMDPSimple2 = this.sortStates ? new POMDPSimple<Value>(pOMDPSimple, (int[])object) : pOMDPSimple;
                    break;
                }
                case CTMDP: {
                    CTMDPSimple<Value> cTMDPSimple2 = this.sortStates ? new CTMDPSimple<Value>(cTMDPSimple, (int[])object) : cTMDPSimple;
                    break;
                }
                case IDTMC: {
                    IDTMCSimple<Value> iDTMCSimple2 = this.sortStates ? new IDTMCSimple<Value>(iDTMCSimple, (int[])object) : iDTMCSimple;
                    break;
                }
                case IMDP: {
                    IMDPSimple<Value> iMDPSimple2 = this.sortStates ? new IMDPSimple<Value>(iMDPSimple, (int[])object) : iMDPSimple;
                    break;
                }
                case LTS: {
                    LTSSimple lTSSimple2 = this.sortStates ? new LTSSimple(lTSSimple, (int[])object) : lTSSimple;
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Model construction not supported for " + String.valueOf((Object)modelType) + "s");
                }
            }
            var30_36.setStatesList(this.statesList);
            var30_36.setConstantValues(new Values(modelGenerator.getConstantValues()));
        }
        object = null;
        if (!bl && this.attachLabels) {
            this.attachLabels(modelGenerator, (ModelExplicit<Value>)var30_37);
        }
        return var30_37;
    }

    private <Value> void setStateObservation(ModelGenerator<Value> modelGenerator, POMDPSimple<Value> pOMDPSimple, int n, State state) throws PrismException {
        State state2 = modelGenerator.getObservation(state);
        int n2 = modelGenerator.getNumVars();
        int n3 = n2 - modelGenerator.getNumObservableVars();
        State state3 = new State(n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (modelGenerator.isVarObservable(i)) continue;
            state3.setValue(n4++, state.varValues[i]);
        }
        pOMDPSimple.setObservation(n, state2, state3, modelGenerator.getObservableNames());
    }

    private <Value> void attachLabels(ModelGenerator<Value> modelGenerator, ModelExplicit<Value> modelExplicit) throws PrismException {
        int n;
        List<State> list = modelExplicit.getStatesList();
        int n2 = list.size();
        int n3 = modelGenerator.getNumLabels();
        if (n3 == 0) {
            return;
        }
        BitSet[] bitSetArray = new BitSet[n3];
        for (n = 0; n < n3; ++n) {
            bitSetArray[n] = new BitSet();
        }
        for (n = 0; n < n2; ++n) {
            State state = list.get(n);
            modelGenerator.exploreState(state);
            for (int i = 0; i < n3; ++i) {
                if (!modelGenerator.isLabelTrue(i)) continue;
                bitSetArray[i].set(n);
            }
        }
        for (n = 0; n < n3; ++n) {
            modelExplicit.addLabel(modelGenerator.getLabelName(n), bitSetArray[n]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.out);
            Prism prism = new Prism(prismPrintStreamLog);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            UndefinedConstants undefinedConstants = new UndefinedConstants(modulesFile, null);
            if (stringArray.length > 2) {
                undefinedConstants.defineUsingConstSwitch(stringArray[2]);
            }
            modulesFile.setSomeUndefinedConstants(undefinedConstants.getMFConstantValues());
            ConstructModel constructModel = new ConstructModel(prism);
            constructModel.setSortStates(true);
            ModulesFileModelGenerator<?> modulesFileModelGenerator = ModulesFileModelGenerator.create(modulesFile, constructModel);
            Model<?> model = constructModel.constructModel(modulesFileModelGenerator);
            model.exportToPrismExplicitTra(stringArray[1]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

