/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.IDTMCSimple;
import explicit.IMDP;
import explicit.IMDPSimple;
import explicit.IntervalModel;
import explicit.IntervalModelExplicit;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.ModelSimple;
import explicit.NondetModel;
import explicit.POMDP;
import explicit.POMDPSimple;
import explicit.STPG;
import explicit.STPGSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;
import strat.Strategy;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class ConstructInducedModel {
    private StrategyExportOptions.InducedModelMode mode = StrategyExportOptions.InducedModelMode.RESTRICT;
    private boolean reachOnly = true;

    public ConstructInducedModel setMode(StrategyExportOptions.InducedModelMode inducedModelMode) {
        this.mode = inducedModelMode;
        return this;
    }

    public ConstructInducedModel setReachOnly(boolean bl) {
        this.reachOnly = bl;
        return this;
    }

    public <Value> Model<Value> constructInducedModel(NondetModel<Value> nondetModel, Strategy<Value> strategy) throws PrismException {
        if (strategy.hasMemory()) {
            throw new PrismException("Induced model construction is for memoryless strategies");
        }
        ModelType modelType = nondetModel.getModelType();
        ModelType modelType2 = strategy.getInducedModelType(this.mode);
        if (modelType2 == null) {
            throw new PrismNotSupportedException("Induced model construction not supported for " + String.valueOf((Object)modelType) + "s");
        }
        ModelSimple<?> modelSimple = ModelSimple.forModelType(modelType2);
        ((ModelExplicit)((Object)modelSimple)).setEvaluator(nondetModel.getEvaluator());
        if (modelSimple instanceof IntervalModelExplicit) {
            ((IntervalModelExplicit)((Object)modelSimple)).setIntervalEvaluator(((IntervalModel)((Object)nondetModel)).getIntervalEvaluator());
        }
        ((ModelExplicit)((Object)modelSimple)).setVarList(nondetModel.getVarList());
        return this.doConstructInducedModel(modelType, modelType2, modelSimple, nondetModel, strategy);
    }

    public <Value> Model<Value> doConstructInducedModel(ModelType modelType, ModelType modelType2, ModelSimple<Value> modelSimple, NondetModel<Value> nondetModel, Strategy<Value> strategy) throws PrismException {
        int n;
        int n2;
        Object object;
        Distribution<Interval<BitSet>> distribution;
        Object object2;
        int n32;
        BitSet bitSet;
        List<State> list = nondetModel.getStatesList();
        if (this.reachOnly && list != null) {
            list = new ArrayList<State>();
        }
        int n4 = nondetModel.getNumStates();
        int[] nArray = new int[n4];
        if (this.reachOnly) {
            Arrays.fill(nArray, -1);
            bitSet = new BitSet();
            for (int n32 : nondetModel.getInitialStates()) {
                nArray[n32] = 0;
                bitSet.set(n32);
            }
            while (!bitSet.isEmpty()) {
                int n5 = bitSet.nextSetBit(0);
                while (n5 >= 0) {
                    bitSet.set(n5, false);
                    n32 = nondetModel.getNumChoices(n5);
                    object2 = strategy.getChoiceAction(n5, -1);
                    if (object2 == StrategyInfo.UNDEFINED && n32 > 0) {
                        object2 = nondetModel.getAction(n5, 0);
                    }
                    for (int i = 0; i < n32; ++i) {
                        distribution = nondetModel.getAction(n5, i);
                        if (!strategy.isActionChosen(object2, distribution)) continue;
                        object = nondetModel.getSuccessorsIterator(n5, i);
                        while (object.hasNext()) {
                            n2 = object.next();
                            if (nArray[n2] != -1) continue;
                            nArray[n2] = 0;
                            bitSet.set(n2);
                        }
                    }
                    n5 = bitSet.nextSetBit(n5 + 1);
                }
            }
            n = 0;
            for (n32 = 0; n32 < n4; ++n32) {
                if (nArray[n32] == -1) continue;
                nArray[n32] = n++;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                nArray[i] = i;
            }
        }
        bitSet = nondetModel.getEvaluator().one();
        block30: for (n = 0; n < n4; ++n) {
            if (nArray[n] == -1) continue;
            switch (modelType2) {
                case STPG: {
                    ((STPGSimple)modelSimple).addState(((STPG)nondetModel).getPlayer(n));
                    break;
                }
                default: {
                    modelSimple.addState();
                }
            }
            if (nondetModel.isInitialState(n)) {
                modelSimple.addInitialState(nArray[n]);
            }
            if (this.reachOnly && list != null) {
                list.add(nondetModel.getStatesList().get(n));
            }
            n32 = nondetModel.getNumChoices(n);
            object2 = strategy.getChoiceAction(n, -1);
            if (object2 == StrategyInfo.UNDEFINED && n32 > 0) {
                object2 = nondetModel.getAction(n, 0);
            }
            Object object3 = null;
            distribution = null;
            object = null;
            if (modelType2.nondeterministic()) {
                if (modelType != ModelType.IMDP) {
                    distribution = new Distribution<Interval<BitSet>>(nondetModel.getEvaluator());
                } else {
                    object = new Distribution(((IMDP)nondetModel).getIntervalEvaluator());
                }
            }
            for (n2 = 0; n2 < n32; ++n2) {
                Interval<BitSet> interval;
                int n6;
                Map.Entry<Integer, Object> entry;
                Object object4 = nondetModel.getAction(n, n2);
                if (!strategy.isActionChosen(object2, object4)) continue;
                if (strategy.isRandomised()) {
                    bitSet = strategy.getChoiceActionProbability(object2, object4);
                }
                if (modelType2.nondeterministic()) {
                    object3 = strategy.getInducedAction(object2, object4);
                }
                Iterator iterator = null;
                Iterator iterator2 = null;
                switch (modelType) {
                    case MDP: {
                        iterator = ((MDP)nondetModel).getTransitionsIterator(n, n2);
                        break;
                    }
                    case POMDP: {
                        iterator = ((POMDP)nondetModel).getTransitionsIterator(n, n2);
                        break;
                    }
                    case IMDP: {
                        iterator2 = ((IMDP)nondetModel).getIntervalTransitionsIterator(n, n2);
                        break;
                    }
                    case STPG: {
                        iterator = ((STPG)nondetModel).getTransitionsIterator(n, n2);
                        break;
                    }
                    default: {
                        throw new PrismNotSupportedException("Induced model construction not implemented for " + String.valueOf((Object)modelType) + "s");
                    }
                }
                if (modelType != ModelType.IMDP) {
                    block32: while (iterator.hasNext()) {
                        entry = iterator.next();
                        n6 = entry.getKey();
                        interval = entry.getValue();
                        if (strategy.isRandomised()) {
                            interval = nondetModel.getEvaluator().multiply((BitSet)((Object)interval), bitSet);
                        }
                        switch (modelType2) {
                            case DTMC: {
                                ((DTMCSimple)modelSimple).addToProbability(nArray[n], nArray[n6], interval, object4);
                                continue block32;
                            }
                            case STPG: 
                            case MDP: 
                            case POMDP: {
                                distribution.add(nArray[n6], interval);
                                continue block32;
                            }
                        }
                        throw new PrismNotSupportedException("Induced model construction not implemented for " + String.valueOf((Object)modelType) + "s");
                    }
                    continue;
                }
                block33: while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    n6 = entry.getKey();
                    interval = (Interval)entry.getValue();
                    if (strategy.isRandomised()) {
                        interval = ((IMDP)nondetModel).getIntervalEvaluator().multiply(interval, new Interval<BitSet>(bitSet, bitSet));
                    }
                    switch (modelType2) {
                        case IDTMC: {
                            ((IDTMCSimple)modelSimple).addToProbability(nArray[n], nArray[n6], interval, object4);
                            continue block33;
                        }
                        case IMDP: {
                            ((Distribution)object).add(nArray[n6], interval);
                            continue block33;
                        }
                    }
                    throw new PrismNotSupportedException("Induced model construction not implemented for " + String.valueOf((Object)modelType) + "s");
                }
            }
            if (!modelType2.nondeterministic()) continue;
            switch (modelType2) {
                case MDP: {
                    ((MDPSimple)modelSimple).addActionLabelledChoice(nArray[n], distribution, object3);
                    continue block30;
                }
                case POMDP: {
                    ((POMDPSimple)modelSimple).addActionLabelledChoice(nArray[n], distribution, object3);
                    continue block30;
                }
                case IMDP: {
                    ((IMDPSimple)modelSimple).addActionLabelledChoice(nArray[n], object, object3);
                    continue block30;
                }
                case STPG: {
                    ((STPGSimple)modelSimple).addActionLabelledChoice(nArray[n], distribution, object3);
                    continue block30;
                }
            }
        }
        modelSimple.findDeadlocks(false);
        if (list != null) {
            modelSimple.setStatesList(list);
        }
        return modelSimple;
    }
}

