/*
 * Decompiled with CFR 0.152.
 */
package csv;

import csv.BasicReader;
import java.io.IOException;

public abstract class ReplacingReader<T extends BasicReader>
implements BasicReader {
    public static final int REPLACE = -2;
    public final T source;

    public ReplacingReader(T t) {
        this.source = t;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public abstract int read() throws IOException;

    public ToChar to(int n) {
        return new ToChar(this, n);
    }

    public ToPair to(int n, int n2) {
        return new ToPair(this, n, n2);
    }

    public static class ToChar
    extends ReplacingReader<ReplacingReader<?>> {
        protected final int repl_1;

        public ToChar(ReplacingReader<?> replacingReader, int n) {
            super(replacingReader);
            this.repl_1 = n;
        }

        @Override
        public int read() throws IOException {
            int n = ((ReplacingReader)this.source).read();
            return n == -2 ? this.repl_1 : n;
        }
    }

    public static class ToPair
    extends ReplacingReader<ReplacingReader<?>> {
        protected final int repl_1;
        protected final int repl_2;
        protected boolean replacing = false;

        public ToPair(ReplacingReader<?> replacingReader, int n, int n2) {
            super(replacingReader);
            this.repl_1 = n;
            this.repl_2 = n2;
        }

        @Override
        public int read() throws IOException {
            if (this.replacing) {
                this.replacing = false;
                return this.repl_2;
            }
            int n = ((ReplacingReader)this.source).read();
            if (n == -2) {
                this.replacing = true;
                return this.repl_1;
            }
            return n;
        }
    }

    public static class FromPair
    extends ReplacingReader<BasicReader.PeekableReader> {
        protected final int char_1;
        protected final int char_2;

        public FromPair(BasicReader basicReader, int n, int n2) throws IOException {
            this(new BasicReader.PeekableReader(basicReader), n, n2);
        }

        public FromPair(BasicReader.PeekableReader peekableReader, int n, int n2) {
            super(peekableReader);
            this.char_1 = n;
            this.char_2 = n2;
        }

        @Override
        public int read() throws IOException {
            int n = ((BasicReader.PeekableReader)this.source).read();
            if (n == this.char_1 && ((BasicReader.PeekableReader)this.source).peek() == this.char_2) {
                ((BasicReader.PeekableReader)this.source).read();
                return -2;
            }
            return n;
        }
    }

    public static class FromChar
    extends ReplacingReader<BasicReader> {
        protected final int char_1;

        public FromChar(BasicReader basicReader, int n) {
            super(basicReader);
            this.char_1 = n;
        }

        @Override
        public int read() throws IOException {
            int n = this.source.read();
            return n == this.char_1 ? -2 : n;
        }
    }
}

