/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.EmptyIterator;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public abstract class IteratorAdaptor<E, I extends Iterator<E>>
implements FunctionalIterator<E> {
    protected I iterator;

    public IteratorAdaptor(I i) {
        Objects.requireNonNull(i);
        this.iterator = i;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        this.release();
        return false;
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> consumer) {
        this.iterator.forEachRemaining(consumer);
        this.release();
    }

    public I unwrap() {
        return this.iterator;
    }

    public static class OfLong
    extends IteratorAdaptor<Long, PrimitiveIterator.OfLong>
    implements FunctionalPrimitiveIterator.OfLong {
        public OfLong(PrimitiveIterator.OfLong ofLong) {
            super(ofLong);
        }

        @Override
        public long nextLong() {
            return ((PrimitiveIterator.OfLong)this.iterator).nextLong();
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            ((PrimitiveIterator.OfLong)this.iterator).forEachRemaining(longConsumer);
            this.release();
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofLong();
        }
    }

    public static class OfInt
    extends IteratorAdaptor<Integer, PrimitiveIterator.OfInt>
    implements FunctionalPrimitiveIterator.OfInt {
        public OfInt(PrimitiveIterator.OfInt ofInt) {
            super(ofInt);
        }

        @Override
        public int nextInt() {
            return ((PrimitiveIterator.OfInt)this.iterator).nextInt();
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            ((PrimitiveIterator.OfInt)this.iterator).forEachRemaining(intConsumer);
            this.release();
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofInt();
        }
    }

    public static class OfDouble
    extends IteratorAdaptor<Double, PrimitiveIterator.OfDouble>
    implements FunctionalPrimitiveIterator.OfDouble {
        public OfDouble(PrimitiveIterator.OfDouble ofDouble) {
            super(ofDouble);
        }

        @Override
        public double nextDouble() {
            return ((PrimitiveIterator.OfDouble)this.iterator).nextDouble();
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            ((PrimitiveIterator.OfDouble)this.iterator).forEachRemaining(doubleConsumer);
            this.release();
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofDouble();
        }
    }

    public static class Of<E>
    extends IteratorAdaptor<E, Iterator<E>> {
        public Of(Iterator<E> iterator) {
            super(iterator);
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.of();
        }
    }
}

