/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.functions.DoubleObjToDoubleFunction;
import common.functions.IntObjToIntFunction;
import common.functions.LongObjToLongFunction;
import common.iterable.ArrayIterator;
import common.iterable.ChainedIterator;
import common.iterable.EmptyIterator;
import common.iterable.FilteringIterator;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.MappingIterator;
import common.iterable.Reducible;
import common.iterable.SingletonIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public interface FunctionalIterator<E>
extends Reducible<E, Iterator<? extends E>>,
Iterator<E> {
    @SafeVarargs
    public static <E> FunctionalIterator<E> of(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return EmptyIterator.of();
            }
            case 1: {
                return new SingletonIterator.Of<E>(EArray[0]);
            }
        }
        return new ArrayIterator.Of<E>(EArray);
    }

    public static FunctionalPrimitiveIterator.OfDouble ofDouble(double ... dArray) {
        switch (dArray.length) {
            case 0: {
                return EmptyIterator.ofDouble();
            }
            case 1: {
                return new SingletonIterator.OfDouble(dArray[0]);
            }
        }
        return new ArrayIterator.OfDouble(dArray);
    }

    public static FunctionalPrimitiveIterator.OfInt ofInt(int ... nArray) {
        switch (nArray.length) {
            case 0: {
                return EmptyIterator.ofInt();
            }
            case 1: {
                return new SingletonIterator.OfInt(nArray[0]);
            }
        }
        return new ArrayIterator.OfInt(nArray);
    }

    public static FunctionalPrimitiveIterator.OfLong ofLong(long ... lArray) {
        switch (lArray.length) {
            case 0: {
                return EmptyIterator.ofLong();
            }
            case 1: {
                return new SingletonIterator.OfLong(lArray[0]);
            }
        }
        return new ArrayIterator.OfLong(lArray);
    }

    @Override
    default public void forEach(Consumer<? super E> consumer) {
        this.unwrap().forEachRemaining(consumer);
        this.release();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    default public Iterator<E> unwrap() {
        return this;
    }

    default public void release() {
    }

    default public void requireNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    default public FunctionalIterator<E> concat(Iterator<? extends E> iterator) {
        return new ChainedIterator.Of<E>(this.unwrap(), new ArrayIterator.Of<Iterator>(iterator));
    }

    default public FunctionalIterator<E> dedupe() {
        return (FunctionalIterator)Reducible.super.dedupe();
    }

    default public FunctionalIterator<E> distinct() {
        return (FunctionalIterator)Reducible.super.distinct();
    }

    default public FunctionalIterator<E> filter(Predicate<? super E> predicate) {
        return new FilteringIterator.Of<E>(this.unwrap(), predicate);
    }

    default public <T> FunctionalIterator<T> flatMap(Function<? super E, ? extends Iterator<? extends T>> function) {
        return new ChainedIterator.Of(this.map(function));
    }

    default public FunctionalPrimitiveIterator.OfDouble flatMapToDouble(Function<? super E, PrimitiveIterator.OfDouble> function) {
        return new ChainedIterator.OfDouble((Iterator<? extends PrimitiveIterator.OfDouble>)((Object)this.map(function)));
    }

    default public FunctionalPrimitiveIterator.OfInt flatMapToInt(Function<? super E, PrimitiveIterator.OfInt> function) {
        return new ChainedIterator.OfInt((Iterator<? extends PrimitiveIterator.OfInt>)((Object)this.map(function)));
    }

    default public FunctionalPrimitiveIterator.OfLong flatMapToLong(Function<? super E, PrimitiveIterator.OfLong> function) {
        return new ChainedIterator.OfLong((Iterator<? extends PrimitiveIterator.OfLong>)((Object)this.map(function)));
    }

    default public <T> FunctionalIterator<T> map(Function<? super E, ? extends T> function) {
        return new MappingIterator.ObjToObj<E, T>(this.unwrap(), function);
    }

    default public FunctionalPrimitiveIterator.OfDouble mapToDouble(ToDoubleFunction<? super E> toDoubleFunction) {
        return new MappingIterator.ObjToDouble<E>(this.unwrap(), toDoubleFunction);
    }

    default public FunctionalPrimitiveIterator.OfInt mapToInt(ToIntFunction<? super E> toIntFunction) {
        return new MappingIterator.ObjToInt<E>(this.unwrap(), toIntFunction);
    }

    default public FunctionalPrimitiveIterator.OfLong mapToLong(ToLongFunction<? super E> toLongFunction) {
        return new MappingIterator.ObjToLong<E>(this.unwrap(), toLongFunction);
    }

    default public FunctionalIterator<E> nonNull() {
        return (FunctionalIterator)Reducible.super.nonNull();
    }

    default public FunctionalIterator<E> consume() {
        return (FunctionalIterator)Reducible.super.consume();
    }

    @Override
    default public E detect(Predicate<? super E> predicate) {
        return this.filter((Predicate)predicate).next();
    }

    @Override
    default public Optional<E> reduce(BinaryOperator<E> binaryOperator) {
        Objects.requireNonNull(binaryOperator);
        if (!this.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(this.reduce(this.next(), binaryOperator));
    }

    @Override
    default public <T> T reduce(T t, BiFunction<T, ? super E, T> biFunction) {
        Objects.requireNonNull(biFunction);
        Iterator<E> iterator = this.unwrap();
        T t2 = t;
        while (iterator.hasNext()) {
            t2 = biFunction.apply(t2, iterator.next());
        }
        this.release();
        return t2;
    }

    @Override
    default public double reduce(double d, DoubleObjToDoubleFunction<? super E> doubleObjToDoubleFunction) {
        Objects.requireNonNull(doubleObjToDoubleFunction);
        Iterator<E> iterator = this.unwrap();
        double d2 = d;
        while (iterator.hasNext()) {
            d2 = doubleObjToDoubleFunction.applyAsDouble(d2, iterator.next());
        }
        this.release();
        return d2;
    }

    @Override
    default public int reduce(int n, IntObjToIntFunction<? super E> intObjToIntFunction) {
        Objects.requireNonNull(intObjToIntFunction);
        Iterator<E> iterator = this.unwrap();
        int n2 = n;
        while (iterator.hasNext()) {
            n2 = intObjToIntFunction.applyAsInt(n2, iterator.next());
        }
        this.release();
        return n2;
    }

    @Override
    default public long reduce(long l, LongObjToLongFunction<? super E> longObjToLongFunction) {
        Objects.requireNonNull(longObjToLongFunction);
        Iterator<E> iterator = this.unwrap();
        long l2 = l;
        while (iterator.hasNext()) {
            l2 = longObjToLongFunction.applyAsLong(l2, iterator.next());
        }
        this.release();
        return l2;
    }
}

