/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FilteringIterator;
import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.PrimitiveIterable;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public abstract class FilteringIterable<E, I extends Iterable<E>>
implements FunctionalIterable<E> {
    protected final I iterable;

    public FilteringIterable(I i) {
        Objects.requireNonNull(i);
        this.iterable = i;
    }

    public static class OfLong
    extends FilteringIterable<Long, PrimitiveIterable.OfLong>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final LongPredicate filter;

        public OfLong(PrimitiveIterable.OfLong ofLong, LongPredicate longPredicate) {
            super(ofLong);
            Objects.requireNonNull(longPredicate);
            this.filter = longPredicate;
        }

        @Override
        public FunctionalPrimitiveIterator.OfLong iterator() {
            return new FilteringIterator.OfLong(((PrimitiveIterable.OfLong)this.iterable).iterator(), this.filter);
        }
    }

    public static class OfInt
    extends FilteringIterable<Integer, PrimitiveIterable.OfInt>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final IntPredicate filter;

        public OfInt(PrimitiveIterable.OfInt ofInt, IntPredicate intPredicate) {
            super(ofInt);
            Objects.requireNonNull(intPredicate);
            this.filter = intPredicate;
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return new FilteringIterator.OfInt(((PrimitiveIterable.OfInt)this.iterable).iterator(), this.filter);
        }
    }

    public static class OfDouble
    extends FilteringIterable<Double, PrimitiveIterable.OfDouble>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final DoublePredicate filter;

        public OfDouble(PrimitiveIterable.OfDouble ofDouble, DoublePredicate doublePredicate) {
            super(ofDouble);
            Objects.requireNonNull(doublePredicate);
            this.filter = doublePredicate;
        }

        @Override
        public FunctionalPrimitiveIterator.OfDouble iterator() {
            return new FilteringIterator.OfDouble(((PrimitiveIterable.OfDouble)this.iterable).iterator(), this.filter);
        }
    }

    public static class Of<E>
    extends FilteringIterable<E, Iterable<E>> {
        protected final Predicate<? super E> filter;

        public Of(Iterable<E> iterable, Predicate<? super E> predicate) {
            super(iterable);
            Objects.requireNonNull(predicate);
            this.filter = predicate;
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new FilteringIterator.Of<E>(this.iterable.iterator(), this.filter);
        }
    }
}

