/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.EmptyIterator;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.Reducible;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;

public abstract class ChainedIterator<E, I extends FunctionalIterator<E>>
implements FunctionalIterator<E> {
    protected FunctionalIterator<I> iterators;
    protected I current;

    public ChainedIterator(Iterator<? extends Iterator<E>> iterator) {
        this(EmptyIterator.of(), iterator);
    }

    public ChainedIterator(Iterator<E> iterator, Iterator<? extends Iterator<E>> iterator2) {
        Objects.requireNonNull(iterator);
        Objects.requireNonNull(iterator2);
        this.current = Reducible.extend(iterator);
        this.iterators = Reducible.extend(iterator2).map(Reducible::extend);
        this.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (this.current.hasNext()) {
            return true;
        }
        while (this.iterators.hasNext()) {
            this.current = (FunctionalIterator)this.iterators.next();
            if (!this.current.hasNext()) continue;
            return true;
        }
        this.release();
        return false;
    }

    @Override
    public long count() {
        long l = this.current.count() + this.iterators.mapToLong(Reducible::count).sum();
        this.release();
        return l;
    }

    @Override
    public void release() {
        this.iterators = EmptyIterator.of();
    }

    public static class OfLong
    extends ChainedIterator<Long, FunctionalPrimitiveIterator.OfLong>
    implements FunctionalPrimitiveIterator.OfLong {
        public OfLong(Iterator<? extends PrimitiveIterator.OfLong> iterator) {
            super(iterator);
        }

        public OfLong(PrimitiveIterator.OfLong ofLong, Iterator<? extends PrimitiveIterator.OfLong> iterator) {
            super(ofLong, iterator);
        }

        @Override
        public long nextLong() {
            this.requireNext();
            return ((FunctionalPrimitiveIterator.OfLong)this.current).nextLong();
        }

        @Override
        public boolean contains(long l) {
            boolean bl = ((FunctionalPrimitiveIterator.OfLong)this.current).contains(l) || this.iterators.anyMatch((? super E ofLong) -> ofLong.contains(l));
            this.release();
            return bl;
        }

        @Override
        public OptionalLong max() {
            if (!this.hasNext()) {
                return OptionalLong.empty();
            }
            long l2 = ((FunctionalPrimitiveIterator.OfLong)this.current).max().getAsLong();
            l2 = this.iterators.reduce(l2, (long l, ? super E ofLong) -> Math.max(l, ofLong.max().orElse(l)));
            this.release();
            return OptionalLong.of(l2);
        }

        @Override
        public OptionalLong min() {
            if (!this.hasNext()) {
                return OptionalLong.empty();
            }
            long l2 = ((FunctionalPrimitiveIterator.OfLong)this.current).min().getAsLong();
            l2 = this.iterators.reduce(l2, (long l, ? super E ofLong) -> Math.min(l, ofLong.min().orElse(l)));
            this.release();
            return OptionalLong.of(l2);
        }

        @Override
        public long sum() {
            long l2 = this.iterators.reduce(((FunctionalPrimitiveIterator.OfLong)this.current).sum(), (long l, ? super E ofLong) -> l + ofLong.sum());
            this.release();
            return l2;
        }

        @Override
        public void release() {
            super.release();
            this.current = EmptyIterator.ofLong();
        }
    }

    public static class OfInt
    extends ChainedIterator<Integer, FunctionalPrimitiveIterator.OfInt>
    implements FunctionalPrimitiveIterator.OfInt {
        public OfInt(Iterator<? extends PrimitiveIterator.OfInt> iterator) {
            super(iterator);
        }

        public OfInt(PrimitiveIterator.OfInt ofInt, Iterator<? extends PrimitiveIterator.OfInt> iterator) {
            super(ofInt, iterator);
        }

        @Override
        public int nextInt() {
            this.requireNext();
            return ((FunctionalPrimitiveIterator.OfInt)this.current).nextInt();
        }

        @Override
        public boolean contains(int n) {
            boolean bl = ((FunctionalPrimitiveIterator.OfInt)this.current).contains(n) || this.iterators.anyMatch((? super E ofInt) -> ofInt.contains(n));
            this.release();
            return bl;
        }

        @Override
        public OptionalInt max() {
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            int n2 = ((FunctionalPrimitiveIterator.OfInt)this.current).max().getAsInt();
            n2 = this.iterators.reduce(n2, (int n, ? super E ofInt) -> Math.max(n, ofInt.max().orElse(n)));
            this.release();
            return OptionalInt.of(n2);
        }

        @Override
        public OptionalInt min() {
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            int n2 = ((FunctionalPrimitiveIterator.OfInt)this.current).min().getAsInt();
            n2 = this.iterators.reduce(n2, (int n, ? super E ofInt) -> Math.min(n, ofInt.min().orElse(n)));
            this.release();
            return OptionalInt.of(n2);
        }

        @Override
        public long sum() {
            long l2 = this.iterators.reduce(((FunctionalPrimitiveIterator.OfInt)this.current).sum(), (long l, ? super E ofInt) -> l + ofInt.sum());
            this.release();
            return l2;
        }

        @Override
        public void release() {
            super.release();
            this.current = EmptyIterator.ofInt();
        }
    }

    public static class OfDouble
    extends ChainedIterator<Double, FunctionalPrimitiveIterator.OfDouble>
    implements FunctionalPrimitiveIterator.OfDouble {
        public OfDouble(Iterator<? extends PrimitiveIterator.OfDouble> iterator) {
            super(iterator);
        }

        public OfDouble(PrimitiveIterator.OfDouble ofDouble, Iterator<? extends PrimitiveIterator.OfDouble> iterator) {
            super(ofDouble, iterator);
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            return ((FunctionalPrimitiveIterator.OfDouble)this.current).nextDouble();
        }

        @Override
        public boolean contains(double d) {
            boolean bl = ((FunctionalPrimitiveIterator.OfDouble)this.current).contains(d) || this.iterators.anyMatch((? super E ofDouble) -> ofDouble.contains(d));
            this.release();
            return bl;
        }

        @Override
        public OptionalDouble max() {
            if (!this.hasNext()) {
                return OptionalDouble.empty();
            }
            double d2 = ((FunctionalPrimitiveIterator.OfDouble)this.current).max().getAsDouble();
            d2 = this.iterators.reduce(d2, (double d, ? super E ofDouble) -> Math.max(d, ofDouble.max().orElse(d)));
            this.release();
            return OptionalDouble.of(d2);
        }

        @Override
        public OptionalDouble min() {
            if (!this.hasNext()) {
                return OptionalDouble.empty();
            }
            double d2 = ((FunctionalPrimitiveIterator.OfDouble)this.current).min().getAsDouble();
            d2 = this.iterators.reduce(d2, (double d, ? super E ofDouble) -> Math.min(d, ofDouble.min().orElse(d)));
            this.release();
            return OptionalDouble.of(d2);
        }

        @Override
        public double sum() {
            double d2 = this.iterators.reduce(((FunctionalPrimitiveIterator.OfDouble)this.current).sum(), (double d, ? super E ofDouble) -> d + ofDouble.sum());
            this.release();
            return d2;
        }

        @Override
        public void release() {
            super.release();
            this.current = EmptyIterator.ofDouble();
        }
    }

    public static class Of<E>
    extends ChainedIterator<E, FunctionalIterator<E>> {
        public Of(Iterator<? extends Iterator<? extends E>> iterator) {
            super(iterator);
        }

        public Of(Iterator<? extends E> iterator, Iterator<? extends Iterator<? extends E>> iterator2) {
            super(iterator, iterator2);
        }

        @Override
        public E next() {
            this.requireNext();
            return this.current.next();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = this.current.contains(object) || this.iterators.anyMatch(functionalIterator -> functionalIterator.contains(object));
            this.release();
            return bl;
        }

        @Override
        public void release() {
            super.release();
            this.current = EmptyIterator.of();
        }
    }
}

