/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.Objects;

public abstract class ArrayIterator<E>
implements FunctionalIterator<E> {
    protected final int toIndex;
    protected int nextIndex;

    protected ArrayIterator(int n, int n2, int n3) {
        Objects.checkFromToIndex(n, n2, n3);
        this.nextIndex = n;
        this.toIndex = n2;
    }

    @Override
    public boolean hasNext() {
        if (this.nextIndex < this.toIndex) {
            return true;
        }
        this.release();
        return false;
    }

    @Override
    public long count() {
        return Math.max(0, this.toIndex - this.nextIndex);
    }

    public int nextIndex() {
        this.requireNext();
        return this.nextIndex;
    }

    @Override
    public void release() {
        this.nextIndex = this.toIndex;
    }

    public static class OfLong
    extends ArrayIterator<Long>
    implements FunctionalPrimitiveIterator.OfLong {
        public static final long[] EMPTY_LONG = new long[0];
        protected long[] elements;

        public OfLong(long ... lArray) {
            this(lArray, 0, lArray.length);
        }

        public OfLong(long[] lArray, int n, int n2) {
            super(n, n2, lArray.length);
            this.elements = lArray;
        }

        @Override
        public long nextLong() {
            this.requireNext();
            return this.elements[this.nextIndex++];
        }

        @Override
        public void release() {
            super.release();
            this.elements = EMPTY_LONG;
        }
    }

    public static class OfInt
    extends ArrayIterator<Integer>
    implements FunctionalPrimitiveIterator.OfInt {
        public static final int[] EMPTY_INT = new int[0];
        protected int[] elements;

        public OfInt(int ... nArray) {
            this(nArray, 0, nArray.length);
        }

        public OfInt(int[] nArray, int n, int n2) {
            super(n, n2, nArray.length);
            this.elements = nArray;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            return this.elements[this.nextIndex++];
        }

        @Override
        public void release() {
            super.release();
            this.elements = EMPTY_INT;
        }
    }

    public static class OfDouble
    extends ArrayIterator<Double>
    implements FunctionalPrimitiveIterator.OfDouble {
        public static final double[] EMPTY_DOUBLE = new double[0];
        protected double[] elements;

        public OfDouble(double ... dArray) {
            this(dArray, 0, dArray.length);
        }

        public OfDouble(double[] dArray, int n, int n2) {
            super(n, n2, dArray.length);
            this.elements = dArray;
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            return this.elements[this.nextIndex++];
        }

        @Override
        public void release() {
            super.release();
            this.elements = EMPTY_DOUBLE;
        }
    }

    public static class Of<E>
    extends ArrayIterator<E> {
        public static final Object[] EMPTY_OBJECT = new Object[0];
        protected E[] elements;

        @SafeVarargs
        public Of(E ... EArray) {
            this(EArray, 0, EArray.length);
        }

        public Of(E[] EArray, int n, int n2) {
            super(n, n2, EArray.length);
            this.elements = EArray;
        }

        @Override
        public E next() {
            this.requireNext();
            return this.elements[this.nextIndex++];
        }

        @Override
        public void release() {
            super.release();
            this.elements = EMPTY_OBJECT;
        }
    }
}

