/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.net.URI;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="5.3")
public class DynamicTest
extends DynamicNode {
    private final Executable executable;

    public static DynamicTest dynamicTest(String displayName, Executable executable) {
        return new DynamicTest(displayName, null, executable);
    }

    public static DynamicTest dynamicTest(String displayName, URI testSourceUri, Executable executable) {
        return new DynamicTest(displayName, testSourceUri, executable);
    }

    public static <T> Stream<DynamicTest> stream(Iterator<T> inputGenerator, Function<? super T, String> displayNameGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputGenerator, "inputGenerator must not be null");
        return DynamicTest.stream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(inputGenerator, 16), false), displayNameGenerator, testExecutor);
    }

    @API(status=API.Status.MAINTAINED, since="5.7")
    public static <T> Stream<DynamicTest> stream(Stream<T> inputStream, Function<? super T, String> displayNameGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputStream, "inputStream must not be null");
        Preconditions.notNull(displayNameGenerator, "displayNameGenerator must not be null");
        Preconditions.notNull(testExecutor, "testExecutor must not be null");
        return inputStream.map(input -> DynamicTest.dynamicTest((String)displayNameGenerator.apply(input), () -> testExecutor.accept(input)));
    }

    private DynamicTest(String displayName, URI testSourceUri, Executable executable) {
        super(displayName, testSourceUri);
        this.executable = Preconditions.notNull(executable, "executable must not be null");
    }

    public Executable getExecutable() {
        return this.executable;
    }
}

