/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistThreadPool;
import edu.jas.util.ExecutableChannels;
import edu.jas.util.ShutdownRequest;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DistPoolThread
extends Thread {
    final DistThreadPool pool;
    final ExecutableChannels ec;
    final int myId;
    private static final Logger logger = LogManager.getLogger(DistPoolThread.class);
    private static final boolean debug = logger.isDebugEnabled();
    boolean working = false;

    public DistPoolThread(DistThreadPool distThreadPool, ExecutableChannels executableChannels, int n) {
        this.pool = distThreadPool;
        this.ec = executableChannels;
        this.myId = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("ready, myId = {}", (Object)this.myId);
        int n = 0;
        long l = 0L;
        boolean bl = true;
        while (bl) {
            try {
                logger.debug("looking for a job");
                Runnable runnable = this.pool.getJob();
                this.working = true;
                if (debug) {
                    logger.info("working {} on {}", (Object)this.myId, (Object)runnable);
                }
                long l2 = System.currentTimeMillis();
                try {
                    if (runnable instanceof ShutdownRequest) {
                        this.ec.send(this.myId, "Stop");
                    } else {
                        this.ec.send(this.myId, runnable);
                    }
                    if (debug) {
                        logger.info("send {} at {} send job {}", (Object)this.myId, (Object)this.ec, (Object)runnable);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    logger.info("error send {} at {} e = {}", (Object)this.myId, (Object)this.ec, (Object)iOException);
                    this.working = false;
                }
                Object object = null;
                try {
                    if (this.working) {
                        logger.info("waiting {} on {}", (Object)this.myId, (Object)runnable);
                        object = this.ec.receive(this.myId);
                        if (debug) {
                            logger.info("receive {} at {} send job {} received {}", (Object)this.myId, (Object)this.ec, (Object)runnable, object);
                        }
                    }
                }
                catch (IOException iOException) {
                    logger.info("receive exception {} send job {}, e = {}", (Object)this.myId, (Object)runnable, (Object)iOException);
                    bl = false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.info("receive exception {} send job {}, e = {}", (Object)this.myId, (Object)runnable, (Object)classNotFoundException);
                    bl = false;
                }
                finally {
                    if (debug) {
                        logger.info("receive finally {} at {} send job {} received {} running {}", (Object)this.myId, (Object)this.ec, (Object)runnable, object, (Object)bl);
                    }
                }
                this.working = false;
                l += System.currentTimeMillis() - l2;
                ++n;
                if (!debug) continue;
                logger.info("done {} with {}", (Object)this.myId, object);
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                Thread.currentThread().interrupt();
            }
        }
        logger.info("terminated {}, done {} jobs in {} milliseconds", (Object)this.myId, (Object)n, (Object)l);
    }
}

