/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFieldChar0;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import edu.jas.ufd.SquarefreeRingChar0;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)SquarefreeTest.suite());
    }

    public SquarefreeTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SquarefreeTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testFactorySpecific() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        SquarefreeAbstract<ModInteger> squarefreeAbstract = SquarefreeFactory.getImplementation(modIntegerRing);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + squarefreeAbstract), (boolean)(squarefreeAbstract instanceof SquarefreeFiniteFieldCharP));
        ModLongRing modLongRing = new ModLongRing(19L, true);
        SquarefreeAbstract<ModLong> squarefreeAbstract2 = SquarefreeFactory.getImplementation(modLongRing);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + squarefreeAbstract2), (boolean)(squarefreeAbstract2 instanceof SquarefreeFiniteFieldCharP));
        BigInteger bigInteger = new BigInteger(1L);
        SquarefreeAbstract<BigInteger> squarefreeAbstract3 = SquarefreeFactory.getImplementation(bigInteger);
        SquarefreeTest.assertTrue((String)("sqf != Integer " + squarefreeAbstract3), (boolean)(squarefreeAbstract3 instanceof SquarefreeRingChar0));
        BigRational bigRational = new BigRational(1L);
        SquarefreeAbstract<BigRational> squarefreeAbstract4 = SquarefreeFactory.getImplementation(bigRational);
        SquarefreeTest.assertTrue((String)("sqf != Rational " + squarefreeAbstract4), (boolean)(squarefreeAbstract4 instanceof SquarefreeFieldChar0));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        SquarefreeAbstract<AlgebraicNumber<ModInteger>> squarefreeAbstract5 = SquarefreeFactory.getImplementation(algebraicNumberRing);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<ModInteger> " + squarefreeAbstract5), (boolean)(squarefreeAbstract5 instanceof SquarefreeFiniteFieldCharP));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0);
        AlgebraicNumberRing<BigRational> algebraicNumberRing2 = new AlgebraicNumberRing<BigRational>(genPolynomial2, true);
        SquarefreeAbstract<AlgebraicNumber<BigRational>> squarefreeAbstract6 = SquarefreeFactory.getImplementation(algebraicNumberRing2);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<BigRational> " + squarefreeAbstract6), (boolean)(squarefreeAbstract6 instanceof SquarefreeFieldChar0));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing2);
        SquarefreeAbstract<Quotient<BigRational>> squarefreeAbstract7 = SquarefreeFactory.getImplementation(quotientRing);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<BigRational> " + squarefreeAbstract7), (boolean)(squarefreeAbstract7 instanceof SquarefreeFieldChar0));
        genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        QuotientRing<ModInteger> quotientRing2 = new QuotientRing<ModInteger>(genPolynomialRing);
        SquarefreeAbstract<Quotient<ModInteger>> squarefreeAbstract8 = SquarefreeFactory.getImplementation(quotientRing2);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<ModInteger> " + squarefreeAbstract8), (boolean)(squarefreeAbstract8 instanceof SquarefreeInfiniteFieldCharP));
    }

    public void testFactoryGeneric() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        SquarefreeAbstract<ModInteger> squarefreeAbstract = SquarefreeFactory.getImplementation(modIntegerRing);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + squarefreeAbstract), (boolean)(squarefreeAbstract instanceof SquarefreeFiniteFieldCharP));
        ModLongRing modLongRing = new ModLongRing(19L, true);
        SquarefreeAbstract<ModLong> squarefreeAbstract2 = SquarefreeFactory.getImplementation(modLongRing);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + squarefreeAbstract2), (boolean)(squarefreeAbstract2 instanceof SquarefreeFiniteFieldCharP));
        BigInteger bigInteger = new BigInteger(1L);
        SquarefreeAbstract<BigInteger> squarefreeAbstract3 = SquarefreeFactory.getImplementation(bigInteger);
        SquarefreeTest.assertTrue((String)("sqf != Integer " + squarefreeAbstract3), (boolean)(squarefreeAbstract3 instanceof SquarefreeRingChar0));
        BigRational bigRational = new BigRational(1L);
        SquarefreeAbstract<BigRational> squarefreeAbstract4 = SquarefreeFactory.getImplementation(bigRational);
        SquarefreeTest.assertTrue((String)("sqf != Rational " + squarefreeAbstract4), (boolean)(squarefreeAbstract4 instanceof SquarefreeFieldChar0));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        SquarefreeAbstract<ModInteger> squarefreeAbstract5 = SquarefreeFactory.getImplementation(algebraicNumberRing);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<ModInteger> " + squarefreeAbstract5), (boolean)(squarefreeAbstract5 instanceof SquarefreeFiniteFieldCharP));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0);
        AlgebraicNumberRing<BigRational> algebraicNumberRing2 = new AlgebraicNumberRing<BigRational>(genPolynomial2, true);
        SquarefreeAbstract<BigRational> squarefreeAbstract6 = SquarefreeFactory.getImplementation(algebraicNumberRing2);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<BigRational> " + squarefreeAbstract6), (boolean)(squarefreeAbstract6 instanceof SquarefreeFieldChar0));
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, 2);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing2);
        SquarefreeAbstract<BigRational> squarefreeAbstract7 = SquarefreeFactory.getImplementation(quotientRing);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<BigRational> " + squarefreeAbstract7), (boolean)(squarefreeAbstract7 instanceof SquarefreeFieldChar0));
        genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        QuotientRing<ModInteger> quotientRing2 = new QuotientRing<ModInteger>(genPolynomialRing);
        SquarefreeAbstract<ModInteger> squarefreeAbstract8 = SquarefreeFactory.getImplementation(quotientRing2);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<ModInteger> " + squarefreeAbstract8), (boolean)(squarefreeAbstract8 instanceof SquarefreeInfiniteFieldCharP));
    }
}

