/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModLongRing;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.ModulElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import edu.jas.vector.LinAlg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorModularBerlekamp<MOD extends GcdRingElem<MOD>>
extends FactorAbsolute<MOD> {
    private static final Logger logger = LogManager.getLogger(FactorModularBerlekamp.class);

    private FactorModularBerlekamp() {
        this(new ModLongRing(13L, true));
    }

    public FactorModularBerlekamp(RingFactory<MOD> ringFactory) {
        super(ringFactory);
    }

    @Override
    public List<GenPolynomial<MOD>> baseFactorsSquarefree(GenPolynomial<MOD> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException("P == null not allowed");
        }
        long l = genPolynomial.ring.coFac.characteristic().longValueExact();
        if (l < 100L) {
            return this.baseFactorsSquarefreeSmallPrime(genPolynomial);
        }
        return this.baseFactorsSquarefreeBigPrime(genPolynomial);
    }

    public List<GenPolynomial<MOD>> baseFactorsSquarefreeSmallPrime(GenPolynomial<MOD> genPolynomial) {
        GenPolynomial<Object> genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        List<GenPolynomial<MOD>> list = new ArrayList();
        if (genPolynomial.isZERO()) {
            return list;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!((GcdRingElem)genPolynomial.leadingBaseCoefficient()).isONE()) {
            throw new IllegalArgumentException("ldcf(P) != 1: " + genPolynomial);
        }
        if (genPolynomial.isONE() || genPolynomial.degree(0) <= 1L) {
            list.add(genPolynomial);
            return list;
        }
        ArrayList arrayList = PolyUfdUtil.constructQmatrix(genPolynomial);
        int n = arrayList.size();
        int n2 = arrayList.get(0).size();
        GenMatrixRing genMatrixRing = new GenMatrixRing(genPolynomialRing.coFac, n, n2);
        GenMatrix genMatrix = new GenMatrix(genMatrixRing, arrayList);
        GenMatrix genMatrix2 = genMatrix.subtract(genMatrixRing.getONE());
        LinAlg linAlg = new LinAlg();
        List list2 = linAlg.nullSpaceBasis(genMatrix2);
        logger.info("Nsb = " + list2);
        int n3 = list2.size();
        if (n3 == 1) {
            list.add(genPolynomial);
            return list;
        }
        GenMatrix genMatrix3 = genMatrixRing.fromVectors(list2);
        AbelianGroupElem abelianGroupElem = genMatrix3.negate();
        ArrayList<GenPolynomial<GcdRingElem>> arrayList2 = new ArrayList<GenPolynomial<GcdRingElem>>();
        for (int i = 0; i < ((GenMatrix)abelianGroupElem).ring.rows; ++i) {
            GenVector abelianGroupElem2 = ((GenMatrix)abelianGroupElem).getRow(i);
            genPolynomial2 = genPolynomialRing.fromVector(abelianGroupElem2);
            if (genPolynomial2.isONE()) continue;
            arrayList2.add(genPolynomial2);
        }
        logger.info("#ofFactors k = " + n3);
        logger.info("trials = " + arrayList2);
        list.add(genPolynomial);
        for (GenPolynomial genPolynomial3 : arrayList2) {
            if (list.size() == n3) break;
            genPolynomial2 = list.remove(0);
            GcdRingElem gcdRingElem = null;
            Iterator<Object> iterator = null;
            if (genPolynomialRing.coFac instanceof ModularRingFactory) {
                iterator = ((ModularRingFactory)genPolynomialRing.coFac).iterator();
            } else if (genPolynomialRing.coFac instanceof AlgebraicNumberRing) {
                iterator = ((AlgebraicNumberRing)genPolynomialRing.coFac).iterator();
            } else {
                throw new IllegalArgumentException("no iterator for: " + genPolynomialRing.coFac);
            }
            while (iterator.hasNext()) {
                gcdRingElem = (GcdRingElem)iterator.next();
                GenPolynomial<GcdRingElem> genPolynomial4 = genPolynomial3.subtract(gcdRingElem);
                GenPolynomial<GcdRingElem> genPolynomial5 = genPolynomial4.gcd(genPolynomial2);
                if (genPolynomial5.isONE() || genPolynomial5.equals(genPolynomial2)) continue;
                list.add(genPolynomial5);
                genPolynomial2 = genPolynomial2.divide(genPolynomial5);
                logger.info("s = " + gcdRingElem + ", g = " + genPolynomial5 + ", a = " + genPolynomial2);
                if (!genPolynomial2.isONE()) continue;
                break;
            }
            if (genPolynomial2.isONE()) continue;
            list.add(genPolynomial2);
        }
        list = PolyUtil.monic(list);
        TreeSet treeSet = new TreeSet(list);
        list.clear();
        list.addAll(treeSet);
        return list;
    }

    public List<GenPolynomial<MOD>> baseFactorsSquarefreeBigPrime(GenPolynomial<MOD> genPolynomial) {
        Iterable<Monomial<Object>> iterable;
        Comparable comparable;
        if (genPolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        List<GenPolynomial<MOD>> list = new ArrayList();
        if (genPolynomial.isZERO()) {
            return list;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!((GcdRingElem)genPolynomial.leadingBaseCoefficient()).isONE()) {
            throw new IllegalArgumentException("ldcf(P) != 1: " + genPolynomial);
        }
        if (genPolynomial.isONE() || genPolynomial.degree(0) <= 1L) {
            list.add(genPolynomial);
            return list;
        }
        ArrayList arrayList = PolyUfdUtil.constructQmatrix(genPolynomial);
        int n = arrayList.size();
        int n2 = arrayList.get(0).size();
        GenMatrixRing genMatrixRing = new GenMatrixRing(genPolynomialRing.coFac, n, n2);
        GenMatrix genMatrix = new GenMatrix(genMatrixRing, arrayList);
        GenMatrix genMatrix2 = genMatrix.subtract(genMatrixRing.getONE());
        LinAlg linAlg = new LinAlg();
        List list2 = linAlg.nullSpaceBasis(genMatrix2);
        logger.info("Nsb = " + list2);
        int n3 = list2.size();
        if (n3 == 1) {
            list.add(genPolynomial);
            return list;
        }
        GenMatrix genMatrix3 = genMatrixRing.fromVectors(list2);
        AbelianGroupElem abelianGroupElem = genMatrix3.negate();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < ((GenMatrix)abelianGroupElem).ring.rows; ++i) {
            comparable = ((GenMatrix)abelianGroupElem).getRow(i);
            GenPolynomial genPolynomial2 = genPolynomialRing.fromVector(comparable);
            arrayList2.add(genPolynomial2);
        }
        logger.info("#ofFactors k = " + n3);
        logger.info("trials = " + arrayList2);
        list.add(genPolynomial);
        GenVectorModul genVectorModul = new GenVectorModul(genPolynomialRing.coFac, n3);
        comparable = genPolynomialRing.coFac.characteristic();
        int n4 = ((BigInteger)comparable).bitLength();
        if (genPolynomialRing.coFac instanceof AlgebraicNumberRing) {
            n4 = (int)((AlgebraicNumberRing)genPolynomialRing.coFac).extensionDegree();
            comparable = ((BigInteger)comparable).pow(n4);
        }
        logger.info("char = " + genPolynomialRing.coFac.characteristic() + ", q = " + comparable + ", lq = " + n4);
        do {
            GenPolynomial<RingElem<Object>> genPolynomial2;
            RingElem ringElem;
            if (((GenPolynomial)(iterable = (GenPolynomial)list.remove(0))).degree(0) <= 1L) {
                list.add((GenPolynomial<MOD>)iterable);
                continue;
            }
            ModulElem modulElem = genVectorModul.random(8, 0.95f);
            GenPolynomial<Object> genPolynomial4 = genPolynomialRing.getZERO();
            int n5 = 0;
            for (GenPolynomial genPolynomial3 : arrayList2) {
                ringElem = (GcdRingElem)((GenVector)modulElem).get(n5++);
                genPolynomial2 = genPolynomial3.multiply(ringElem);
                genPolynomial4 = genPolynomial4.sum((Object)genPolynomial2);
            }
            if ((genPolynomial4 = genPolynomial4.monic()).isONE()) {
                list.add((GenPolynomial<MOD>)iterable);
                continue;
            }
            if (!((BigInteger)comparable).testBit(0)) {
                long l = n4 - 1;
                ringElem = genPolynomial4;
                genPolynomial2 = genPolynomial4;
                int n6 = 1;
                while ((long)n6 < l) {
                    ringElem = ((GenPolynomial)ringElem).multiply(ringElem).remainder(iterable);
                    genPolynomial2 = genPolynomial2.sum((GcdRingElem)ringElem);
                    ++n6;
                }
                genPolynomial4 = genPolynomial2.remainder((GenPolynomial<GcdRingElem>)iterable).monic();
            } else {
                BigInteger bigInteger = ((BigInteger)comparable).subtract(BigInteger.ONE).shiftRight(1);
                GenPolynomial genPolynomial5 = Power.modPositivePower(genPolynomial4, bigInteger, iterable);
                genPolynomial4 = genPolynomial5.subtract(genPolynomialRing.getONE()).monic();
            }
            if (genPolynomial4.isZERO() || genPolynomial4.isONE()) {
                list.add((GenPolynomial<MOD>)iterable);
                continue;
            }
            GenPolynomial<Object> genPolynomial6 = genPolynomial4.gcd((GenPolynomial<Object>)iterable);
            if (genPolynomial6.isONE()) {
                list.add((GenPolynomial<MOD>)iterable);
                continue;
            }
            list.add(genPolynomial6);
            iterable = ((GenPolynomial)iterable).divide(genPolynomial6);
            logger.info("rv = " + (GenVector)modulElem + ", g = " + genPolynomial6 + ", a/g = " + iterable);
            if (((GenPolynomial)iterable).isONE()) continue;
            list.add((GenPolynomial<MOD>)iterable);
        } while (list.size() < n3);
        list = PolyUtil.monic(list);
        iterable = new TreeSet(list);
        list.clear();
        list.addAll((Collection<GenPolynomial<MOD>>)iterable);
        return list;
    }
}

