/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.TimeExceededException;
import java.util.concurrent.Callable;

public class TimeStatus {
    private static boolean allowTime = false;
    private static long limitTime = Long.MAX_VALUE;
    private static long startTime = System.currentTimeMillis();
    private static Callable<Boolean> callBack = null;

    protected TimeStatus() {
    }

    public static boolean isActive() {
        return allowTime;
    }

    public static void setActive() {
        allowTime = true;
    }

    public static void setNotActive() {
        allowTime = false;
    }

    public static void setLimit(long l) {
        limitTime = l;
    }

    public static void restart() {
        startTime = System.currentTimeMillis();
    }

    public static void setCallBack(Callable<Boolean> callable) {
        callBack = callable;
    }

    public static void checkTime(String string) {
        if (!allowTime) {
            return;
        }
        if (limitTime == Long.MAX_VALUE) {
            return;
        }
        long l = System.currentTimeMillis() - startTime - limitTime;
        if (l <= 0L) {
            return;
        }
        if (callBack != null) {
            try {
                boolean bl = callBack.call();
                if (bl) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "";
        }
        throw new TimeExceededException(string + " over time = " + l);
    }
}

