/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MiReducerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private GenPolynomial<C> H;
    private final ReductionPar<C> red;
    private final Semaphore done = new Semaphore(0);
    private static final Logger logger = LogManager.getLogger(MiReducerSeqPair.class);

    MiReducerSeqPair(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        this.G = list;
        this.H = genPolynomial;
        this.red = new ReductionPar();
    }

    public String toString() {
        return "MiReducerSeqpair";
    }

    public GenPolynomial<C> getNF() {
        try {
            this.done.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("interrupt in getNF");
        }
        return this.H;
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug("ht(H) = " + this.H.leadingExpVector());
        }
        try {
            this.H = this.red.normalform(this.G, this.H);
            this.done.release();
        }
        catch (RuntimeException runtimeException) {
            Thread.currentThread().interrupt();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ht(H) = " + this.H.leadingExpVector());
        }
    }
}

