/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Object;

public class FuncInterp<R extends Sort>
extends Z3Object {
    public int getNumEntries() {
        return Native.funcInterpGetNumEntries(this.getContext().nCtx(), this.getNativeObject());
    }

    public Entry<R>[] getEntries() {
        int n = this.getNumEntries();
        Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            entryArray[i] = new Entry(this.getContext(), Native.funcInterpGetEntry(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return entryArray;
    }

    public Expr<R> getElse() {
        return Expr.create(this.getContext(), Native.funcInterpGetElse(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getArity() {
        return Native.funcInterpGetArity(this.getContext().nCtx(), this.getNativeObject());
    }

    public String toString() {
        String string = "";
        string = string + "[";
        for (Entry<R> entry : this.getEntries()) {
            int n = entry.getNumArgs();
            if (n > 1) {
                string = string + "[";
            }
            Expr<?>[] exprArray = entry.getArgs();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    string = string + ", ";
                }
                string = string + exprArray[i];
            }
            if (n > 1) {
                string = string + "]";
            }
            string = string + " -> " + entry.getValue() + ", ";
        }
        string = string + "else -> " + this.getElse();
        string = string + "]";
        return string;
    }

    FuncInterp(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef() {
        Native.funcInterpIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getFuncInterpDRQ().storeReference(this.getContext(), this);
    }

    public static class Entry<R extends Sort>
    extends Z3Object {
        public Expr<R> getValue() {
            return Expr.create(this.getContext(), Native.funcEntryGetValue(this.getContext().nCtx(), this.getNativeObject()));
        }

        public int getNumArgs() {
            return Native.funcEntryGetNumArgs(this.getContext().nCtx(), this.getNativeObject());
        }

        public Expr<?>[] getArgs() {
            int n = this.getNumArgs();
            Expr[] exprArray = new Expr[n];
            for (int i = 0; i < n; ++i) {
                exprArray[i] = Expr.create(this.getContext(), Native.funcEntryGetArg(this.getContext().nCtx(), this.getNativeObject(), i));
            }
            return exprArray;
        }

        public String toString() {
            int n = this.getNumArgs();
            String string = "[";
            Expr<?>[] exprArray = this.getArgs();
            for (int i = 0; i < n; ++i) {
                string = string + exprArray[i] + ", ";
            }
            return string + this.getValue() + "]";
        }

        Entry(Context context, long l) {
            super(context, l);
        }

        @Override
        void incRef() {
            Native.funcEntryIncRef(this.getContext().nCtx(), this.getNativeObject());
        }

        @Override
        void addToReferenceQueue() {
            this.getContext().getFuncEntryDRQ().storeReference(this.getContext(), this);
        }
    }
}

