/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Terminator {
    private static final Logger logger = LogManager.getLogger(Terminator.class);
    private final int workers;
    private int idler;
    private final Semaphore fin;
    private boolean done;

    public Terminator(int n) {
        this.workers = n;
        this.fin = new Semaphore(0);
        this.done = false;
        this.idler = 0;
        logger.info("constructor, workers = {}", (Object)n);
    }

    public String toString() {
        return "Terminator(" + this.done + ",workers=" + this.workers + ",idler=" + this.idler + ")";
    }

    public synchronized void beIdle() {
        ++this.idler;
        logger.info("beIdle, idler = {}", (Object)this.idler);
        if (this.idler >= this.workers) {
            this.done = true;
            this.fin.release();
        }
    }

    public synchronized void initIdle(int n) {
        this.idler += n;
        logger.info("initIdle, idler = {}", (Object)this.idler);
        if (this.idler > this.workers) {
            if (this.done) {
                this.idler = this.workers;
            } else {
                throw new RuntimeException("idler > workers: " + this.idler + " > " + this.workers);
            }
        }
    }

    public synchronized void beIdle(int n) {
        this.idler += n;
        logger.info("beIdle, idler = {}", (Object)this.idler);
        if (this.idler >= this.workers) {
            this.done = true;
            this.fin.release();
        }
    }

    public synchronized void allIdle() {
        this.idler = this.workers;
        logger.info("allIdle");
        this.done = true;
        this.fin.release();
    }

    public synchronized void notIdle() {
        --this.idler;
        logger.info("notIdle, idler = {}", (Object)this.idler);
        if (this.idler < 0) {
            throw new RuntimeException("idler < 0");
        }
    }

    public synchronized int getJobs() {
        return this.workers - this.idler;
    }

    public synchronized boolean hasJobs() {
        return this.idler < this.workers;
    }

    public synchronized void release() {
        logger.info("release = {}", (Object)this);
        if (this.idler >= this.workers) {
            this.done = true;
            this.fin.release();
        }
    }

    public void waitDone() {
        try {
            this.fin.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        logger.info("waitDone {}", (Object)this);
    }
}

