/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.kern.PreemptingException;
import edu.jas.util.ThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PoolThread
extends Thread {
    ThreadPool pool;
    private static final Logger logger = LogManager.getLogger(PoolThread.class);
    private static final boolean debug = logger.isDebugEnabled();
    volatile boolean isWorking = false;

    public PoolThread(ThreadPool threadPool) {
        this.pool = threadPool;
    }

    @Override
    public void run() {
        logger.info("ready");
        int n = 0;
        long l = 0L;
        boolean bl = true;
        while (bl) {
            try {
                logger.debug("looking for a job");
                Runnable runnable = this.pool.getJob();
                if (runnable == null) break;
                if (debug) {
                    logger.info("working");
                }
                long l2 = System.currentTimeMillis();
                this.isWorking = true;
                runnable.run();
                this.isWorking = false;
                l += System.currentTimeMillis() - l2;
                ++n;
                if (debug) {
                    logger.info("done");
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                bl = false;
                this.isWorking = false;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                bl = false;
                this.isWorking = false;
            }
            catch (PreemptingException preemptingException) {
                logger.debug("catched {}", (Throwable)preemptingException);
            }
            catch (RuntimeException runtimeException) {
                logger.warn("catched {}", (Throwable)runtimeException);
                runtimeException.printStackTrace();
            }
        }
        this.isWorking = false;
        logger.info("terminated, done {} jobs in {} milliseconds", (Object)n, (Object)l);
    }
}

