/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Counter;
import edu.jas.util.Listener;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DistributedList {
    private static final Logger logger = LogManager.getLogger(DistributedList.class);
    protected final SortedMap<Counter, Object> theList;
    protected final ChannelFactory cf;
    protected SocketChannel channel = null;
    protected Listener listener = null;

    public DistributedList(String string) {
        this(string, 4810);
    }

    public DistributedList(String string, int n) {
        this(new ChannelFactory(n + 1), string, n);
    }

    public DistributedList(ChannelFactory channelFactory, String string, int n) {
        this.cf = channelFactory;
        channelFactory.init();
        try {
            this.channel = channelFactory.getChannel(string, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger.debug("dl channel = {}", (Object)this.channel);
        this.theList = new TreeMap<Counter, Object>();
    }

    public DistributedList(SocketChannel socketChannel) {
        this.cf = null;
        this.channel = socketChannel;
        this.theList = new TreeMap<Counter, Object>();
    }

    public void init() {
        this.listener = new Listener(this.channel, this.theList);
        this.listener.start();
    }

    public void terminate() {
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.listener == null) {
            return;
        }
        logger.debug("terminate {}", (Object)this.listener);
        this.listener.setDone();
        try {
            while (this.listener.isAlive()) {
                this.listener.interrupt();
                this.listener.join(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.listener = null;
    }

    public List<Object> getList() {
        return new ArrayList<Object>(this.theList.values());
    }

    public int size() {
        return this.theList.size();
    }

    public synchronized void add(Object object) {
        int n = this.theList.size() + 1;
        try {
            this.channel.send(object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            while (this.theList.size() < n) {
                this.wait(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            interruptedException.printStackTrace();
        }
    }

    public synchronized void clear() {
        this.theList.clear();
    }

    public boolean isEmpty() {
        return this.theList.isEmpty();
    }

    public Iterator iterator() {
        return this.theList.values().iterator();
    }
}

