/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealRootsSturm;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RealAlgebraicRing<C extends GcdRingElem<C> & Rational>
implements RingFactory<RealAlgebraicNumber<C>> {
    public final AlgebraicNumberRing<C> algebraic;
    Interval<C> root;
    public static final int PRECISION = BigDecimal.DEFAULT_PRECISION;
    protected BigRational eps;
    public final RealRootsSturm<C> engine;

    public RealAlgebraicRing(GenPolynomial<C> genPolynomial, Interval<C> interval) {
        this.algebraic = new AlgebraicNumberRing<C>(genPolynomial);
        this.root = interval;
        this.engine = new RealRootsSturm();
        if (genPolynomial.ring.characteristic().signum() > 0) {
            throw new RuntimeException("characteristic not zero");
        }
        BigRational bigRational = new BigRational(10L);
        this.eps = bigRational = (BigRational)bigRational.power(-PRECISION / 2);
    }

    public RealAlgebraicRing(GenPolynomial<C> genPolynomial, Interval<C> interval, boolean bl) {
        this(genPolynomial, interval);
        this.setField(bl);
    }

    public synchronized Interval<C> getRoot() {
        return this.root;
    }

    public synchronized void setRoot(Interval<C> interval) {
        assert (this.root.contains(interval)) : "root contains v";
        this.root = interval;
    }

    public synchronized BigRational getEps() {
        return this.eps;
    }

    public synchronized void setEps(C c) {
        this.setEps(((Rational)c).getRational());
    }

    public synchronized void setEps(BigRational bigRational) {
        this.eps = bigRational;
    }

    public synchronized void refineRoot() {
        this.refineRoot(this.eps);
    }

    public synchronized void refineRoot(BigRational bigRational) {
        this.root = this.engine.refineInterval(this.root, this.algebraic.modul, bigRational);
        this.eps = bigRational;
    }

    public void halfInterval() {
        Interval<C> interval = this.engine.halfInterval(this.root, this.algebraic.modul);
        this.setRoot(interval);
    }

    @Override
    public boolean isFinite() {
        return this.algebraic.isFinite();
    }

    @Override
    public RealAlgebraicNumber<C> copy(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber(this, realAlgebraicNumber.number);
    }

    public RealAlgebraicRing<C> copy() {
        if (this.algebraic.isField()) {
            return new RealAlgebraicRing(this.algebraic.modul, this.root, this.algebraic.isField());
        }
        return new RealAlgebraicRing(this.algebraic.modul, this.root);
    }

    @Override
    public RealAlgebraicNumber<C> getZERO() {
        return new RealAlgebraicNumber(this, this.algebraic.getZERO());
    }

    @Override
    public RealAlgebraicNumber<C> getONE() {
        return new RealAlgebraicNumber(this, this.algebraic.getONE());
    }

    public RealAlgebraicNumber<C> getGenerator() {
        return new RealAlgebraicNumber<C>(this, this.algebraic.getGenerator());
    }

    @Override
    public List<RealAlgebraicNumber<C>> generators() {
        List<AlgebraicNumber<C>> list = this.algebraic.generators();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>(list.size());
        for (AlgebraicNumber<C> algebraicNumber : list) {
            arrayList.add(((RealAlgebraicNumber)this.getZERO()).sum(algebraicNumber.getVal()));
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.algebraic.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.algebraic.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.algebraic.isField();
    }

    public void setField(boolean bl) {
        this.algebraic.setField(bl);
    }

    @Override
    public BigInteger characteristic() {
        return this.algebraic.characteristic();
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(BigInteger bigInteger) {
        return new RealAlgebraicNumber(this, this.algebraic.fromInteger(bigInteger));
    }

    public RealAlgebraicNumber<C> fromRational(BigRational bigRational) {
        return new RealAlgebraicNumber(this, this.algebraic.parse(bigRational.toString()));
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(long l) {
        return new RealAlgebraicNumber(this, this.algebraic.fromInteger(l));
    }

    public String toString() {
        return "RealAlgebraicRing[ " + this.algebraic.modul.toString() + " in " + this.root + " | isField=" + this.algebraic.isField() + " :: " + this.algebraic.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "RealN( " + this.algebraic.modul.toScript() + ", " + this.root.toScript() + " )";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RealAlgebraicRing)) {
            return false;
        }
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)object;
        return this.algebraic.equals(realAlgebraicRing.algebraic) && this.root.equals(realAlgebraicRing.root);
    }

    public int hashCode() {
        return 37 * this.algebraic.hashCode() + this.root.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> random(int n) {
        return new RealAlgebraicNumber(this, this.algebraic.random(n));
    }

    @Override
    public RealAlgebraicNumber<C> random(int n, Random random) {
        return new RealAlgebraicNumber(this, this.algebraic.random(n, random));
    }

    @Override
    public RealAlgebraicNumber<C> parse(String string) {
        return new RealAlgebraicNumber(this, this.algebraic.parse(string));
    }

    @Override
    public RealAlgebraicNumber<C> parse(Reader reader) {
        return new RealAlgebraicNumber(this, this.algebraic.parse(reader));
    }
}

