/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.ps.ExpVectorIterable;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.BinaryFunctor;
import edu.jas.structure.RingElem;
import edu.jas.structure.Selector;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.MapEntry;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MultiVarPowerSeries<C extends RingElem<C>>
implements RingElem<MultiVarPowerSeries<C>> {
    public final MultiVarPowerSeriesRing<C> ring;
    MultiVarCoefficients<C> lazyCoeffs;
    private int truncate;
    private int order = -1;
    private ExpVector evorder = null;

    private MultiVarPowerSeries() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    MultiVarPowerSeries(MultiVarPowerSeriesRing<C> multiVarPowerSeriesRing) {
        this.ring = multiVarPowerSeriesRing;
        this.lazyCoeffs = null;
        this.truncate = multiVarPowerSeriesRing.truncate;
    }

    public MultiVarPowerSeries(MultiVarPowerSeriesRing<C> multiVarPowerSeriesRing, MultiVarCoefficients<C> multiVarCoefficients) {
        this(multiVarPowerSeriesRing, multiVarCoefficients, multiVarPowerSeriesRing.truncate);
    }

    public MultiVarPowerSeries(MultiVarPowerSeriesRing<C> multiVarPowerSeriesRing, MultiVarCoefficients<C> multiVarCoefficients, int n) {
        if (multiVarCoefficients == null || multiVarPowerSeriesRing == null) {
            throw new IllegalArgumentException("null not allowed: ring = " + multiVarPowerSeriesRing + ", lazyCoeffs = " + multiVarCoefficients);
        }
        this.ring = multiVarPowerSeriesRing;
        this.lazyCoeffs = multiVarCoefficients;
        this.truncate = Math.min(n, multiVarPowerSeriesRing.truncate);
    }

    @Override
    public MultiVarPowerSeriesRing<C> factory() {
        return this.ring;
    }

    @Override
    public MultiVarPowerSeries<C> copy() {
        return new MultiVarPowerSeries<C>(this.ring, this.lazyCoeffs);
    }

    public String toString() {
        return this.toString(this.truncate);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        MultiVarPowerSeries multiVarPowerSeries = this;
        String[] stringArray = this.ring.vars;
        for (ExpVector expVector : new ExpVectorIterable(this.ring.nvar, true, n)) {
            Object object = multiVarPowerSeries.coefficient(expVector);
            int n2 = object.signum();
            if (n2 == 0) continue;
            if (n2 > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" + ");
                }
            } else {
                object = (RingElem)object.negate();
                stringBuffer.append(" - ");
            }
            if (!object.isONE() || expVector.isZERO()) {
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append("{ ");
                }
                stringBuffer.append(object.toString());
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append(" }");
                }
                if (!expVector.isZERO()) {
                    stringBuffer.append(" * ");
                }
            }
            if (expVector.isZERO()) continue;
            stringBuffer.append(expVector.toString(stringArray));
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("0");
        }
        stringBuffer.append(" + BigO( (" + this.ring.varsToString() + ")^" + (n + 1) + "(" + (this.ring.truncate + 1) + ") )");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("");
        MultiVarPowerSeries multiVarPowerSeries = this;
        String[] stringArray = this.ring.vars;
        for (ExpVector expVector : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            Object object = multiVarPowerSeries.coefficient(expVector);
            int n = object.signum();
            if (n == 0) continue;
            if (n > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" + ");
                }
            } else {
                object = (RingElem)object.negate();
                stringBuffer.append(" - ");
            }
            if (!object.isONE() || expVector.isZERO()) {
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append("( ");
                }
                stringBuffer.append(object.toScript());
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append(" )");
                }
                if (!expVector.isZERO()) {
                    stringBuffer.append(" * ");
                }
            }
            if (expVector.isZERO()) continue;
            stringBuffer.append(expVector.toScript(stringArray));
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("0");
        }
        stringBuffer.append(" + BigO( (" + this.ring.varsToString() + ")**" + (this.truncate + 1) + " )");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((MultiVarPowerSeriesRing)this.factory()).toScript();
    }

    public C coefficient(ExpVector expVector) {
        if (expVector == null) {
            throw new IndexOutOfBoundsException("null index not allowed");
        }
        return this.lazyCoeffs.get(expVector);
    }

    public GenPolynomial<C> homogeneousPart(long l) {
        return this.lazyCoeffs.getHomPart(l);
    }

    public GenPolynomial<C> asPolynomial() {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.homogeneousPart(0L);
        for (int i = 1; i <= this.truncate; ++i) {
            genPolynomial = genPolynomial.sum(this.homogeneousPart(i));
        }
        return genPolynomial;
    }

    public C leadingCoefficient() {
        return this.coefficient(this.ring.EVZERO);
    }

    public MultiVarPowerSeries<C> reductum(final int n) {
        if (n < 0 || this.ring.nvar < n) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                ExpVector expVector2 = expVector.subst(n, expVector.getVal(n) + 1L);
                return MultiVarPowerSeries.this.coefficient(expVector2);
            }
        });
    }

    public MultiVarPowerSeries<C> prepend(C c, int n) {
        if (n < 0 || this.ring.nvar < n) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring, (RingElem)c, n){
            final /* synthetic */ RingElem val$h;
            final /* synthetic */ int val$r;
            {
                this.val$h = ringElem;
                this.val$r = n;
                super(multiVarPowerSeriesRing);
            }

            @Override
            public C generate(ExpVector expVector) {
                if (expVector.isZERO()) {
                    return this.val$h;
                }
                ExpVector expVector2 = expVector.subst(this.val$r, expVector.getVal(this.val$r) - 1L);
                if (expVector2.signum() < 0) {
                    return (RingElem)this.pfac.coFac.getZERO();
                }
                return MultiVarPowerSeries.this.coefficient(expVector2);
            }
        });
    }

    public MultiVarPowerSeries<C> shift(final int n, final int n2) {
        if (n2 < 0 || this.ring.nvar < n2) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        int n3 = Math.min(this.truncate + n, this.ring.truncate);
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                long l = expVector.getVal(n2);
                if (l - (long)n < 0L) {
                    return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                ExpVector expVector2 = expVector.subst(n2, expVector.getVal(n2) - (long)n);
                return MultiVarPowerSeries.this.coefficient(expVector2);
            }
        }, n3);
    }

    public MultiVarPowerSeries<C> reductum() {
        Map.Entry<ExpVector, C> entry = this.orderMonomial();
        if (entry == null) {
            return this.ring.getZERO();
        }
        ExpVector expVector = entry.getKey();
        long l = expVector.totalDeg();
        MultiVarCoefficients<C> multiVarCoefficients = this.lazyCoeffs;
        HashMap hashMap = new HashMap(multiVarCoefficients.coeffCache);
        GenPolynomial<RingElem> genPolynomial = hashMap.get(l);
        if (genPolynomial != null && !genPolynomial.isZERO()) {
            genPolynomial = genPolynomial.subtract((RingElem)entry.getValue(), expVector);
            hashMap.put(l, genPolynomial);
        }
        HashSet<ExpVector> hashSet = new HashSet<ExpVector>(multiVarCoefficients.zeroCache);
        if (!multiVarCoefficients.homCheck.get((int)l)) {
            hashSet.add(expVector);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(multiVarCoefficients.pfac, hashMap, hashSet, multiVarCoefficients.homCheck){

            @Override
            public C generate(ExpVector expVector) {
                return MultiVarPowerSeries.this.coefficient(expVector);
            }
        });
    }

    public MultiVarPowerSeries<C> shift(final ExpVector expVector) {
        if (expVector == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (expVector.signum() == 0) {
            return this;
        }
        int n = Math.min(this.truncate + (int)expVector.totalDeg(), this.ring.truncate);
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector3) {
                ExpVector expVector2 = expVector3.subtract(expVector);
                if (expVector2.signum() < 0) {
                    return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                return MultiVarPowerSeries.this.coefficient(expVector2);
            }
        }, n);
    }

    public MultiVarPowerSeries<C> multiply(C c, final ExpVector expVector) {
        if (expVector == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (expVector.signum() == 0) {
            return this.multiply(c);
        }
        if (c.signum() == 0) {
            return this.ring.getZERO();
        }
        int n = Math.min(this.ring.truncate, this.truncate + (int)expVector.totalDeg());
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring, (RingElem)c){
            final /* synthetic */ RingElem val$c;
            {
                this.val$c = ringElem;
                super(multiVarPowerSeriesRing);
            }

            @Override
            public C generate(ExpVector expVector3) {
                ExpVector expVector2 = expVector3.subtract(expVector);
                if (expVector2.signum() < 0) {
                    return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                long l = expVector2.totalDeg();
                if (MultiVarPowerSeries.this.lazyCoeffs.homCheck.get((int)l)) {
                    GenPolynomial<RingElem> genPolynomial = MultiVarPowerSeries.this.homogeneousPart(l).multiply(this.val$c, expVector);
                    long l2 = expVector3.totalDeg();
                    this.coeffCache.put(l2, genPolynomial);
                    this.homCheck.set((int)l2);
                    RingElem ringElem = genPolynomial.coefficient(expVector3);
                    return ringElem;
                }
                return MultiVarPowerSeries.this.coefficient(expVector2).multiply((RingElem)this.val$c);
            }
        }, n);
    }

    @Override
    public MultiVarPowerSeries<C> sum(Map.Entry<ExpVector, C> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("null Map.Entry not allowed");
        }
        return this.sum((RingElem)entry.getValue(), entry.getKey());
    }

    public MultiVarPowerSeries<C> sum(C c, ExpVector expVector) {
        if (expVector == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (c.signum() == 0) {
            return this;
        }
        long l = expVector.totalDeg();
        MultiVarCoefficients<C> multiVarCoefficients = this.lazyCoeffs;
        HashMap hashMap = new HashMap(multiVarCoefficients.coeffCache);
        AbelianGroupElem abelianGroupElem = hashMap.get(l);
        if (abelianGroupElem == null) {
            abelianGroupElem = multiVarCoefficients.pfac.getZERO();
        }
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum(c, expVector);
        hashMap.put(l, abelianGroupElem);
        HashSet<ExpVector> hashSet = new HashSet<ExpVector>(multiVarCoefficients.zeroCache);
        if (((GenPolynomial)abelianGroupElem).coefficient(expVector).isZERO() && !multiVarCoefficients.homCheck.get((int)l)) {
            hashSet.add(expVector);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(multiVarCoefficients.pfac, hashMap, hashSet, multiVarCoefficients.homCheck){

            @Override
            public C generate(ExpVector expVector) {
                return MultiVarPowerSeries.this.coefficient(expVector);
            }
        });
    }

    public MultiVarPowerSeries<C> subtract(C c, ExpVector expVector) {
        if (expVector == null) {
            throw new IllegalArgumentException("null ExpVector not allowed");
        }
        if (c.signum() == 0) {
            return this;
        }
        long l = expVector.totalDeg();
        MultiVarCoefficients<C> multiVarCoefficients = this.lazyCoeffs;
        HashMap hashMap = new HashMap(multiVarCoefficients.coeffCache);
        AbelianGroupElem abelianGroupElem = hashMap.get(l);
        if (abelianGroupElem == null) {
            abelianGroupElem = multiVarCoefficients.pfac.getZERO();
        }
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).subtract(c, expVector);
        hashMap.put(l, abelianGroupElem);
        HashSet<ExpVector> hashSet = new HashSet<ExpVector>(multiVarCoefficients.zeroCache);
        if (((GenPolynomial)abelianGroupElem).coefficient(expVector).isZERO() && !multiVarCoefficients.homCheck.get((int)l)) {
            hashSet.add(expVector);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(multiVarCoefficients.pfac, hashMap, hashSet, multiVarCoefficients.homCheck){

            @Override
            public C generate(ExpVector expVector) {
                return MultiVarPowerSeries.this.coefficient(expVector);
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> sum(MultiVarCoefficients<C> multiVarCoefficients) {
        MultiVarCoefficients<C> multiVarCoefficients2 = this.lazyCoeffs;
        TreeMap treeMap = new TreeMap(multiVarCoefficients2.coeffCache);
        TreeMap treeMap2 = new TreeMap(multiVarCoefficients.coeffCache);
        long l = treeMap.size() > 0 ? treeMap.lastKey() : 0L;
        long l2 = treeMap2.size() > 0 ? treeMap2.lastKey() : 0L;
        HashSet<ExpVector> hashSet = new HashSet<ExpVector>(multiVarCoefficients2.zeroCache);
        hashSet.addAll(multiVarCoefficients.zeroCache);
        long l3 = Math.max(l, l2);
        BitSet bitSet = new BitSet((int)l3);
        for (long i = 0L; i <= l3; ++i) {
            AbelianGroupElem abelianGroupElem = treeMap.get(i);
            AbelianGroupElem abelianGroupElem2 = multiVarCoefficients.coeffCache.get(i);
            if (abelianGroupElem == null) {
                abelianGroupElem = multiVarCoefficients2.pfac.getZERO();
            }
            if (abelianGroupElem2 == null) {
                abelianGroupElem2 = multiVarCoefficients2.pfac.getZERO();
            }
            GenPolynomial genPolynomial = ((GenPolynomial)abelianGroupElem).sum(abelianGroupElem2);
            treeMap.put(i, genPolynomial);
            if (multiVarCoefficients2.homCheck.get((int)i) && multiVarCoefficients.homCheck.get((int)i)) {
                bitSet.set((int)i);
                continue;
            }
            HashSet<ExpVector> hashSet2 = new HashSet<ExpVector>(((GenPolynomial)abelianGroupElem).getMap().keySet());
            hashSet2.addAll(((GenPolynomial)abelianGroupElem2).getMap().keySet());
            hashSet2.removeAll(genPolynomial.getMap().keySet());
            hashSet.addAll(hashSet2);
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(multiVarCoefficients2.pfac, new HashMap(treeMap), hashSet, bitSet){

            @Override
            public C generate(ExpVector expVector) {
                return MultiVarPowerSeries.this.coefficient(expVector);
            }
        });
    }

    public MultiVarPowerSeries<C> select(final Selector<? super C> selector) {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                Object c = MultiVarPowerSeries.this.coefficient(expVector);
                if (selector.select(c)) {
                    return c;
                }
                return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
            }
        });
    }

    public MultiVarPowerSeries<C> shiftSelect(final Selector<? super C> selector) {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){
            ExpVectorIterable ib;
            Iterator<ExpVector> pos;
            {
                super(multiVarPowerSeriesRing);
                this.ib = new ExpVectorIterable(MultiVarPowerSeries.this.ring.nvar, true, MultiVarPowerSeries.this.truncate);
                this.pos = this.ib.iterator();
            }

            @Override
            public C generate(ExpVector expVector) {
                RingElem ringElem;
                Object object;
                if (expVector.signum() > 0) {
                    object = expVector.dependencyOnVariables();
                    ExpVector expVector2 = expVector.subst(object[0], expVector.getVal(object[0]) - 1L);
                    ringElem = this.get(expVector2);
                }
                do {
                    ringElem = null;
                } while (this.pos.hasNext() && !selector.select(ringElem = MultiVarPowerSeries.this.coefficient((ExpVector)(object = (Object)this.pos.next()))));
                if (ringElem == null) {
                    ringElem = (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
                }
                return ringElem;
            }
        });
    }

    public MultiVarPowerSeries<C> map(final UnaryFunctor<? super C, C> unaryFunctor) {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                return (RingElem)unaryFunctor.eval(MultiVarPowerSeries.this.coefficient(expVector));
            }
        });
    }

    public MultiVarPowerSeries<C> zip(final BinaryFunctor<? super C, ? super C, C> binaryFunctor, final MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n = Math.min(this.ring.truncate, Math.max(this.truncate, multiVarPowerSeries.truncate()));
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                return (RingElem)binaryFunctor.eval(MultiVarPowerSeries.this.coefficient(expVector), multiVarPowerSeries.coefficient(expVector));
            }
        }, n);
    }

    public MultiVarPowerSeries<C> sumZip(MultiVarPowerSeries<C> multiVarPowerSeries) {
        return this.zip(new BinaryFunctor<C, C, C>(){

            @Override
            public C eval(C c, C c2) {
                return (RingElem)c.sum(c2);
            }
        }, multiVarPowerSeries);
    }

    public MultiVarPowerSeries<C> subtractZip(MultiVarPowerSeries<C> multiVarPowerSeries) {
        return this.zip(new BinaryFunctor<C, C, C>(){

            @Override
            public C eval(C c, C c2) {
                return (RingElem)c.subtract(c2);
            }
        }, multiVarPowerSeries);
    }

    @Override
    public MultiVarPowerSeries<C> multiply(C c) {
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (c.isONE()) {
            return this;
        }
        return this.map(new UnaryFunctor<C, C>((RingElem)c){
            final /* synthetic */ RingElem val$a;
            {
                this.val$a = ringElem;
            }

            @Override
            public C eval(C ringElem) {
                return ringElem.multiply((RingElem)this.val$a);
            }
        });
    }

    public MultiVarPowerSeries<C> monic() {
        ExpVector expVector = this.orderExpVector();
        if (expVector == null) {
            return this;
        }
        C c = this.coefficient(expVector);
        if (c.isONE()) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        final RingElem ringElem = (RingElem)c.inverse();
        return this.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C c) {
                return (RingElem)ringElem.multiply(c);
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> negate() {
        return this.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C c) {
                return (RingElem)c.negate();
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public C evaluate(List<C> list) {
        RingElem ringElem = (RingElem)this.ring.coFac.getZERO();
        for (ExpVector expVector : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            Object object = this.coefficient(expVector);
            if (object.isZERO()) continue;
            object = (RingElem)object.multiply(expVector.evaluate(this.ring.coFac, list));
            ringElem = (RingElem)ringElem.sum(object);
        }
        return (C)ringElem;
    }

    public int order() {
        if (this.order >= 0) {
            return this.order;
        }
        GenPolynomial genPolynomial = null;
        int n = 0;
        while (this.lazyCoeffs.homCheck.get(n)) {
            genPolynomial = this.lazyCoeffs.coeffCache.get(n);
            if (genPolynomial == null || genPolynomial.isZERO()) {
                ++n;
                continue;
            }
            this.order = n;
            this.evorder = genPolynomial.trailingExpVector();
            return this.order;
        }
        for (ExpVector expVector : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            if (this.coefficient(expVector).isZERO()) continue;
            this.order = (int)expVector.totalDeg();
            this.evorder = expVector;
            return this.order;
        }
        this.order = this.truncate + 1;
        return this.order;
    }

    public ExpVector orderExpVector() {
        this.order();
        return this.evorder;
    }

    public Map.Entry<ExpVector, C> orderMonomial() {
        ExpVector expVector = this.orderExpVector();
        if (expVector == null) {
            return null;
        }
        return new MapEntry<ExpVector, C>(expVector, this.coefficient(expVector));
    }

    public int truncate() {
        return this.truncate;
    }

    public int setTruncate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative truncate not allowed");
        }
        int n2 = this.truncate;
        if (this.order >= 0 && this.order > this.truncate) {
            this.order = -1;
            this.evorder = null;
        }
        this.truncate = n;
        return n2;
    }

    public long ecart() {
        long l;
        ExpVector expVector = this.orderExpVector();
        if (expVector == null) {
            return 0L;
        }
        long l2 = l = expVector.totalDeg();
        for (long i = l + 1L; i <= (long)this.truncate; ++i) {
            if (this.homogeneousPart(i).isZERO()) continue;
            l2 = i;
        }
        return l2 - l;
    }

    @Override
    public int signum() {
        ExpVector expVector = this.orderExpVector();
        if (expVector != null) {
            return this.coefficient(expVector).signum();
        }
        return 0;
    }

    @Override
    public int compareTo(MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n = this.truncate();
        int n2 = multiVarPowerSeries.truncate();
        int n3 = Math.min(this.ring.truncate, Math.min(n, n2));
        int n4 = 0;
        for (Object object : new ExpVectorIterable(this.ring.nvar, true, n3)) {
            n4 = this.coefficient((ExpVector)object).compareTo(multiVarPowerSeries.coefficient((ExpVector)object));
            if (n4 == 0) continue;
            return n4;
        }
        for (int i = n3 + 1; i <= Math.min(this.ring.truncate, Math.max(n, n2)); ++i) {
            for (ExpVector expVector : new ExpVectorIterable(this.ring.nvar, i)) {
                n4 = this.coefficient(expVector).compareTo(multiVarPowerSeries.coefficient(expVector));
                if (n4 == 0) continue;
                return n4;
            }
        }
        return n4;
    }

    @Override
    public boolean isZERO() {
        return this.signum() == 0;
    }

    @Override
    public boolean isONE() {
        if (!this.leadingCoefficient().isONE()) {
            return false;
        }
        return this.compareTo(this.ring.ONE) == 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof MultiVarPowerSeries)) {
            return false;
        }
        MultiVarPowerSeries multiVarPowerSeries = (MultiVarPowerSeries)object;
        return this.compareTo(multiVarPowerSeries) == 0;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (ExpVector expVector : new ExpVectorIterable(this.ring.nvar, true, this.truncate)) {
            C c = this.coefficient(expVector);
            if (!c.isZERO()) {
                n += expVector.hashCode();
                n <<= 23;
            }
            n += c.hashCode();
            n <<= 23;
        }
        return n;
    }

    @Override
    public boolean isUnit() {
        return this.leadingCoefficient().isUnit();
    }

    @Override
    public MultiVarPowerSeries<C> sum(final MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n = Math.min(this.ring.truncate, Math.max(this.truncate(), multiVarPowerSeries.truncate()));
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                long l = expVector.totalDeg();
                if (MultiVarPowerSeries.this.lazyCoeffs.homCheck.get((int)l)) {
                    GenPolynomial genPolynomial = MultiVarPowerSeries.this.homogeneousPart(l).sum(multiVarPowerSeries.homogeneousPart(l));
                    this.coeffCache.put(l, genPolynomial);
                    this.homCheck.set((int)l);
                    GenPolynomial genPolynomial2 = genPolynomial.coefficient(expVector);
                    return genPolynomial2;
                }
                return (RingElem)MultiVarPowerSeries.this.coefficient(expVector).sum(multiVarPowerSeries.coefficient(expVector));
            }
        }, n);
    }

    @Override
    public MultiVarPowerSeries<C> subtract(final MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n = Math.min(this.ring.truncate, Math.max(this.truncate(), multiVarPowerSeries.truncate()));
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                long l = expVector.totalDeg();
                if (MultiVarPowerSeries.this.lazyCoeffs.homCheck.get((int)l)) {
                    GenPolynomial genPolynomial = MultiVarPowerSeries.this.homogeneousPart(l).subtract(multiVarPowerSeries.homogeneousPart(l));
                    this.coeffCache.put(l, genPolynomial);
                    this.homCheck.set((int)l);
                    GenPolynomial genPolynomial2 = genPolynomial.coefficient(expVector);
                    return genPolynomial2;
                }
                return (RingElem)MultiVarPowerSeries.this.coefficient(expVector).subtract(multiVarPowerSeries.coefficient(expVector));
            }
        }, n);
    }

    @Override
    public MultiVarPowerSeries<C> multiply(final MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n = Math.min(this.ring.truncate, this.truncate() + multiVarPowerSeries.truncate());
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                long l = expVector.totalDeg();
                GenPolynomial genPolynomial = null;
                int n = 0;
                while ((long)n <= l) {
                    GenPolynomial genPolynomial2 = MultiVarPowerSeries.this.homogeneousPart(n).multiply(multiVarPowerSeries.homogeneousPart(l - (long)n));
                    genPolynomial = genPolynomial == null ? genPolynomial2 : genPolynomial.sum(genPolynomial2);
                    ++n;
                }
                this.coeffCache.put(l, genPolynomial);
                this.homCheck.set((int)l);
                Object c = genPolynomial.coefficient(expVector);
                return c;
            }
        }, n);
    }

    @Override
    public MultiVarPowerSeries<C> inverse() {
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                long l = expVector.totalDeg();
                RingElem ringElem = (RingElem)MultiVarPowerSeries.this.leadingCoefficient().inverse();
                if (l == 0L) {
                    return ringElem;
                }
                GenPolynomial<RingElem> genPolynomial = null;
                int n = 0;
                while ((long)n < l) {
                    GenPolynomial<GenPolynomial<RingElem>> genPolynomial2 = this.getHomPart(n).multiply(MultiVarPowerSeries.this.homogeneousPart(l - (long)n));
                    genPolynomial = genPolynomial == null ? genPolynomial2 : genPolynomial.sum(genPolynomial2);
                    ++n;
                }
                genPolynomial = genPolynomial.multiply((RingElem)ringElem.negate());
                this.coeffCache.put(l, genPolynomial);
                this.homCheck.set((int)l);
                RingElem ringElem2 = genPolynomial.coefficient(expVector);
                return ringElem2;
            }
        });
    }

    @Override
    public MultiVarPowerSeries<C> divide(MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n;
        if (multiVarPowerSeries.isUnit()) {
            return this.multiply((MultiVarPowerSeries<C>)multiVarPowerSeries.inverse());
        }
        int n2 = this.order();
        if (n2 < (n = multiVarPowerSeries.order())) {
            return this.ring.getZERO();
        }
        ExpVector expVector = this.orderExpVector();
        ExpVector expVector2 = multiVarPowerSeries.orderExpVector();
        if (!multiVarPowerSeries.coefficient(expVector2).isUnit()) {
            throw new ArithmeticException("division by non unit coefficient " + multiVarPowerSeries.coefficient(multiVarPowerSeries.evorder) + ", evorder = " + multiVarPowerSeries.evorder);
        }
        MultiVarPowerSeries<C> multiVarPowerSeries2 = n2 == 0 ? this : this.shift(expVector.negate());
        MultiVarPowerSeries<C> multiVarPowerSeries3 = n == 0 ? multiVarPowerSeries : multiVarPowerSeries.shift(expVector2.negate());
        MultiVarPowerSeries<C> multiVarPowerSeries4 = multiVarPowerSeries2.multiply((MultiVarPowerSeries<C>)multiVarPowerSeries3.inverse());
        MultiVarPowerSeries<C> multiVarPowerSeries5 = multiVarPowerSeries4.shift(expVector.subtract(expVector2));
        return multiVarPowerSeries5;
    }

    @Override
    public MultiVarPowerSeries<C> remainder(MultiVarPowerSeries<C> multiVarPowerSeries) {
        int n;
        int n2 = this.order();
        if (n2 >= (n = multiVarPowerSeries.order())) {
            return this.ring.getZERO();
        }
        return this;
    }

    public MultiVarPowerSeries<C>[] quotientRemainder(MultiVarPowerSeries<C> multiVarPowerSeries) {
        return new MultiVarPowerSeries[]{this.divide(multiVarPowerSeries), this.remainder(multiVarPowerSeries)};
    }

    public MultiVarPowerSeries<C> differentiate(final int n) {
        if (n < 0 || this.ring.nvar < n) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring){

            @Override
            public C generate(ExpVector expVector) {
                long l = expVector.getVal(n);
                ExpVector expVector2 = expVector.subst(n, l + 1L);
                RingElem ringElem = MultiVarPowerSeries.this.coefficient(expVector2);
                ringElem = ringElem.multiply((RingElem)((RingElem)MultiVarPowerSeries.this.ring.coFac.fromInteger(l + 1L)));
                return ringElem;
            }
        });
    }

    public MultiVarPowerSeries<C> integrate(C c, int n) {
        if (n < 0 || this.ring.nvar < n) {
            throw new IllegalArgumentException("variable index out of bound");
        }
        int n2 = Math.min(this.ring.truncate, this.truncate + 1);
        return new MultiVarPowerSeries<C>(this.ring, new MultiVarCoefficients<C>(this.ring, (RingElem)c, n){
            final /* synthetic */ RingElem val$c;
            final /* synthetic */ int val$r;
            {
                this.val$c = ringElem;
                this.val$r = n;
                super(multiVarPowerSeriesRing);
            }

            @Override
            public C generate(ExpVector expVector) {
                if (expVector.isZERO()) {
                    return this.val$c;
                }
                long l = expVector.getVal(this.val$r);
                if (l > 0L) {
                    ExpVector expVector2 = expVector.subst(this.val$r, l - 1L);
                    RingElem ringElem = MultiVarPowerSeries.this.coefficient(expVector2);
                    ringElem = ringElem.divide((RingElem)((RingElem)MultiVarPowerSeries.this.ring.coFac.fromInteger(l)));
                    return ringElem;
                }
                return (RingElem)MultiVarPowerSeries.this.ring.coFac.getZERO();
            }
        }, n2);
    }

    @Override
    public MultiVarPowerSeries<C> gcd(MultiVarPowerSeries<C> multiVarPowerSeries) {
        if (multiVarPowerSeries.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return multiVarPowerSeries;
        }
        ExpVector expVector = this.orderExpVector();
        ExpVector expVector2 = multiVarPowerSeries.orderExpVector();
        return ((MultiVarPowerSeries)this.ring.getONE()).shift(expVector.gcd(expVector2));
    }

    public MultiVarPowerSeries<C>[] egcd(MultiVarPowerSeries<C> multiVarPowerSeries) {
        throw new UnsupportedOperationException("egcd for power series not implemented");
    }
}

