/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.ModulElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenVectorTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenVectorTest.suite());
    }

    public GenVectorTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenVectorTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testPolynomialConstruction() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(genPolynomialRing, this.ll);
        GenVectorTest.assertTrue((String)("#columns = " + this.ll), (genVectorModul.cols == this.ll ? 1 : 0) != 0);
        GenVectorTest.assertTrue((String)"pfac == coFac ", (genPolynomialRing == genVectorModul.coFac ? 1 : 0) != 0);
        AbelianGroupElem abelianGroupElem = genVectorModul.getZERO();
        GenVectorTest.assertTrue((String)"isZERO( a )", (boolean)((GenVector)abelianGroupElem).isZERO());
        GenVector<BigRational> genVector = new GenVector<BigRational>(genVectorModul);
        GenVectorTest.assertTrue((String)"isZERO( b )", (boolean)genVector.isZERO());
        GenVectorTest.assertTrue((String)"a == b ", (boolean)((GenVector)abelianGroupElem).equals(genVector));
        Element element = genVector.copy();
        GenVectorTest.assertTrue((String)"isZERO( c )", (boolean)((GenVector)element).isZERO());
        GenVectorTest.assertTrue((String)"a == c ", (boolean)((GenVector)abelianGroupElem).equals(element));
        GenVector<BigRational> genVector2 = genVectorModul.copy(genVector);
        GenVectorTest.assertTrue((String)"isZERO( d )", (boolean)genVector2.isZERO());
        GenVectorTest.assertTrue((String)"a == d ", (boolean)((GenVector)abelianGroupElem).equals(genVector2));
    }

    public void testPolynomialRandom() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(genPolynomialRing, this.ll);
        for (int i = 0; i < 7; ++i) {
            ModulElem modulElem = genVectorModul.random(this.kl, this.q);
            GenVectorTest.assertTrue((String)(" not isZERO( " + (GenVector)modulElem + " )"), (!((GenVector)modulElem).isZERO() ? 1 : 0) != 0);
        }
    }

    public void testPolynomialAddition() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(genPolynomialRing, this.ll);
        ModulElem modulElem = genVectorModul.random(this.kl, this.q);
        ModulElem modulElem2 = genVectorModul.random(this.kl, this.q);
        ModulElem modulElem3 = ((GenVector)modulElem).sum(modulElem2);
        GenVector genVector = modulElem3.subtract(modulElem2);
        GenVectorTest.assertEquals((String)"a+b-b = a", (Object)modulElem, genVector);
        modulElem3 = ((GenVector)modulElem).sum(modulElem2);
        genVector = modulElem3.sum(((GenVector)modulElem2).negate());
        GenVectorTest.assertEquals((String)"a+b+(-b) = a", (Object)modulElem, genVector);
        modulElem3 = ((GenVector)modulElem).sum(modulElem2);
        genVector = ((GenVector)modulElem2).sum(modulElem);
        GenVectorTest.assertEquals((String)"a+b = b+a", modulElem3, genVector);
        modulElem3 = genVectorModul.random(this.kl, this.q);
        genVector = ((GenVector)modulElem).sum(modulElem2).sum(modulElem3);
        GenVector genVector2 = ((GenVector)modulElem).sum(((GenVector)modulElem2).sum(modulElem3));
        GenVectorTest.assertEquals((String)"a+(b+c) = (a+b)+c", genVector, genVector2);
    }

    public void testPolynomialMultiplication() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(genPolynomialRing, this.ll);
        Element element = genPolynomialRing.random(this.kl);
        AbelianGroupElem abelianGroupElem = ((GenPolynomial)element).negate();
        ModulElem modulElem = genVectorModul.random(this.kl, this.q);
        GenVector<MonoidElem> genVector = ((GenVector)modulElem).scalarMultiply((RingElem)element);
        GenVector genVector2 = ((GenVector)modulElem).scalarMultiply((RingElem)abelianGroupElem);
        GenVector genVector3 = genVector.sum(genVector2);
        GenVectorTest.assertEquals((String)"a*b + a*(-b) = 0", genVector3, (Object)genVectorModul.getZERO());
        ModulElem modulElem2 = genVectorModul.random(this.kl, this.q);
        Element element2 = genPolynomialRing.getONE();
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, element2);
        genVector2 = ((GenVector)modulElem2).linearCombination(modulElem, element2);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", genVector, genVector2);
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, element2);
        genVector2 = ((GenVector)modulElem).sum(modulElem2);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", genVector, genVector2);
        abelianGroupElem = ((GenPolynomial)element2).negate();
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, element2);
        genVector2 = genVector.linearCombination((GenVector<MonoidElem>)modulElem2, (MonoidElem)((Object)abelianGroupElem));
        GenVectorTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)modulElem, genVector2);
        genVector = ((GenVector)modulElem).linearCombination(element2, modulElem2, element2);
        genVector2 = genVector.linearCombination((MonoidElem)element2, (GenVector<MonoidElem>)modulElem2, (MonoidElem)((Object)abelianGroupElem));
        GenVectorTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)modulElem, genVector2);
        element2 = genPolynomialRing.getZERO();
        genVector = ((GenVector)modulElem).linearCombination(modulElem2, element2);
        GenVectorTest.assertEquals((String)"a+0*b = a", (Object)modulElem, genVector);
        genVector2 = ((GenVector)modulElem).linearCombination(element2, modulElem2, element2);
        GenVectorTest.assertEquals((String)"0*a+0*b = 0", (Object)genVectorModul.getZERO(), genVector2);
        element = (GenPolynomial)((GenVector)modulElem).scalarProduct(modulElem2);
        abelianGroupElem = (GenPolynomial)((GenVector)modulElem2).scalarProduct(modulElem);
        GenVectorTest.assertEquals((String)"a.b = b.a", (Object)element, (Object)abelianGroupElem);
    }
}

