/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.List;

public final class ExpVectorByte
extends ExpVector {
    final byte[] val;
    public static final long maxByte = 63L;
    public static final long minByte = -64L;

    public ExpVectorByte(int n) {
        this(new byte[n]);
    }

    public ExpVectorByte(int n, int n2, byte by) {
        this(n);
        this.val[n2] = by;
    }

    public ExpVectorByte(int n, int n2, long l) {
        this(n);
        if (l >= 63L || l <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        this.val[n2] = (byte)l;
    }

    protected ExpVectorByte(byte[] byArray) {
        this.val = byArray;
    }

    public ExpVectorByte(long[] lArray) {
        this(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 63L || lArray[i] <= -64L) {
                throw new IllegalArgumentException("exponent to large: " + lArray[i]);
            }
            this.val[i] = (byte)lArray[i];
        }
    }

    public ExpVectorByte(String string) throws NumberFormatException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        string = string.trim();
        int n = string.indexOf(40);
        int n2 = string.indexOf(41, n + 1);
        if (n >= 0 && n2 >= 0) {
            byte by;
            String string2;
            int n3;
            ++n;
            while ((n3 = string.indexOf(44, n)) >= 0) {
                string2 = string.substring(n, n3);
                by = Byte.parseByte(string2);
                arrayList.add(by);
                n = n3 + 1;
            }
            if (n <= n2) {
                string2 = string.substring(n, n2);
                by = Byte.parseByte(string2);
                arrayList.add(by);
            }
            int n4 = arrayList.size();
            this.val = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                this.val[i] = (Byte)arrayList.get(i);
            }
        } else {
            this.val = null;
        }
    }

    @Override
    public ExpVectorByte copy() {
        byte[] byArray = new byte[this.val.length];
        System.arraycopy(this.val, 0, byArray, 0, this.val.length);
        return new ExpVectorByte(byArray);
    }

    @Override
    public long[] getVal() {
        long[] lArray = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            lArray[i] = this.val[i];
        }
        return lArray;
    }

    @Override
    public long getVal(int n) {
        return this.val[n];
    }

    @Override
    protected long setVal(int n, long l) {
        byte by = this.val[n];
        if (l >= 63L || l <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        this.val[n] = (byte)l;
        this.hash = 0;
        return by;
    }

    protected byte setVal(int n, byte by) {
        byte by2 = this.val[n];
        this.val[n] = by;
        this.hash = 0;
        return by2;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorByte extend(int n, int n2, long l) {
        byte[] byArray = new byte[this.val.length + n];
        System.arraycopy(this.val, 0, byArray, n, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        if (l >= 63L || l <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + l);
        }
        byArray[n2] = (byte)l;
        return new ExpVectorByte(byArray);
    }

    @Override
    public ExpVectorByte extendLower(int n, int n2, long l) {
        byte[] byArray = new byte[this.val.length + n];
        System.arraycopy(this.val, 0, byArray, 0, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        byArray[this.val.length + n2] = (byte)l;
        return new ExpVectorByte(byArray);
    }

    @Override
    public ExpVectorByte contract(int n, int n2) {
        if (n + n2 > this.val.length) {
            throw new IllegalArgumentException("len " + n2 + " > val.len " + this.val.length);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.val, n, byArray, 0, n2);
        return new ExpVectorByte(byArray);
    }

    @Override
    public ExpVectorByte reverse() {
        byte[] byArray = new byte[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            byArray[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorByte(byArray);
    }

    @Override
    public ExpVectorByte reverse(int n) {
        int n2;
        if (n <= 0 || n > this.val.length) {
            return this;
        }
        byte[] byArray = new byte[this.val.length];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = this.val[n2];
        }
        for (n2 = n; n2 < this.val.length; ++n2) {
            byArray[n2] = this.val[this.val.length + n - 1 - n2];
        }
        return new ExpVectorByte(byArray);
    }

    @Override
    public ExpVectorByte combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorByte expVectorByte = (ExpVectorByte)expVector;
        if (this.val.length == 0) {
            return expVectorByte;
        }
        byte[] byArray = new byte[this.val.length + expVectorByte.val.length];
        System.arraycopy(this.val, 0, byArray, 0, this.val.length);
        System.arraycopy(expVectorByte.val, 0, byArray, this.val.length, expVectorByte.val.length);
        return new ExpVectorByte(byArray);
    }

    @Override
    public ExpVectorByte permutation(List<Integer> list) {
        byte[] byArray = new byte[this.val.length];
        int n = 0;
        for (Integer n2 : list) {
            byArray[n++] = this.val[n2];
        }
        return new ExpVectorByte(byArray);
    }

    @Override
    public String toString() {
        return super.toString() + ":byte";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorByte)) {
            return false;
        }
        ExpVectorByte expVectorByte = (ExpVectorByte)object;
        int n = this.invLexCompareTo(expVectorByte);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ExpVectorByte abs() {
        byte[] byArray = this.val;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (long)byArray[i] >= 0L ? byArray[i] : (byte)(-byArray[i]);
        }
        return new ExpVectorByte(byArray2);
    }

    @Override
    public ExpVectorByte negate() {
        byte[] byArray = this.val;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = -byArray[i];
        }
        return new ExpVectorByte(byArray2);
    }

    @Override
    public ExpVectorByte sum(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] + byArray2[i]);
        }
        return new ExpVectorByte(byArray3);
    }

    @Override
    public ExpVectorByte subtract(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] - byArray2[i]);
        }
        return new ExpVectorByte(byArray3);
    }

    @Override
    public ExpVectorByte scalarMultiply(long l) {
        if (l >= 63L || l <= -64L) {
            throw new IllegalArgumentException("scalar to large: " + l);
        }
        byte[] byArray = this.val;
        byte[] byArray2 = new byte[byArray.length];
        byte by = (byte)l;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(by * byArray[i]);
        }
        return new ExpVectorByte(byArray2);
    }

    public ExpVectorByte subst(int n, byte by) {
        ExpVectorByte expVectorByte = this.copy();
        expVectorByte.setVal(n, by);
        return expVectorByte;
    }

    @Override
    public ExpVectorByte subst(int n, long l) {
        ExpVectorByte expVectorByte = this.copy();
        expVectorByte.setVal(n, l);
        return expVectorByte;
    }

    @Override
    public int signum() {
        int n = 0;
        byte[] byArray = this.val;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] < 0) {
                return -1;
            }
            if (byArray[i] <= 0) continue;
            n = 1;
        }
        return n;
    }

    @Override
    public long totalDeg() {
        long l = 0L;
        byte[] byArray = this.val;
        for (int i = 0; i < byArray.length; ++i) {
            l += (long)byArray[i];
        }
        return l;
    }

    @Override
    public long maxDeg() {
        long l = 0L;
        byte[] byArray = this.val;
        for (int i = 0; i < byArray.length; ++i) {
            if ((long)byArray[i] <= l) continue;
            l = byArray[i];
        }
        return l;
    }

    @Override
    public long minDeg() {
        long l = 127L;
        byte[] byArray = this.val;
        for (int i = 0; i < byArray.length; ++i) {
            if ((long)byArray[i] >= l) continue;
            l = byArray[i];
        }
        return l;
    }

    @Override
    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l = 0L;
        byte[] byArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            for (int j = 0; j < byArray.length; ++j) {
                l += lArray2[j] * (long)byArray[j];
            }
        }
        return l;
    }

    @Override
    public long weightDeg(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l = 0L;
        byte[] byArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i] * (long)byArray[i];
        }
        return l;
    }

    @Override
    public ExpVectorByte lcm(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = byArray[i] >= byArray2[i] ? byArray[i] : byArray2[i];
        }
        return new ExpVectorByte(byArray3);
    }

    @Override
    public ExpVectorByte gcd(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = byArray[i] <= byArray2[i] ? byArray[i] : byArray2[i];
        }
        return new ExpVectorByte(byArray3);
    }

    @Override
    public int dependentVariables() {
        int n = 0;
        for (int i = 0; i < this.val.length; ++i) {
            if (this.val[i] <= 0) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int[] dependencyOnVariables() {
        byte[] byArray = this.val;
        int n = this.dependentVariables();
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    @Override
    public boolean multipleOf(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= byArray2[i]) continue;
            return false;
        }
        return bl;
    }

    @Override
    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    @Override
    public int invLexCompareTo(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invLexCompareTo(ExpVector expVector, int n, int n2) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] > byArray2[i]) {
                n = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < byArray.length; ++i) {
            l += (long)byArray[i];
            l2 += (long)byArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector, int n, int n2) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] > byArray2[i]) {
                n3 = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < n2; ++i) {
            l += (long)byArray[i];
            l2 += (long)byArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector, int n, int n2) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] > byArray2[i]) {
                n = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= 0; --i) {
            l += (long)byArray[i];
            l2 += (long)byArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector, int n, int n2) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (byArray[i] > byArray2[i]) {
                n3 = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= n; --i) {
            l += (long)byArray[i];
            l2 += (long)byArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int invTdegCompareTo(ExpVector expVector) {
        throw new UnsupportedOperationException("not implemented for byte ExpVector");
    }

    @Override
    public int revLexInvTdegCompareTo(ExpVector expVector) {
        throw new UnsupportedOperationException("not implemented for byte ExpVector");
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] > byArray2[i]) {
                n = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < byArray.length; ++j) {
                l += lArray2[j] * (long)byArray[j];
                l2 += lArray2[j] * (long)byArray2[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n, int n2) {
        byte[] byArray = this.val;
        byte[] byArray2 = ((ExpVectorByte)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] > byArray2[i]) {
                n3 = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < n2; ++j) {
                l += lArray2[j] * (long)byArray[j];
                l2 += lArray2[j] * (long)byArray2[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n3;
    }
}

