/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PseudoReducerRec<C extends GcdRingElem<C>>
implements Runnable {
    private final List<GenPolynomial<GenPolynomial<C>>> G;
    private final PairList<GenPolynomial<C>> pairlist;
    private final Terminator fin;
    private final PseudoReductionPar<GenPolynomial<C>> red;
    private final PseudoReductionPar<C> redRec;
    private final GreatestCommonDivisorAbstract<C> engine;
    private static final Logger logger = LogManager.getLogger(PseudoReducerRec.class);

    PseudoReducerRec(Terminator terminator, List<GenPolynomial<GenPolynomial<C>>> list, PairList<GenPolynomial<C>> pairList, GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract) {
        this.fin = terminator;
        this.G = list;
        this.pairlist = pairList;
        this.red = new PseudoReductionPar();
        this.redRec = new PseudoReductionPar();
        this.engine = greatestCommonDivisorAbstract;
        terminator.initIdle(1);
    }

    public String toString() {
        return "PseudoReducer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        while (this.pairlist.hasNext() || this.fin.hasJobs()) {
            List<GenPolynomial<GenPolynomial<C>>> list;
            GenPolynomial genPolynomial;
            while (!this.pairlist.hasNext()) {
                try {
                    if (++n2 % 10 == 0) {
                        logger.info(" reducer is sleeping");
                    } else {
                        logger.debug("r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (this.fin.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.fin.hasJobs()) break;
            this.fin.notIdle();
            Pair<GenPolynomial<C>> pair = this.pairlist.removeNext();
            if (Thread.currentThread().isInterrupted()) {
                this.fin.initIdle(1);
                throw new RuntimeException("interrupt after removeNext");
            }
            if (pair == null) {
                this.fin.initIdle(1);
                continue;
            }
            GenPolynomial genPolynomial2 = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.debug("pi    = " + genPolynomial2);
                logger.debug("pj    = " + genPolynomial3);
            }
            if ((genPolynomial = this.red.SPolynomial(genPolynomial2, genPolynomial3)).isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(S) = " + genPolynomial.leadingExpVector());
            }
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = this.redRec.normalformRecursive(this.G, genPolynomial);
            ++n;
            if (((GenPolynomial)abelianGroupElem).isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.info("ht(H) = " + ((GenPolynomial)abelianGroupElem).leadingExpVector());
            }
            abelianGroupElem = this.engine.recursivePrimitivePart((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            if (((GenPolynomial)(abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs())).isONE()) {
                this.pairlist.put((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)abelianGroupElem);
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
                }
                this.fin.allIdle();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("H = " + abelianGroupElem);
            }
            list = this.G;
            synchronized (list) {
                this.G.add((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            }
            this.pairlist.put((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)abelianGroupElem);
            this.fin.initIdle(1);
        }
        this.fin.allIdle();
        logger.info("terminated, done " + n + " reductions");
    }
}

