/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.SigPair;
import edu.jas.gb.SigPoly;
import edu.jas.gb.SigReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseSigSeqIter<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseSigSeqIter.class);
    private static final boolean debug = logger.isDebugEnabled();
    final SigReductionSeq<C> sred;

    public GroebnerBaseSigSeqIter() {
        this(new SigReductionSeq());
    }

    public GroebnerBaseSigSeqIter(SigReductionSeq<C> sigReductionSeq) {
        this.sred = sigReductionSeq;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        list2 = OrderedPolynomialList.sortDegree(list2);
        logger.info("G-sort = " + list2);
        List<GenPolynomial<C>> list3 = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list2) {
            GenPolynomial<C> genPolynomial2;
            if (logger.isInfoEnabled()) {
                logger.info("p = " + genPolynomial);
            }
            if ((genPolynomial2 = this.red.normalform(list3, genPolynomial)).isZERO() || (list3 = this.GB(n, list3, genPolynomial)).size() <= 0 || !list3.get(0).isONE()) continue;
            return list3;
        }
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        List<SigPair<C>>[] listArray;
        void var9_11;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (arrayList.isEmpty()) {
            arrayList.add(genPolynomial2);
            return arrayList;
        }
        if (genPolynomial2.isZERO()) {
            return arrayList;
        }
        if (genPolynomial2.isONE()) {
            arrayList.clear();
            arrayList.add(genPolynomial2);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = ((GenPolynomial)arrayList.get((int)0)).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        if (n != 0) {
            throw new UnsupportedOperationException("motv != 0 not implemented");
        }
        ArrayList<SigPoly<C>> arrayList2 = new ArrayList<SigPoly<C>>();
        for (GenPolynomial iterable2 : arrayList) {
            arrayList2.add(new SigPoly(genPolynomialRing.getZERO(), iterable2));
        }
        SigPoly<C> sigPoly = new SigPoly<C>(genPolynomialRing.getONE(), genPolynomial2);
        arrayList2.add(sigPoly);
        ArrayList<SigPair<C>> arrayList3 = new ArrayList<SigPair<C>>();
        for (SigPoly sigPoly2 : arrayList2) {
            if (sigPoly2.poly.equals(genPolynomial2)) continue;
            arrayList3.add(this.newPair(sigPoly, sigPoly2, arrayList2));
        }
        logger.info("start " + arrayList2);
        List<ExpVector> list2 = this.initializeSyz(arrayList, arrayList2);
        ArrayList<SigPoly<C>> arrayList4 = new ArrayList<SigPoly<C>>();
        while (!var9_11.isEmpty()) {
            List<SigPair<C>> list3 = this.pruneP((List<SigPair<C>>)var9_11, list2);
            if (list3.isEmpty()) continue;
            listArray = this.sred.minDegSubset(list3);
            List<SigPair<C>> list4 = listArray[0];
            long l = this.sred.minimalSigDegree(list4);
            List<SigPair<C>> list5 = listArray[1];
            logger.info("treating " + list4.size() + " signatures of degree " + l);
            while (!list4.isEmpty()) {
                SigPair<C> sigPair;
                if ((list4 = this.pruneS(list4, list2, arrayList4, arrayList2)).isEmpty() || (sigPair = (list4 = this.sred.sortSigma(list4)).remove(0)) == null) continue;
                GenPolynomial<C> genPolynomial3 = this.SPolynomial(sigPair);
                SigPoly sigPoly3 = new SigPoly(sigPair.sigma, genPolynomial3);
                if (genPolynomial3.isZERO()) {
                    this.updateSyz(list2, sigPoly3);
                    arrayList4.add(sigPoly3);
                    continue;
                }
                if (debug) {
                    logger.debug("ht(S) = " + genPolynomial3.leadingExpVector());
                }
                SigPoly<C> sigPoly4 = this.sigNormalform(arrayList, arrayList2, sigPoly3);
                GenPolynomial genPolynomial4 = sigPoly4.poly;
                GenPolynomial<GenPolynomial<C>> genPolynomial5 = sigPoly4.sigma;
                if (debug) {
                    logger.info("new polynomial = " + sigPoly4);
                }
                if (genPolynomial4.isZERO()) {
                    this.updateSyz(list2, sigPoly4);
                    arrayList4.add(sigPoly4);
                    continue;
                }
                genPolynomial4 = genPolynomial4.monic();
                if (debug) {
                    logger.info("ht(H) = " + genPolynomial4.leadingExpVector());
                }
                if (genPolynomial4.isONE()) {
                    list.clear();
                    list.add(genPolynomial4);
                    logger.info("end " + list5);
                    return list;
                }
                if (this.sred.isSigRedundant(arrayList2, sigPoly4)) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("sigma::h = " + genPolynomial5 + " :: " + genPolynomial4.leadingExpVector());
                }
                if (genPolynomial4.length() <= 0) continue;
                for (SigPoly sigPoly5 : arrayList2) {
                    if (sigPoly5.poly.isZERO()) continue;
                    GenPolynomial<GenPolynomial<C>> genPolynomial6 = sigPoly5.sigma;
                    GenPolynomial<C>[] genPolynomialArray = this.SPolynomialFactors(sigPoly4, sigPoly5);
                    ExpVector expVector = genPolynomial5.leadingExpVector();
                    ExpVector expVector2 = genPolynomial6.leadingExpVector();
                    if (genPolynomialArray[0].multiply(expVector).equals(genPolynomialArray[1].multiply(expVector2))) continue;
                    SigPair<GenPolynomial<Object>> sigPair2 = genPolynomialArray[0].multiply(expVector).compareTo(genPolynomialArray[1].multiply(expVector2)) > 0 ? this.newPair(genPolynomial5.multiply(genPolynomialArray[0]), sigPoly4, sigPoly5, arrayList2) : this.newPair(genPolynomial6.multiply(genPolynomialArray[1]), sigPoly5, sigPoly4, arrayList2);
                    if (sigPair2.sigma.degree() == l) {
                        list4.add(sigPair2);
                        continue;
                    }
                    list5.add(sigPair2);
                }
                arrayList2.add(sigPoly4);
                arrayList4.add(sigPoly4);
            }
        }
        logger.info("#sequential list before reduction = " + arrayList2.size());
        listArray = this.sred.polys(arrayList2);
        list = this.minimalGB(listArray);
        logger.info("end " + (List)var9_11);
        return list;
    }

    GenPolynomial<C> SPolynomial(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        return this.sred.SPolynomial(sigPoly, sigPoly2);
    }

    GenPolynomial<C> SPolynomial(SigPair<C> sigPair) {
        return this.sred.SPolynomial(sigPair.pi, sigPair.pj);
    }

    GenPolynomial<C>[] SPolynomialFactors(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        return this.sred.SPolynomialFactors(sigPoly, sigPoly2);
    }

    SigPair<C> newPair(SigPoly<C> sigPoly, SigPoly<C> sigPoly2, List<SigPoly<C>> list) {
        ExpVector expVector = sigPoly.poly.leadingExpVector().lcm(sigPoly2.poly.leadingExpVector()).subtract(sigPoly.poly.leadingExpVector());
        return new SigPair<C>(expVector, sigPoly, sigPoly2, list);
    }

    SigPair<C> newPair(GenPolynomial<C> genPolynomial, SigPoly<C> sigPoly, SigPoly<C> sigPoly2, List<SigPoly<C>> list) {
        return new SigPair<C>(genPolynomial, sigPoly, sigPoly2, list);
    }

    SigPoly<C> sigNormalform(List<GenPolynomial<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        return this.sred.sigNormalform(list, list2, sigPoly);
    }

    List<SigPair<C>> pruneP(List<SigPair<C>> list, List<ExpVector> list2) {
        if (debug) {
            logger.debug("unused " + list2);
        }
        return list;
    }

    List<SigPair<C>> pruneS(List<SigPair<C>> list, List<ExpVector> list2, List<SigPoly<C>> list3, List<SigPoly<C>> list4) {
        if (debug) {
            logger.debug("unused " + list2 + " " + list3 + " " + list4);
        }
        return list;
    }

    List<ExpVector> initializeSyz(List<GenPolynomial<C>> list, List<SigPoly<C>> list2) {
        if (debug) {
            logger.debug("unused " + list2 + " " + list);
        }
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>();
        return arrayList;
    }

    void updateSyz(List<ExpVector> list, SigPoly<C> sigPoly) {
        if (debug) {
            logger.debug("unused " + list + " " + sigPoly);
        }
    }
}

