/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.fd.GreatestCommonDivisorSyzygy;
import edu.jas.fd.SGCDParallelProxy;
import edu.jas.kern.ComputerThreads;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGCDFactory {
    private static final Logger logger = LogManager.getLogger(SGCDFactory.class);

    protected SGCDFactory() {
    }

    public static GreatestCommonDivisorAbstract<ModLong> getImplementation(ModLongRing modLongRing) {
        if (modLongRing.isField()) {
            GreatestCommonDivisorSimple<ModLong> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<ModLong>(modLongRing);
            return greatestCommonDivisorSimple;
        }
        GreatestCommonDivisorPrimitive<ModLong> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<ModLong>(modLongRing);
        return greatestCommonDivisorPrimitive;
    }

    public static GreatestCommonDivisorAbstract<ModLong> getProxy(ModLongRing modLongRing) {
        GreatestCommonDivisorPrimitive<ModLong> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<ModLong>(modLongRing);
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = modLongRing.isField() ? new GreatestCommonDivisorSimple<ModLong>(modLongRing) : new GreatestCommonDivisorSyzygy<ModLong>(modLongRing);
        return new SGCDParallelProxy<ModLong>(modLongRing, greatestCommonDivisorPrimitive, greatestCommonDivisorAbstract);
    }

    public static GreatestCommonDivisorAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing) {
        if (modIntegerRing.isField()) {
            GreatestCommonDivisorSimple<ModInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<ModInteger>(modIntegerRing);
            return greatestCommonDivisorSimple;
        }
        GreatestCommonDivisorPrimitive<ModInteger> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<ModInteger>(modIntegerRing);
        return greatestCommonDivisorPrimitive;
    }

    public static GreatestCommonDivisorAbstract<ModInteger> getProxy(ModIntegerRing modIntegerRing) {
        GreatestCommonDivisorPrimitive<ModInteger> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<ModInteger>(modIntegerRing);
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = modIntegerRing.isField() ? new GreatestCommonDivisorSimple<ModInteger>(modIntegerRing) : new GreatestCommonDivisorSyzygy<ModInteger>(modIntegerRing);
        return new SGCDParallelProxy<ModInteger>(modIntegerRing, greatestCommonDivisorPrimitive, greatestCommonDivisorAbstract);
    }

    public static GreatestCommonDivisorAbstract<BigInteger> getImplementation(BigInteger bigInteger) {
        GreatestCommonDivisorPrimitive<BigInteger> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<BigInteger>(bigInteger);
        return greatestCommonDivisorPrimitive;
    }

    public static GreatestCommonDivisorAbstract<BigInteger> getProxy(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("fac == null not supported");
        }
        GreatestCommonDivisorPrimitive<BigInteger> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<BigInteger>(bigInteger);
        GreatestCommonDivisorSyzygy<BigInteger> greatestCommonDivisorSyzygy = new GreatestCommonDivisorSyzygy<BigInteger>(bigInteger);
        return new SGCDParallelProxy<BigInteger>(bigInteger, greatestCommonDivisorPrimitive, greatestCommonDivisorSyzygy);
    }

    public static GreatestCommonDivisorAbstract<BigRational> getImplementation(BigRational bigRational) {
        if (bigRational == null) {
            throw new IllegalArgumentException("fac == null not supported");
        }
        GreatestCommonDivisorPrimitive<BigRational> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<BigRational>(bigRational);
        return greatestCommonDivisorPrimitive;
    }

    public static GreatestCommonDivisorAbstract<BigRational> getProxy(BigRational bigRational) {
        if (bigRational == null) {
            throw new IllegalArgumentException("fac == null not supported");
        }
        GreatestCommonDivisorPrimitive<BigRational> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<BigRational>(bigRational);
        GreatestCommonDivisorSimple<BigRational> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<BigRational>(bigRational);
        return new SGCDParallelProxy<BigRational>(bigRational, greatestCommonDivisorPrimitive, greatestCommonDivisorSimple);
    }

    public static <C extends GcdRingElem<C>> GreatestCommonDivisorAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        logger.debug("fac = " + ringFactory.getClass().getName());
        RingFactory<C> ringFactory2 = ringFactory;
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = ringFactory2 instanceof BigInteger ? new GreatestCommonDivisorPrimitive<C>(ringFactory) : (ringFactory2 instanceof ModIntegerRing ? (ringFactory.isField() ? new GreatestCommonDivisorSimple<C>(ringFactory) : new GreatestCommonDivisorPrimitive<C>(ringFactory)) : (ringFactory2 instanceof ModLongRing ? (ringFactory.isField() ? new GreatestCommonDivisorSimple<C>(ringFactory) : new GreatestCommonDivisorPrimitive<C>(ringFactory)) : (ringFactory2 instanceof BigRational ? new GreatestCommonDivisorSimple<C>(ringFactory) : (ringFactory.isField() ? new GreatestCommonDivisorSimple<C>(ringFactory) : new GreatestCommonDivisorPrimitive<C>(ringFactory)))));
        logger.debug("implementation = " + greatestCommonDivisorAbstract);
        return greatestCommonDivisorAbstract;
    }

    public static <C extends GcdRingElem<C>> GreatestCommonDivisorAbstract<C> getProxy(RingFactory<C> ringFactory) {
        if (ComputerThreads.NO_THREADS) {
            return SGCDFactory.getImplementation(ringFactory);
        }
        logger.debug("fac = " + ringFactory.getClass().getName());
        RingFactory<C> ringFactory2 = ringFactory;
        SGCDParallelProxy<C> sGCDParallelProxy = ringFactory2 instanceof BigInteger ? new SGCDParallelProxy<C>(ringFactory, new GreatestCommonDivisorSimple<C>(ringFactory), new GreatestCommonDivisorPrimitive<C>(ringFactory)) : (ringFactory2 instanceof ModIntegerRing ? new SGCDParallelProxy<C>(ringFactory, new GreatestCommonDivisorSimple<C>(ringFactory), new GreatestCommonDivisorPrimitive<C>(ringFactory)) : (ringFactory2 instanceof ModLongRing ? new SGCDParallelProxy<C>(ringFactory, new GreatestCommonDivisorSimple<C>(ringFactory), new GreatestCommonDivisorPrimitive<C>(ringFactory)) : (ringFactory2 instanceof BigRational ? new SGCDParallelProxy<C>(ringFactory, new GreatestCommonDivisorPrimitive<C>(ringFactory), new GreatestCommonDivisorSimple<C>(ringFactory)) : (ringFactory.isField() ? new SGCDParallelProxy<C>(ringFactory, new GreatestCommonDivisorSimple<C>(ringFactory), new GreatestCommonDivisorPrimitive<C>(ringFactory)) : new SGCDParallelProxy<C>(ringFactory, new GreatestCommonDivisorSyzygy<C>(ringFactory), new GreatestCommonDivisorPrimitive<C>(ringFactory))))));
        logger.debug("ufd = " + sGCDParallelProxy);
        return sGCDParallelProxy;
    }
}

