/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModularNotInvertibleException;
import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModIntTest
extends TestCase {
    ModIntRing zm;
    ModIntRing z1;
    ModIntRing z2;
    ModInt a;
    ModInt b;
    ModInt c;
    ModInt d;
    ModInt e;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModIntTest.suite());
    }

    public ModIntTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModIntTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected static java.math.BigInteger getPrime1() {
        int n = 2;
        for (int i = 1; i < 15; ++i) {
            n *= 2;
        }
        return new java.math.BigInteger("" + (n -= 135));
    }

    protected static java.math.BigInteger getPrime2() {
        int n = 2;
        for (int i = 1; i < 30; ++i) {
            n *= 2;
        }
        return new java.math.BigInteger("" + (n -= 35));
    }

    protected static java.math.BigInteger getPrime3() {
        int n = 37;
        return new java.math.BigInteger("" + n);
    }

    public void testConstants() {
        this.zm = new ModIntRing(5);
        this.d = new ModInt(this.zm, 11);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = this.b.subtract(this.b);
        ModIntTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        ModIntTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        ModIntTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
    }

    public void testBitLength() {
        this.zm = new ModIntRing(163);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = this.zm.random(30);
        ModIntTest.assertEquals((String)"len(0) = 1", (long)1L, (long)this.a.bitLength());
        ModIntTest.assertEquals((String)"len(1) = 2", (int)2, (int)this.b.bitLength());
        ModIntTest.assertEquals((String)"len(-1) = len(mod)", (long)BigInteger.bitLength(this.zm.modul), (long)this.b.negate().bitLength());
        ModIntTest.assertTrue((String)"len(random) >= 1", (1 <= this.c.bitLength() ? 1 : 0) != 0);
    }

    public void testConstructor() {
        Object object;
        this.zm = new ModIntRing("5");
        this.a = new ModInt(this.zm, "64");
        this.b = new ModInt(this.zm, "34");
        ModIntTest.assertEquals((String)"64(5) = 34(5)", (Object)this.a, (Object)this.b);
        this.zm = new ModIntRing("7");
        this.a = new ModInt(this.zm, "-4");
        this.b = new ModInt(this.zm, "3");
        ModIntTest.assertEquals((String)"-4(7) = 3(7)", (Object)this.a, (Object)this.b);
        String string = "61111111111111111";
        this.zm = new ModIntRing("10");
        try {
            this.a = new ModInt(this.zm, string);
            ModIntTest.fail((String)"s to large");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = "611111111";
        this.a = new ModInt(this.zm, string);
        String string2 = this.a.toString();
        if (PrettyPrint.isTrue()) {
            object = "1";
            ModIntTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string2);
        } else {
            object = "1 mod(10)";
            ModIntTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string2);
        }
        this.zm = new ModIntRing(7);
        this.a = new ModInt(this.zm, 1);
        this.b = new ModInt(this.zm, -1);
        this.c = this.b.sum(this.a);
        ModIntTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        ModIntTest.assertTrue((String)"1 = 1", (boolean)this.b.isUnit());
        ModIntTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.zm = new ModIntRing(5);
        this.a = new ModInt(this.zm, 3);
        this.b = new ModInt(this.zm, 0);
        this.c = this.zm.parse(" 13 ");
        ModIntTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
        object = new StringReader("  13\n w ");
        this.c = this.zm.parse((Reader)object);
        ModIntTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
    }

    public void testRandom() {
        this.zm = new ModIntRing(19);
        this.a = this.zm.random(500);
        this.b = this.a.copy();
        this.c = this.b.subtract(this.a);
        ModIntTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.d = new ModInt(new ModIntRing(this.b.getModul()), this.b.getVal());
        ModIntTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.zm = new ModIntRing(19);
        this.a = this.zm.random(100);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        ModIntTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ModIntTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(this.zm.getZERO());
        ModIntTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.zm.getZERO());
        ModIntTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        ModIntTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.zm.getZERO());
    }

    public void testMultiplication() {
        this.zm = new ModIntRing(5);
        this.d = new ModInt(this.zm, 11);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        ModIntTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        ModIntTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(this.zm.getONE());
        ModIntTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(this.zm.getONE());
        ModIntTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        ModIntTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        try {
            this.a = this.zm.getZERO().inverse();
            ModIntTest.fail((String)"0 invertible");
        }
        catch (NotInvertibleException notInvertibleException) {
            // empty catch block
        }
        this.zm = new ModIntRing(15);
        this.a = new ModInt(this.zm, 5);
        ModIntTest.assertFalse((String)"5 !unit mod 15", (boolean)this.a.isUnit());
        try {
            this.b = this.a.inverse();
            ModIntTest.fail((String)"5 invertible");
        }
        catch (ModularNotInvertibleException modularNotInvertibleException) {
            ModIntTest.assertTrue((String)"f  = 15 ", (boolean)modularNotInvertibleException.f.equals(new BigInteger(15L)));
            ModIntTest.assertTrue((String)"f1 =  5 ", (boolean)modularNotInvertibleException.f1.equals(new BigInteger(5L)));
            ModIntTest.assertTrue((String)"f2 =  3 ", (boolean)modularNotInvertibleException.f2.equals(new BigInteger(3L)));
            ModIntTest.assertTrue((String)"f  =  f1*f2 ", (boolean)modularNotInvertibleException.f.equals(modularNotInvertibleException.f1.multiply(modularNotInvertibleException.f2)));
        }
        catch (NotInvertibleException notInvertibleException) {
            ModIntTest.fail((String)("wrong exception " + notInvertibleException));
        }
    }

    public void testChineseRemainder() {
        this.zm = new ModIntRing(247);
        this.a = this.zm.random(9);
        this.z1 = new ModIntRing(19);
        this.b = new ModInt(this.z1, this.a.getVal());
        this.z2 = new ModIntRing(13);
        this.c = new ModInt(this.z2, this.a.getVal());
        this.d = new ModInt(this.z2, 19);
        this.d = this.d.inverse();
        this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
        ModIntTest.assertEquals((String)"cra(a mod 19,a mod 13) = a", (Object)this.a, (Object)this.e);
        java.math.BigInteger bigInteger = ModIntTest.getPrime2();
        try {
            this.z1 = new ModIntRing(bigInteger);
            ModIntTest.fail((String)"p1 too large");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bigInteger = ModIntTest.getPrime3();
        java.math.BigInteger bigInteger2 = new java.math.BigInteger("19");
        java.math.BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        this.zm = new ModIntRing(bigInteger3);
        this.z1 = new ModIntRing(bigInteger);
        this.z2 = new ModIntRing(bigInteger2);
        for (int i = 0; i < 5; ++i) {
            this.a = this.zm.random(44);
            this.b = new ModInt(this.z1, this.a.getVal());
            this.c = new ModInt(this.z2, this.a.getVal());
            ModInt modInt = new ModInt(this.z2, bigInteger);
            this.d = modInt.inverse();
            this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
            ModIntTest.assertEquals((String)"cra(a mod p1,a mod p2) = a ", (Object)this.a, (Object)this.e);
        }
    }

    public void testChineseRemainderLists() {
        this.zm = new ModIntRing(247);
        this.z1 = new ModIntRing(19);
        this.z2 = new ModIntRing(13);
        ArrayList<ModInt> arrayList = new ArrayList<ModInt>();
        ArrayList<ModInt> arrayList2 = new ArrayList<ModInt>();
        for (int i = 0; i < 7; ++i) {
            this.a = this.zm.random(9);
            this.b = new ModInt(this.z1, this.a.getVal());
            this.c = new ModInt(this.z2, this.a.getVal());
            arrayList.add(this.b);
            arrayList2.add(this.c);
        }
        List<ModInt> list = ModIntRing.chineseRemainder(this.z1.getONE(), this.z2.getONE(), arrayList, arrayList2);
        ModIntTest.assertEquals((String)"19 * 13) = a.modul: ", (Object)this.zm, (Object)list.get((int)0).ring);
        for (ModInt modInt : list) {
            this.b = new ModInt(this.z1, modInt.getVal());
            this.c = new ModInt(this.z2, modInt.getVal());
            ModIntTest.assertTrue((String)"cra(a mod 19, a mod 13) = a: ", (boolean)arrayList.contains(this.b));
            ModIntTest.assertTrue((String)"cra(a mod 19, a mod 13) = a: ", (boolean)arrayList2.contains(this.c));
        }
    }

    public void testTiming() {
        this.zm = new ModIntRing(ModIntTest.getPrime1());
        this.a = this.zm.random(9);
        this.b = this.zm.random(9);
        this.c = this.zm.getONE();
        ModIntegerRing modIntegerRing = new ModIntegerRing(this.zm.modul);
        ModInteger modInteger = new ModInteger(modIntegerRing, this.a.getVal());
        ModInteger modInteger2 = new ModInteger(modIntegerRing, this.b.getVal());
        ModInteger modInteger3 = modIntegerRing.getONE();
        int n = 1000;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            if (this.c.isZERO()) {
                this.c = this.zm.getONE();
            }
            this.c = this.a.sum(this.b.divide(this.c));
        }
        l = System.currentTimeMillis() - l;
        ModInteger modInteger4 = new ModInteger(modIntegerRing, this.c.getVal());
        l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            if (modInteger3.isZERO()) {
                modInteger3 = modIntegerRing.getONE();
            }
            modInteger3 = modInteger.sum(modInteger2.divide(modInteger3));
        }
        l = System.currentTimeMillis() - l;
        ModIntTest.assertEquals((String)"C == D ", (Object)modInteger3, (Object)modInteger4);
    }

    public void testIterator() {
        int n = 10;
        this.zm = new ModIntRing(n);
        ModInt modInt = null;
        Object object = this.zm.iterator();
        while (object.hasNext()) {
            ModInt modInt2;
            modInt = modInt2 = object.next();
        }
        object = new ModInt(this.zm, n - 1);
        ModIntTest.assertTrue((String)"j == m-1 ", (boolean)modInt.equals(object));
    }
}

