/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArithUtil {
    private static final Logger logger = LogManager.getLogger(ArithUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static List<BigInteger> continuedFraction(BigRational bigRational) {
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        if (bigRational == null) {
            return arrayList;
        }
        if (bigRational.isZERO() || bigRational.isONE()) {
            arrayList.add(new BigInteger(bigRational.num));
            return arrayList;
        }
        BigRational bigRational2 = bigRational;
        BigInteger bigInteger = new BigInteger(bigRational2.floor());
        arrayList.add(bigInteger);
        BigRational bigRational3 = bigRational2.subtract(new BigRational(bigInteger));
        while (!bigRational3.isZERO()) {
            bigRational2 = bigRational3.inverse();
            bigInteger = new BigInteger(bigRational2.floor());
            arrayList.add(bigInteger);
            bigRational3 = bigRational2.subtract(new BigRational(bigInteger));
        }
        if (debug) {
            logger.info("cf = {}", arrayList);
        }
        return arrayList;
    }

    public static BigRational continuedFractionApprox(List<BigInteger> list) {
        BigRational bigRational = BigRational.ZERO;
        if (list == null || list.isEmpty()) {
            return bigRational;
        }
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = BigInteger.ONE;
        BigInteger bigInteger4 = BigInteger.ZERO;
        for (BigInteger bigInteger5 : list) {
            BigInteger bigInteger6 = bigInteger5.multiply(bigInteger2).sum(bigInteger);
            BigInteger bigInteger7 = bigInteger5.multiply(bigInteger4).sum(bigInteger3);
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger6;
            bigInteger3 = bigInteger4;
            bigInteger4 = bigInteger7;
        }
        bigRational = new BigRational(bigInteger2, bigInteger4);
        return bigRational;
    }
}

