/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColorPolynomial<C extends RingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(ColorPolynomial.class);
    public final GenPolynomial<GenPolynomial<C>> green;
    public final GenPolynomial<GenPolynomial<C>> red;
    public final GenPolynomial<GenPolynomial<C>> white;

    public ColorPolynomial(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2, GenPolynomial<GenPolynomial<C>> genPolynomial3) {
        if (genPolynomial == null || genPolynomial2 == null || genPolynomial3 == null) {
            throw new IllegalArgumentException("g,r,w may not be null");
        }
        this.green = genPolynomial;
        this.red = genPolynomial2;
        this.white = genPolynomial3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":green: ");
        stringBuffer.append(this.green.toString());
        stringBuffer.append(" :red: ");
        stringBuffer.append(this.red.toString());
        stringBuffer.append(" :white: ");
        stringBuffer.append(this.white.toString());
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":green: ");
        stringBuffer.append(this.green.toScript());
        stringBuffer.append(" :red: ");
        stringBuffer.append(this.red.toScript());
        stringBuffer.append(" :white: ");
        stringBuffer.append(this.white.toScript());
        return stringBuffer.toString();
    }

    public boolean isZERO() {
        return this.red.isZERO() && this.white.isZERO();
    }

    public boolean isONE() {
        return this.red.isZERO() && this.white.isONE() || this.red.isONE() && this.white.isZERO();
    }

    public boolean equals(Object object) {
        ColorPolynomial colorPolynomial = null;
        try {
            colorPolynomial = (ColorPolynomial)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (colorPolynomial == null) {
            return false;
        }
        return this.green.equals(colorPolynomial.green) && this.red.equals(colorPolynomial.red) && this.white.equals(colorPolynomial.white);
    }

    public int hashCode() {
        int n = this.green.hashCode();
        n <<= 11;
        n += this.red.hashCode();
        n <<= 11;
        return n += this.white.hashCode();
    }

    public boolean isDetermined() {
        return !this.red.isZERO() || this.white.isZERO();
    }

    public boolean checkInvariant() {
        ExpVector expVector;
        TermOrder.EVComparator eVComparator;
        ExpVector expVector2;
        boolean bl = true;
        if (this.green.isZERO() && this.red.isZERO() && this.white.isZERO()) {
            return true;
        }
        if (this.green.isZERO() && this.red.isZERO()) {
            return true;
        }
        if (this.red.isZERO() && this.white.isZERO()) {
            return true;
        }
        if (!this.green.isZERO() && !this.red.isZERO()) {
            expVector2 = this.green.trailingExpVector();
            ExpVector expVector3 = this.red.leadingExpVector();
            eVComparator = this.green.ring.tord.getDescendComparator();
            boolean bl2 = bl = bl && eVComparator.compare(expVector2, expVector3) < 0;
        }
        if (!this.red.isZERO() && !this.white.isZERO()) {
            ExpVector expVector4 = this.red.trailingExpVector();
            expVector = this.white.leadingExpVector();
            eVComparator = this.white.ring.tord.getDescendComparator();
            boolean bl3 = bl = bl && eVComparator.compare(expVector4, expVector) < 0;
        }
        if (this.red.isZERO() && !this.green.isZERO() && !this.white.isZERO()) {
            expVector2 = this.green.trailingExpVector();
            expVector = this.white.leadingExpVector();
            eVComparator = this.white.ring.tord.getDescendComparator();
            boolean bl4 = bl = bl && eVComparator.compare(expVector2, expVector) < 0;
        }
        if (!bl) {
            System.out.println("not invariant " + this);
        }
        return bl;
    }

    public List<GenPolynomial<C>> getGreenCoefficients() {
        Collection<GenPolynomial<C>> collection = this.green.getMap().values();
        return new ArrayList<GenPolynomial<C>>(collection);
    }

    public List<GenPolynomial<C>> getRedCoefficients() {
        Collection<GenPolynomial<C>> collection = this.red.getMap().values();
        return new ArrayList<GenPolynomial<C>>(collection);
    }

    public GenPolynomial<GenPolynomial<C>> getPolynomial() {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.green.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.red).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)this.white);
        int n = this.green.length() + this.red.length() + this.white.length();
        int n2 = genPolynomial.length();
        if (n2 != n) {
            throw new RuntimeException("illegal coloring state " + n + " != " + n2);
        }
        return genPolynomial;
    }

    public GenPolynomial<GenPolynomial<C>> getEssentialPolynomial() {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.red.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.white);
        int n = this.red.length() + this.white.length();
        int n2 = genPolynomial.length();
        if (n2 != n) {
            logger.warn("incomplete coloring state " + n + " != " + n2);
            logger.info("f = " + genPolynomial + ", red = " + this.red + ", white = " + this.white);
        }
        return genPolynomial;
    }

    public int length() {
        int n = this.red.length() + this.white.length();
        return n;
    }

    public ExpVector leadingExpVector() {
        if (!this.red.isZERO()) {
            return this.red.leadingExpVector();
        }
        return this.white.leadingExpVector();
    }

    public Map.Entry<ExpVector, GenPolynomial<C>> leadingMonomial() {
        if (!this.red.isZERO()) {
            return this.red.leadingMonomial();
        }
        return this.white.leadingMonomial();
    }

    public ColorPolynomial<C> abs() {
        int n = this.green.signum();
        if (n > 0) {
            return this;
        }
        if (n < 0) {
            AbelianGroupElem abelianGroupElem = this.green.negate();
            AbelianGroupElem abelianGroupElem2 = this.red.negate();
            AbelianGroupElem abelianGroupElem3 = this.white.negate();
            return new ColorPolynomial<C>(abelianGroupElem, abelianGroupElem2, abelianGroupElem3);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.green;
        n = this.red.signum();
        if (n > 0) {
            return this;
        }
        if (n < 0) {
            AbelianGroupElem abelianGroupElem = this.red.negate();
            AbelianGroupElem abelianGroupElem4 = this.white.negate();
            return new ColorPolynomial<C>(genPolynomial, abelianGroupElem, abelianGroupElem4);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.red;
        n = this.white.signum();
        if (n > 0) {
            return this;
        }
        if (n < 0) {
            AbelianGroupElem abelianGroupElem = this.white.negate();
            return new ColorPolynomial<C>(genPolynomial, genPolynomial2, abelianGroupElem);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = this.white;
        return new ColorPolynomial<C>(genPolynomial, genPolynomial2, genPolynomial3);
    }

    public ColorPolynomial<C> sum(ColorPolynomial<C> colorPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.green.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)colorPolynomial.green);
        AbelianGroupElem abelianGroupElem = this.red.ring.getZERO();
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.getEssentialPolynomial().sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)colorPolynomial.getEssentialPolynomial());
        return new ColorPolynomial<C>(genPolynomial, abelianGroupElem, genPolynomial2);
    }

    public ColorPolynomial<C> sum(GenPolynomial<C> genPolynomial, ExpVector expVector) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.green;
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = this.red;
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.white;
        if (this.green.getMap().keySet().contains(expVector)) {
            genPolynomial2 = this.green.sum(genPolynomial, expVector);
        } else if (this.red.getMap().keySet().contains(expVector)) {
            genPolynomial3 = this.red.sum(genPolynomial, expVector);
        } else {
            genPolynomial4 = this.white.sum(genPolynomial, expVector);
        }
        return new ColorPolynomial<C>(genPolynomial2, genPolynomial3, genPolynomial4);
    }

    public ColorPolynomial<C> subtract(ColorPolynomial<C> colorPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.green.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)colorPolynomial.green);
        AbelianGroupElem abelianGroupElem = this.red.ring.getZERO();
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.getEssentialPolynomial().subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)colorPolynomial.getEssentialPolynomial());
        return new ColorPolynomial<C>(genPolynomial, abelianGroupElem, genPolynomial2);
    }

    public ColorPolynomial<C> subtract(GenPolynomial<C> genPolynomial, ExpVector expVector) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.green;
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = this.red;
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.white;
        if (this.green.getMap().keySet().contains(expVector)) {
            genPolynomial2 = this.green.subtract(genPolynomial, expVector);
        } else if (this.red.getMap().keySet().contains(expVector)) {
            genPolynomial3 = this.red.subtract(genPolynomial, expVector);
        } else {
            genPolynomial4 = this.white.subtract(genPolynomial, expVector);
        }
        return new ColorPolynomial<C>(genPolynomial2, genPolynomial3, genPolynomial4);
    }

    public ColorPolynomial<C> multiply(GenPolynomial<C> genPolynomial, ExpVector expVector) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2;
        GenPolynomial<GenPolynomial<C>> genPolynomial3;
        GenPolynomial<GenPolynomial<C>> genPolynomial4;
        if (this.green instanceof GenSolvablePolynomial) {
            logger.info("use left multiplication");
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.green;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)this.red;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)this.white;
            genPolynomial4 = genSolvablePolynomial.multiplyLeft(genPolynomial, expVector);
            genPolynomial3 = genSolvablePolynomial2.multiplyLeft(genPolynomial, expVector);
            genPolynomial2 = genSolvablePolynomial3.multiplyLeft(genPolynomial, expVector);
        } else {
            genPolynomial4 = this.green.multiply(genPolynomial, expVector);
            genPolynomial3 = this.red.multiply(genPolynomial, expVector);
            genPolynomial2 = this.white.multiply(genPolynomial, expVector);
        }
        return new ColorPolynomial<C>(genPolynomial4, genPolynomial3, genPolynomial2);
    }

    public ColorPolynomial<C> multiply(GenPolynomial<C> genPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.green.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial);
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = this.red.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial);
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.white.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial);
        return new ColorPolynomial<C>(genPolynomial2, genPolynomial3, genPolynomial4);
    }

    public ColorPolynomial<C> divide(GenPolynomial<C> genPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.green.divide((GenPolynomial<GenPolynomial<C>>)genPolynomial);
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = this.red.divide((GenPolynomial<GenPolynomial<C>>)genPolynomial);
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.white.divide((GenPolynomial<GenPolynomial<C>>)genPolynomial);
        return new ColorPolynomial<C>(genPolynomial2, genPolynomial3, genPolynomial4);
    }
}

