/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToComplexReal<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<Complex<C>, Complex<RealAlgebraicNumber<C>>> {
    protected final ComplexRing<RealAlgebraicNumber<C>> cfac;
    final RealAlgebraicRing<C> afac;
    final GenPolynomialRing<C> pfac;

    public CoeffToComplexReal(ComplexRing<RealAlgebraicNumber<C>> complexRing) {
        if (complexRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = complexRing;
        this.afac = (RealAlgebraicRing)this.cfac.ring;
        this.pfac = this.afac.univs.ideal.getRing();
    }

    @Override
    public Complex<RealAlgebraicNumber<C>> eval(Complex<C> complex) {
        if (complex == null) {
            return this.cfac.getZERO();
        }
        GenPolynomial<GcdRingElem> genPolynomial = new GenPolynomial<GcdRingElem>(this.pfac, (GcdRingElem)complex.getRe());
        GenPolynomial<GcdRingElem> genPolynomial2 = new GenPolynomial<GcdRingElem>(this.pfac, (GcdRingElem)complex.getIm());
        RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber = new RealAlgebraicNumber<GcdRingElem>(this.afac, genPolynomial);
        RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber2 = new RealAlgebraicNumber<GcdRingElem>(this.afac, genPolynomial2);
        return new Complex<RealAlgebraicNumber<C>>(this.cfac, realAlgebraicNumber, realAlgebraicNumber2);
    }
}

