/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.util.ArrayList;
import java.util.Observable;
import java.util.TreeSet;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.type.Type;
import prism.PrismException;
import prism.PrismSettings;
import userinterface.simulator.GUISimulator;
import userinterface.simulator.GUIViewDialog;

public class SimulationView
extends Observable {
    private GUISimulator simulator;
    private ArrayList<Variable> visibleVariables;
    private ArrayList<Variable> hiddenVariables;
    private ArrayList<Observ> visibleObservables;
    private ArrayList<RewardStructureColumn> visibleRewardColumns;
    private ArrayList<RewardStructure> rewards;
    private boolean stepsVisible;
    private boolean actionsVisible;
    private boolean showTime;
    private boolean showCumulativeTime;
    private boolean useChangeRenderer;

    public SimulationView(GUISimulator gUISimulator, PrismSettings prismSettings) {
        this.simulator = gUISimulator;
        this.visibleVariables = new ArrayList();
        this.hiddenVariables = new ArrayList();
        this.visibleObservables = new ArrayList();
        this.visibleRewardColumns = new ArrayList();
        this.rewards = new ArrayList();
        this.stepsVisible = true;
        this.actionsVisible = true;
        this.showTime = false;
        this.showCumulativeTime = true;
        this.useChangeRenderer = prismSettings.getInteger("simulator.renderAllValues") == 0;
    }

    public boolean showSteps() {
        return this.stepsVisible;
    }

    public void showSteps(boolean bl) {
        this.stepsVisible = bl;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean showActions() {
        return this.actionsVisible;
    }

    public void showActions(boolean bl) {
        this.actionsVisible = bl;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean showTime() {
        return this.showTime;
    }

    public boolean showCumulativeTime() {
        return this.showCumulativeTime;
    }

    public void showTime(boolean bl) {
        this.showTime = bl;
        this.setChanged();
        this.notifyObservers();
    }

    public void showCumulativeTime(boolean bl) {
        this.showCumulativeTime = bl;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList<Variable> getVisibleVariables() {
        return this.visibleVariables;
    }

    public ArrayList<Variable> getHiddenVariables() {
        return this.hiddenVariables;
    }

    public void setVariableVisibility(ArrayList<Variable> arrayList, ArrayList<Variable> arrayList2) {
        this.visibleVariables = arrayList;
        this.hiddenVariables = arrayList2;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList<Observ> getVisibleObservables() {
        return this.visibleObservables;
    }

    public ArrayList<RewardStructureColumn> getVisibleRewardColumns() {
        return this.visibleRewardColumns;
    }

    public void setVisibleRewardListItems(ArrayList<GUIViewDialog.RewardListItem> arrayList) {
        ArrayList<RewardStructureColumn> arrayList2 = new ArrayList<RewardStructureColumn>();
        for (GUIViewDialog.RewardListItem rewardListItem : arrayList) {
            if (rewardListItem.isCumulative()) {
                arrayList2.add(new RewardStructureColumn(rewardListItem.getRewardStructure(), 2));
                continue;
            }
            if (!rewardListItem.getRewardStructure().isStateEmpty()) {
                arrayList2.add(new RewardStructureColumn(rewardListItem.getRewardStructure(), 0));
            }
            if (rewardListItem.getRewardStructure().isTransitionEmpty()) continue;
            arrayList2.add(new RewardStructureColumn(rewardListItem.getRewardStructure(), 1));
        }
        this.visibleRewardColumns = arrayList2;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList<RewardStructure> getRewards() {
        return this.rewards;
    }

    public boolean isChangeRenderer() {
        return this.useChangeRenderer;
    }

    public void setRenderer(boolean bl) {
        if (this.useChangeRenderer != bl) {
            this.useChangeRenderer = bl;
            this.simulator.setRenderer(this.useChangeRenderer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void refreshToDefaultView(boolean bl, ModulesFile modulesFile) {
        Cloneable cloneable;
        boolean bl2 = true;
        if (!bl) {
            bl2 = false;
        } else {
            if (this.useChangeRenderer != this.simulator.usingChangeRenderer()) {
                this.simulator.setRenderer(this.useChangeRenderer);
            }
            try {
                void var7_25;
                void var6_16;
                if (!modulesFile.getModelType().continuousTime() && (this.showTime || this.showCumulativeTime)) {
                    bl2 = false;
                }
                TreeSet<String> treeSet = new TreeSet<String>();
                for (Variable object2 : this.visibleVariables) {
                    treeSet.add(object2.getName());
                }
                for (Variable object : this.hiddenVariables) {
                    treeSet.add(object.getName());
                }
                for (int i = 0; i < modulesFile.getNumVars(); ++i) {
                    if (treeSet.remove(modulesFile.getVarName(i))) continue;
                    bl2 = false;
                }
                if (treeSet.size() > 0) {
                    bl2 = false;
                }
                cloneable = new TreeSet();
                for (Observ observ : this.visibleObservables) {
                    ((TreeSet)cloneable).add(observ.getName());
                }
                boolean bl3 = false;
                while (var6_16 < modulesFile.getNumObservables()) {
                    if (!((TreeSet)cloneable).remove(modulesFile.getObservableName((int)var6_16))) {
                        bl2 = false;
                    }
                    ++var6_16;
                }
                if (((TreeSet)cloneable).size() > 0) {
                    bl2 = false;
                }
                ArrayList<RewardStructure> arrayList = new ArrayList<RewardStructure>();
                for (RewardStructure rewardStructure : this.rewards) {
                    arrayList.add(rewardStructure);
                }
                boolean bl4 = false;
                while (var7_25 < modulesFile.getNumRewardStructs()) {
                    RewardStruct rewardStruct = modulesFile.getRewardStruct((int)var7_25);
                    String string = rewardStruct.getName();
                    boolean bl5 = modulesFile.getRewardStruct((int)var7_25).getNumStateItems() != 0;
                    boolean bl6 = modulesFile.getRewardStruct((int)var7_25).getNumTransItems() != 0;
                    boolean bl7 = false;
                    for (RewardStructure rewardStructure : this.rewards) {
                        if (rewardStructure.isStateEmpty() != !bl5 || rewardStructure.isTransitionEmpty() != !bl6 || (rewardStructure.getName() != null || !string.equals("")) && (rewardStructure.getName() == null || !rewardStructure.getName().equals(string))) continue;
                        arrayList.remove(rewardStructure);
                        bl7 = true;
                    }
                    if (!bl7) {
                        bl2 = false;
                    }
                    ++var7_25;
                }
                if (arrayList.size() > 0) {
                    bl2 = false;
                }
            }
            catch (PrismException prismException) {
                bl2 = false;
            }
        }
        if (!bl2 && bl) {
            int n;
            this.visibleVariables.clear();
            this.hiddenVariables.clear();
            this.visibleObservables.clear();
            this.visibleRewardColumns.clear();
            this.rewards.clear();
            for (n = 0; n < modulesFile.getNumVars(); ++n) {
                this.visibleVariables.add(new Variable(n, modulesFile.getVarName(n), modulesFile.getVarType(n), modulesFile.getVarModuleIndex(n)));
            }
            for (n = 0; n < modulesFile.getNumObservables(); ++n) {
                try {
                    this.visibleObservables.add(new Observ(n, modulesFile.getObservableName(n), modulesFile.getObservableType(n)));
                    continue;
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
            }
            for (n = 0; n < modulesFile.getNumRewardStructs(); ++n) {
                void var6_21;
                RewardStructure rewardStructure;
                cloneable = modulesFile.getRewardStruct(n);
                String string = ((RewardStruct)cloneable).getName();
                if (string.trim().length() == 0) {
                    Object var6_20 = null;
                }
                if (!(rewardStructure = new RewardStructure(n, (String)var6_21, modulesFile.getRewardStruct(n).getNumStateItems() == 0, modulesFile.getRewardStruct(n).getNumTransItems() == 0)).isStateEmpty() || !rewardStructure.isTransitionEmpty()) {
                    this.rewards.add(rewardStructure);
                }
                if (!rewardStructure.isStateEmpty()) {
                    this.visibleRewardColumns.add(new RewardStructureColumn(rewardStructure, 0));
                }
                if (rewardStructure.isTransitionEmpty()) continue;
                this.visibleRewardColumns.add(new RewardStructureColumn(rewardStructure, 1));
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public class RewardStructureColumn {
        public static final int STATE_REWARD = 0;
        public static final int TRANSITION_REWARD = 1;
        public static final int CUMULATIVE_REWARD = 2;
        private RewardStructure rewardStructure;
        private int type;

        public RewardStructureColumn(RewardStructure rewardStructure, int n) {
            this.rewardStructure = rewardStructure;
            this.type = n;
        }

        public String getColumnName() {
            switch (this.type) {
                case 0: {
                    return this.rewardStructure.getColumnName();
                }
                case 1: {
                    return "[ " + this.rewardStructure.getColumnName() + " ]";
                }
                case 2: {
                    return this.rewardStructure.getColumnName() + " (+)";
                }
            }
            return "";
        }

        public RewardStructure getRewardStructure() {
            return this.rewardStructure;
        }

        public void setRewardStructure(RewardStructure rewardStructure) {
            this.rewardStructure = rewardStructure;
        }

        public String toString() {
            return this.getColumnName();
        }

        public boolean isStateReward() {
            return this.type == 0;
        }

        public boolean isTransitionReward() {
            return this.type == 1;
        }

        public boolean isCumulativeReward() {
            return this.type == 2;
        }

        public void setStateReward() {
            this.type = 0;
        }

        public void setTransitionReward() {
            this.type = 1;
        }

        public void setCumulativeReward() {
            this.type = 2;
        }
    }

    public class RewardStructure {
        private int index;
        private String name;
        private boolean stateEmpty;
        private boolean transitionEmpty;

        public RewardStructure(int n, String string, boolean bl, boolean bl2) {
            this.index = n;
            this.name = string;
            this.stateEmpty = bl;
            this.transitionEmpty = bl2;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getColumnName() {
            if (this.name == null) {
                return "" + (this.index + 1);
            }
            return "\"" + this.name + "\"";
        }

        public boolean isStateEmpty() {
            return this.stateEmpty;
        }

        public boolean isTransitionEmpty() {
            return this.transitionEmpty;
        }

        public boolean isCumulative() {
            return false;
        }

        public String toString() {
            if (this.name != null) {
                return this.index + 1 + ": \"" + this.name + "\"";
            }
            return this.index + 1 + ": <unnamed>";
        }

        public boolean equals(Object object) {
            return object instanceof RewardStructure && ((RewardStructure)object).getIndex() == this.index && ((RewardStructure)object).isCumulative() == this.isCumulative();
        }
    }

    public class Variable {
        protected int index;
        protected String name;
        protected Type type;
        protected int moduleIndex;

        public Variable(int n, String string, Type type, int n2) {
            this.index = n;
            this.name = string;
            this.type = type;
            this.moduleIndex = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            return object instanceof Variable && ((Variable)object).getIndex() == this.index;
        }
    }

    public class Observ
    extends Variable {
        public Observ(int n, String string, Type type) {
            super(n, string, type, -1);
        }

        @Override
        public String toString() {
            return "\"" + this.name + "\"";
        }
    }

    public class MemoryValue {
        private Object value;
        private boolean memoryValueUnknown;

        public MemoryValue(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public void setMemoryValueUnknown(boolean bl) {
            this.memoryValueUnknown = bl;
        }

        public boolean isMemoryValueUnknown() {
            return this.memoryValueUnknown;
        }
    }

    public class RewardStructureValue {
        private RewardStructureColumn rewardStructureColumn;
        private Double rewardValue;
        private boolean hasChanged;
        private boolean rewardValueUnknown;

        public RewardStructureValue(RewardStructureColumn rewardStructureColumn, Double d) {
            this.rewardStructureColumn = rewardStructureColumn;
            this.rewardValue = d;
            this.hasChanged = true;
            this.rewardValueUnknown = false;
        }

        public RewardStructureColumn getRewardStructureColumn() {
            return this.rewardStructureColumn;
        }

        public void setRewardStructureColumn(RewardStructureColumn rewardStructureColumn) {
            this.rewardStructureColumn = rewardStructureColumn;
        }

        public Double getRewardValue() {
            return this.rewardValue;
        }

        public void setRewardValue(Double d) {
            this.rewardValue = d;
        }

        public void setRewardValueUnknown(boolean bl) {
            this.rewardValueUnknown = bl;
        }

        public boolean isRewardValueUnknown() {
            return this.rewardValueUnknown;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void setChanged(boolean bl) {
            this.hasChanged = bl;
        }
    }

    public class TimeValue {
        private Double value;
        private boolean timeValueUnknown;
        private boolean isCumulative;

        public TimeValue(Double d, boolean bl) {
            this.value = d;
            this.isCumulative = bl;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double d) {
            this.value = d;
        }

        public void setTimeValueUnknown(boolean bl) {
            this.timeValueUnknown = bl;
        }

        public boolean isTimeValueUnknown() {
            return this.timeValueUnknown;
        }

        public boolean isCumulative() {
            return this.isCumulative;
        }

        public void setCumulative(boolean bl) {
            this.isCumulative = bl;
        }
    }

    public class ActionValue {
        private String value;
        private boolean actionValueUnknown;

        public ActionValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public void setActionValueUnknown(boolean bl) {
            this.actionValueUnknown = bl;
        }

        public boolean isActionValueUnknown() {
            return this.actionValueUnknown;
        }
    }

    public class VariableValue {
        private Variable variable;
        private Object value;
        private boolean hasChanged;

        public VariableValue(Variable variable, Object object) {
            this.variable = variable;
            this.value = object;
            this.hasChanged = true;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Variable getVariable() {
            return this.variable;
        }

        public void setVariable(Variable variable) {
            this.variable = variable;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void setChanged(boolean bl) {
            this.hasChanged = bl;
        }
    }
}

