/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import javax.swing.SwingUtilities;
import parser.State;
import prism.PrismException;
import simulator.GenerateSimulationPath;
import simulator.SimulatorEngine;
import userinterface.GUIComputationThread;
import userinterface.graph.Graph;
import userinterface.simulator.GUISimulator;

public class SimPathPlotThread
extends GUIComputationThread {
    private SimulatorEngine engine;
    private State initialState;
    private String simPathDetails;
    private long maxPathLength;
    private Graph graphModel;

    public SimPathPlotThread(GUISimulator gUISimulator, SimulatorEngine simulatorEngine, State state, String string, long l, Graph graph) {
        super(gUISimulator);
        this.engine = simulatorEngine;
        this.initialState = state;
        this.simPathDetails = string;
        this.maxPathLength = l;
        this.graphModel = graph;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GenerateSimulationPath generateSimulationPath = new GenerateSimulationPath(SimPathPlotThread.this.engine, SimPathPlotThread.this.prism.getMainLog());
                    generateSimulationPath.generateAndPlotSimulationPath(SimPathPlotThread.this.initialState, SimPathPlotThread.this.simPathDetails, SimPathPlotThread.this.maxPathLength, SimPathPlotThread.this.graphModel);
                    if (generateSimulationPath.getNumWarnings() > 0) {
                        for (String string : generateSimulationPath.getWarnings()) {
                            SimPathPlotThread.this.plug.warning(string);
                        }
                    }
                }
                catch (PrismException prismException) {
                    SimPathPlotThread.this.error(prismException.getMessage());
                }
            }
        });
    }
}

