/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import prism.ModelGenerator;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import simulator.SimulatorEngine;
import userinterface.GUIPrism;

public class GUIInitialStatePicker
extends JDialog
implements KeyListener {
    public static final int NO_VALUES = 0;
    public static final int VALUES_DONE = 1;
    public static final int CANCELLED = 2;
    private boolean cancelled = true;
    private JTable initValuesTable;
    private DefineValuesTable initValuesModel;
    private GUIPrism gui;
    private ModelGenerator<Double> modelGen;
    private int numVars;
    private State initialState;
    private JPanel allPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel innerPanel;
    private JButton okayButton;
    private JCheckBox optionCheckBox;
    private JPanel topPanel;

    public GUIInitialStatePicker(GUIPrism gUIPrism, SimulatorEngine simulatorEngine, Values values) {
        super(gUIPrism, "Initial State for Simulation", true);
        this.gui = gUIPrism;
        this.modelGen = simulatorEngine.getModel();
        this.numVars = this.modelGen.getNumVars();
        this.initValuesModel = new DefineValuesTable();
        this.initValuesTable = new JTable();
        this.initValuesTable.setModel(this.initValuesModel);
        this.initValuesTable.setSelectionMode(1);
        this.initValuesTable.setCellSelectionEnabled(true);
        this.initValuesTable.setRowHeight(this.getFontMetrics(this.initValuesTable.getFont()).getHeight() + 4);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.initTable();
        this.initValues(values);
        super.setBounds(new Rectangle(550, 300));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.allPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.optionCheckBox = new JCheckBox();
        this.topPanel = new JPanel();
        this.innerPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIInitialStatePicker.this.closeDialog(windowEvent);
            }
        });
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.bottomPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIInitialStatePicker.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIInitialStatePicker.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.optionCheckBox.setText("Always prompt for initial state on path creation");
        this.optionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIInitialStatePicker.this.optionCheckBoxActionPerformed(actionEvent);
            }
        });
        this.optionCheckBox.getAccessibleContext().setAccessibleName("optionCheckBox");
        this.allPanel.add((Component)this.bottomPanel, "South");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(new TitledBorder("Initial state"));
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.topPanel.add((Component)this.innerPanel, "Center");
        this.allPanel.add((Component)this.topPanel, "Center");
        this.getContentPane().add((Component)this.allPanel, "Center");
    }

    private void optionCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void initTable() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.initValuesTable);
        this.innerPanel.add(jScrollPane);
        this.innerPanel.setPreferredSize(new Dimension(300, 300));
    }

    private void initValues(Values values) {
        try {
            boolean bl = false;
            if (values != null) {
                bl = true;
                if (values.getNumValues() != this.numVars) {
                    bl = false;
                } else {
                    for (int i = 0; i < this.numVars; ++i) {
                        String string = this.modelGen.getVarName(i);
                        if (!values.contains(string)) {
                            bl = false;
                            break;
                        }
                        try {
                            Object object = values.getValueOf(string);
                            object = this.modelGen.getVarType(i).castValueTo(object);
                            this.initValuesModel.setValue(i, object);
                            continue;
                        }
                        catch (PrismLangException prismLangException) {
                            bl = false;
                        }
                    }
                }
            }
            if (!bl) {
                State state = this.modelGen.getInitialState();
                for (int i = 0; i < this.numVars; ++i) {
                    this.initValuesModel.setValue(i, state.varValues[i]);
                }
            }
        }
        catch (PrismException prismException) {
            this.gui.errorDialog("Error choosing initial state: " + prismException.getMessage());
        }
    }

    public static State defineInitalValuesWithDialog(GUIPrism gUIPrism, SimulatorEngine simulatorEngine, Values values) {
        return new GUIInitialStatePicker(gUIPrism, simulatorEngine, values).defineValues();
    }

    public State defineValues() {
        this.setVisible(true);
        if (this.cancelled) {
            return null;
        }
        return this.initialState;
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        if (this.initValuesTable.getCellEditor() != null) {
            this.initValuesTable.getCellEditor().stopCellEditing();
        }
        String string = "";
        String string2 = "";
        try {
            State state = new State(this.numVars);
            for (int i = 0; i < this.numVars; ++i) {
                string = this.modelGen.getVarName(i);
                string2 = this.initValuesModel.getValue(i).toString();
                Expression expression = Prism.parseSingleExpressionString(string2);
                if (!expression.isConstant()) {
                    throw new PrismException("Not constant");
                }
                Object object = expression.evaluate();
                if (!this.modelGen.getVarType(i).canAssign(expression.getType())) {
                    throw new PrismException("Type mismatch");
                }
                state.varValues[i] = object = this.modelGen.getVarType(i).castValueTo(object);
            }
            this.initialState = state;
            this.cancelled = false;
            this.dispose();
        }
        catch (PrismException prismException) {
            this.gui.errorDialog("Invalid value \"" + string2 + "\" for variable " + string + ": " + prismException.getMessage());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class DefineValuesTable
    extends AbstractTableModel {
        Object[] values;

        public DefineValuesTable() {
            this.values = new Object[GUIInitialStatePicker.this.numVars];
        }

        public void setValue(int n, Object object) {
            this.values[n] = object;
            this.fireTableRowsInserted(n, n);
        }

        public Object getValue(int n) {
            return this.values[n];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return GUIInitialStatePicker.this.numVars;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            try {
                switch (n2) {
                    case 0: {
                        return GUIInitialStatePicker.this.modelGen.getVarName(n);
                    }
                    case 1: {
                        return GUIInitialStatePicker.this.modelGen.getVarType(n);
                    }
                    case 2: {
                        return this.values[n].toString();
                    }
                }
                return "";
            }
            catch (PrismException prismException) {
                return "";
            }
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                this.values[n] = object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public String toString() {
            Object object = "";
            for (int i = 0; i < GUIInitialStatePicker.this.numVars; ++i) {
                object = (String)object + GUIInitialStatePicker.this.modelGen.getVarName(i) + "=" + this.values[i].toString();
                if (i >= GUIInitialStatePicker.this.numVars - 1) continue;
                object = (String)object + ",";
            }
            return object;
        }
    }
}

