/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import strat.StrategyExportOptions;
import userinterface.GUIComputationThread;
import userinterface.GUIPlugin;
import userinterface.util.GUIComputationEvent;

public class ExportStrategyThread
extends GUIComputationThread {
    private StrategyExportOptions exportOptions;
    private File exportFile;

    public ExportStrategyThread(GUIPlugin gUIPlugin, StrategyExportOptions strategyExportOptions, File file) {
        super(gUIPlugin);
        this.exportOptions = strategyExportOptions;
        this.exportFile = file;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExportStrategyThread.this.plug.startProgress();
                    ExportStrategyThread.this.plug.setTaskBarText("Exporting...");
                    ExportStrategyThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ExportStrategyThread.this.plug));
                }
            });
            try {
                this.prism.exportStrategy(this.exportOptions, this.exportFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExportStrategyThread.this.plug.stopProgress();
                        ExportStrategyThread.this.plug.setTaskBarText("Exporting... error.");
                        ExportStrategyThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ExportStrategyThread.this.plug));
                        ExportStrategyThread.this.error("Could not export to file \"" + ExportStrategyThread.this.exportFile + "\"");
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                this.error(throwable);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExportStrategyThread.this.plug.stopProgress();
                        ExportStrategyThread.this.plug.setTaskBarText("Exporting... error.");
                        ExportStrategyThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ExportStrategyThread.this.plug));
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExportStrategyThread.this.plug.stopProgress();
                    ExportStrategyThread.this.plug.setTaskBarText("Exporting... done.");
                    ExportStrategyThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ExportStrategyThread.this.plug));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

