/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import prism.PrismException;
import userinterface.properties.GUILabel;
import userinterface.properties.GUIMultiProperties;

public class GUIPropLabelList
extends JTable {
    private PropLabelModel theModel;
    private GUIMultiProperties parent;

    public GUIPropLabelList(GUIMultiProperties gUIMultiProperties) {
        this.parent = gUIMultiProperties;
        this.theModel = new PropLabelModel();
        this.setModel(this.theModel);
        try {
            this.setDefaultRenderer(Class.forName("java.lang.Object"), new TheCellRenderer());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(this.getFontMetrics(font).getHeight() + 4);
    }

    public void correctEditors() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public void newList() {
        this.theModel.newList();
    }

    public int getNumLabels() {
        return this.theModel.getNumLabels();
    }

    public GUILabel getLabel(int n) {
        return this.theModel.getLabel(n);
    }

    public void addNewLabel() {
        this.theModel.addLabel();
        this.theModel.validateLabels();
    }

    public void removeLabel(int n) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        this.theModel.removeLabel(n);
        this.theModel.validateLabels();
    }

    public void addPropertiesFile(PropertiesFile propertiesFile) {
        LabelList labelList = propertiesFile.getLabelList();
        int n = labelList.size();
        for (int i = 0; i < n; ++i) {
            GUILabel gUILabel = new GUILabel(this.parent, labelList.getLabelName(i), labelList.getLabel(i).toString());
            this.theModel.addLabel(gUILabel);
        }
        this.theModel.validateLabels();
    }

    public void validateLabels() {
        this.theModel.validateLabels();
    }

    public boolean isPropLabelListValid() {
        if (this.theModel.error != null) {
            return false;
        }
        int n = this.theModel.getNumLabels();
        for (int i = 0; i < n; ++i) {
            if (this.theModel.getLabel(i).isParseable()) continue;
            return false;
        }
        return true;
    }

    public String getLabelsString() {
        return this.theModel.toString();
    }

    public String getValidLabelsString() {
        return this.theModel.validToString();
    }

    class PropLabelModel
    extends AbstractTableModel {
        ArrayList labels = new ArrayList();
        int labCount = 0;
        Exception error = null;

        public int getNumLabels() {
            return this.labels.size();
        }

        public GUILabel getLabel(int n) {
            return (GUILabel)this.labels.get(n);
        }

        public Exception getError() {
            return this.error;
        }

        @Override
        public int getRowCount() {
            return this.labels.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GUILabel gUILabel = this.getLabel(n);
            switch (n2) {
                case 0: {
                    return gUILabel.getNameString();
                }
                case 1: {
                    return gUILabel.getValueString();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Definition";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public String toString() {
            Object object = "";
            for (int i = 0; i < this.getNumLabels(); ++i) {
                GUILabel gUILabel = this.getLabel(i);
                object = (String)object + gUILabel.toString() + "\n";
            }
            return object;
        }

        public String validToString() {
            if (this.error != null) {
                return "";
            }
            return this.parseableToString();
        }

        public String parseableToString() {
            Object object = "";
            int n = this.getNumLabels();
            for (int i = 0; i < n; ++i) {
                GUILabel gUILabel = this.getLabel(i);
                if (!gUILabel.isParseable()) continue;
                object = (String)object + gUILabel.toString() + "\n";
            }
            return object;
        }

        public void newList() {
            this.labels = new ArrayList();
            this.fireTableStructureChanged();
            GUIPropLabelList.this.parent.labelListChanged();
        }

        public void addLabel() {
            this.addLabel(new GUILabel(GUIPropLabelList.this.parent, "L" + this.labCount, "true"));
            ++this.labCount;
        }

        public void addLabel(GUILabel gUILabel) {
            gUILabel.parse();
            this.labels.add(gUILabel);
            this.fireTableRowsInserted(this.labels.size() - 1, this.labels.size() - 1);
            GUIPropLabelList.this.parent.labelListChanged();
        }

        public void removeLabel(int n) {
            this.labels.remove(n);
            this.fireTableRowsDeleted(n, n);
            GUIPropLabelList.this.parent.labelListChanged();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            GUILabel gUILabel = this.getLabel(n);
            switch (n2) {
                case 0: {
                    if (gUILabel.name.equals((String)object)) break;
                    gUILabel.name = (String)object;
                    gUILabel.parse();
                    this.validateLabels();
                    GUIPropLabelList.this.parent.labelListChanged();
                    break;
                }
                case 1: {
                    if (gUILabel.label.equals((String)object)) break;
                    gUILabel.label = (String)object;
                    gUILabel.parse();
                    this.validateLabels();
                    GUIPropLabelList.this.parent.labelListChanged();
                }
            }
        }

        public void validateLabels() {
            try {
                this.error = null;
                GUIPropLabelList.this.parent.getPrism().parsePropertiesString(GUIPropLabelList.this.parent.getConstantsString() + "\n" + this.parseableToString());
            }
            catch (PrismException prismException) {
                this.error = prismException;
            }
            this.fireTableDataChanged();
        }
    }

    class TheCellRenderer
    extends DefaultTableCellRenderer {
        TheCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            GUILabel gUILabel = GUIPropLabelList.this.theModel.getLabel(n);
            if (!gUILabel.isParseable()) {
                this.setBackground(bl ? GUIPropLabelList.this.parent.getSelectionColor() : GUIPropLabelList.this.parent.getWarningColor());
                this.setForeground(Color.red);
                this.setToolTipText(gUILabel.parseError.toString());
            } else if (((GUIPropLabelList)GUIPropLabelList.this).theModel.error != null) {
                this.setBackground(bl ? GUIPropLabelList.this.parent.getSelectionColor() : GUIPropLabelList.this.parent.getWarningColor());
                this.setForeground(Color.red);
                this.setToolTipText(((GUIPropLabelList)GUIPropLabelList.this).theModel.error.toString());
            } else {
                this.setBackground(bl ? GUIPropLabelList.this.parent.getSelectionColor() : Color.white);
                this.setForeground(Color.black);
                this.setToolTipText(gUILabel.toString());
            }
            return component;
        }
    }
}

