/*
 * Decompiled with CFR 0.152.
 */
package userinterface.log;

import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import prism.PrismLog;
import prism.PrismSettings;
import userinterface.log.GUILog;
import userinterface.util.GUIEvent;

public class GUIWindowLog
extends PrismLog {
    private JTextArea textArea;
    private GUIWindowLogUpdater updater;
    private String buffer = "";
    private boolean clearFlag = false;
    private GUILog logPlugin;

    public GUIWindowLog() {
        this.textArea = null;
        this.updater = null;
    }

    public GUIWindowLog(JTextArea jTextArea, GUILog gUILog) {
        this.open(jTextArea, gUILog);
    }

    public void open(JTextArea jTextArea, GUILog gUILog) {
        this.logPlugin = gUILog;
        this.textArea = jTextArea;
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (GUIWindowLog.this.logPlugin != null) {
                    GUIWindowLog.this.logPlugin.getSelectionChangeHandler().notifyListeners(new GUIEvent(1));
                }
            }
        });
        this.updater = new GUIWindowLogUpdater(this, this.textArea);
        this.updater.start();
    }

    @Override
    public boolean ready() {
        return this.textArea != null;
    }

    @Override
    public long getFilePointer() {
        return -1L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void print(boolean bl) {
        this.addToBuffer("" + bl);
    }

    @Override
    public void print(char c) {
        this.addToBuffer("" + c);
    }

    @Override
    public void print(double d) {
        this.addToBuffer("" + d);
    }

    @Override
    public void print(float f) {
        this.addToBuffer("" + f);
    }

    @Override
    public void print(int n) {
        this.addToBuffer("" + n);
    }

    @Override
    public void print(long l) {
        this.addToBuffer("" + l);
    }

    @Override
    public void print(Object object) {
        this.addToBuffer("" + object);
    }

    @Override
    public void print(String string) {
        this.addToBuffer(string);
    }

    @Override
    public void println() {
        this.addToBuffer("\n");
    }

    public void clear() {
        this.setClearFlag();
    }

    public int getMaxTextLength() {
        return this.updater.getMaxTextLength();
    }

    public void setMaxTextLength(int n) {
        this.updater.setMaxTextLength(n);
    }

    public synchronized void addToBuffer(String string) {
        this.buffer = this.buffer + string;
    }

    public synchronized String takeBuffer() {
        String string = this.buffer;
        this.buffer = "";
        return string;
    }

    public synchronized void setClearFlag() {
        this.clearFlag = true;
    }

    public synchronized boolean getClearFlag() {
        boolean bl = this.clearFlag;
        this.clearFlag = false;
        return bl;
    }

    public void notifySettings(PrismSettings prismSettings) {
        this.textArea.setFont(prismSettings.getFontColorPair((String)"log.font").f);
        this.textArea.setBackground(prismSettings.getColor("log.bgColour"));
        this.setMaxTextLength(prismSettings.getInteger("log.bufferLength"));
    }

    public boolean hasSelectedText() {
        return this.textArea != null && this.textArea.getSelectedText() != null;
    }

    public void copy() {
        if (this.textArea != null) {
            this.textArea.copy();
        }
    }

    public void selectAll() {
        if (this.textArea != null) {
            this.textArea.selectAll();
        }
    }

    class GUIWindowLogUpdater
    extends Thread {
        private GUIWindowLog gwl;
        private JTextArea textArea;
        private String text;
        private int textLen = 0;
        private int maxTextLen = 10000;
        private int updateDelay = 1000;

        public GUIWindowLogUpdater(GUIWindowLog gUIWindowLog2, JTextArea jTextArea) {
            this.gwl = gUIWindowLog2;
            this.textArea = jTextArea;
            this.text = "";
        }

        public int getMaxTextLength() {
            return this.maxTextLen;
        }

        public void setMaxTextLength(int n) {
            this.maxTextLen = n;
        }

        @Override
        public void run() {
            while (true) {
                String string;
                try {
                    Thread.sleep(this.updateDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.gwl.getClearFlag()) {
                    this.gwl.takeBuffer();
                    this.text = "";
                    this.textLen += 0;
                    SwingUtilities.invokeLater(new SetWindowLogText(this.textArea, this.text));
                }
                if ((string = this.gwl.takeBuffer()).length() <= 0) continue;
                this.text = this.text + string;
                this.textLen += string.length();
                if (this.textLen > this.maxTextLen) {
                    int n = this.textLen - this.maxTextLen;
                    int n2 = this.text.indexOf(10, n);
                    if (n2 != -1) {
                        n = n2 + 1;
                    }
                    this.text = this.text.substring(n);
                    this.textLen = this.text.length();
                }
                SwingUtilities.invokeLater(new SetWindowLogText(this.textArea, this.text));
            }
        }
    }

    private class SetWindowLogText
    extends Thread {
        private JTextArea textArea;
        private String s;

        public SetWindowLogText(JTextArea jTextArea, String string) {
            this.textArea = jTextArea;
            this.s = string;
        }

        @Override
        public void run() {
            try {
                this.textArea.replaceRange(this.s, 0, this.textArea.getLineEndOffset(this.textArea.getLineCount() - 1));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

